/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.HMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.StatisticsTestUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DatabaseType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.SQLAllTableConstraints;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.cache.CacheUtils;
import org.apache.hadoop.hive.metastore.cache.CachedStore;
import org.apache.hadoop.hive.metastore.cache.SharedCache;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.columnstats.ColStatsBuilder;
import org.apache.hadoop.hive.metastore.columnstats.cache.LongColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.model.MTable;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreCheckinTest.class})
public class TestCachedStore {
    Database db1;
    Database db2;
    Table db1Utbl1;
    Table db1Ptbl1;
    Table db2Utbl1;
    Table db2Ptbl1;
    List<Partition> db1Ptbl1Ptns;
    List<String> db1Ptbl1PtnNames;
    List<Partition> db2Ptbl1Ptns;
    List<String> db2Ptbl1PtnNames;

    @Before
    public void setUp() throws Exception {
        Deadline.registerIfNot((long)10000000L);
        Deadline.startTimer((String)"");
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        ObjectStore objectStore = new ObjectStore();
        objectStore.setConf(conf);
        HMSHandler.createDefaultCatalog((RawStore)objectStore, (Warehouse)new Warehouse(conf));
        this.db1 = this.createDatabaseObject("cs_db1", "user1");
        objectStore.createDatabase(this.db1);
        this.db2 = this.createDatabaseObject("cs_db2", "user1");
        objectStore.createDatabase(this.db2);
        this.db1Utbl1 = this.createUnpartitionedTableObject(this.db1);
        objectStore.createTable(this.db1Utbl1);
        this.db1Ptbl1 = this.createPartitionedTableObject(this.db1);
        objectStore.createTable(this.db1Ptbl1);
        this.db2Utbl1 = this.createUnpartitionedTableObject(this.db2);
        objectStore.createTable(this.db2Utbl1);
        this.db2Ptbl1 = this.createPartitionedTableObject(this.db2);
        objectStore.createTable(this.db2Ptbl1);
        this.db1Ptbl1Ptns = this.createPartitionObjects(this.db1Ptbl1).getPartitions();
        this.db1Ptbl1PtnNames = this.createPartitionObjects(this.db1Ptbl1).getPartitionNames();
        objectStore.addPartitions(this.db1Ptbl1.getCatName(), this.db1Ptbl1.getDbName(), this.db1Ptbl1.getTableName(), this.db1Ptbl1Ptns);
        this.db2Ptbl1Ptns = this.createPartitionObjects(this.db2Ptbl1).getPartitions();
        this.db2Ptbl1PtnNames = this.createPartitionObjects(this.db2Ptbl1).getPartitionNames();
        objectStore.addPartitions(this.db2Ptbl1.getCatName(), this.db2Ptbl1.getDbName(), this.db2Ptbl1.getTableName(), this.db2Ptbl1Ptns);
        objectStore.shutdown();
    }

    @After
    public void teardown() throws Exception {
        Deadline.startTimer((String)"");
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        ObjectStore objectStore = new ObjectStore();
        objectStore.setConf(conf);
        for (String clg : objectStore.getCatalogs()) {
            for (String db : objectStore.getAllDatabases(clg)) {
                for (String tbl : objectStore.getAllTables(clg, db)) {
                    List pts = objectStore.listPartitionNames(clg, db, tbl, (short)Short.MAX_VALUE);
                    objectStore.dropPartitions(clg, db, tbl, pts);
                    objectStore.dropTable(clg, db, tbl);
                }
                objectStore.dropDatabase(clg, db);
            }
            objectStore.dropCatalog(clg);
        }
        objectStore.shutdown();
        CachedStore.clearSharedCache();
    }

    @Test
    public void testPrewarm() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        ObjectStore objectStore = (ObjectStore)cachedStore.getRawStore();
        CachedStore.setCachePrewarmedState((boolean)false);
        CachedStore.prewarm((RawStore)objectStore);
        List allDatabases = cachedStore.getAllDatabases("hive");
        Assert.assertEquals((long)2L, (long)allDatabases.size());
        Assert.assertTrue((boolean)allDatabases.contains(this.db1.getName()));
        Assert.assertTrue((boolean)allDatabases.contains(this.db2.getName()));
        List db1Tables = cachedStore.getAllTables("hive", this.db1.getName());
        Assert.assertEquals((long)2L, (long)db1Tables.size());
        Assert.assertTrue((boolean)db1Tables.contains(this.db1Utbl1.getTableName()));
        Assert.assertTrue((boolean)db1Tables.contains(this.db1Ptbl1.getTableName()));
        List db2Tables = cachedStore.getAllTables("hive", this.db2.getName());
        Assert.assertEquals((long)2L, (long)db2Tables.size());
        Assert.assertTrue((boolean)db2Tables.contains(this.db2Utbl1.getTableName()));
        Assert.assertTrue((boolean)db2Tables.contains(this.db2Ptbl1.getTableName()));
        List db1Ptbl1Partitions = cachedStore.getPartitions("hive", this.db1.getName(), this.db1Ptbl1.getTableName(), -1);
        Assert.assertEquals((long)25L, (long)db1Ptbl1Partitions.size());
        Deadline.startTimer((String)"");
        List db1Ptbl1PartitionsOS = objectStore.getPartitions("hive", this.db2.getName(), this.db1Ptbl1.getTableName(), -1);
        Assert.assertTrue((boolean)db1Ptbl1Partitions.containsAll(db1Ptbl1PartitionsOS));
        List db2Ptbl1Partitions = cachedStore.getPartitions("hive", this.db2.getName(), this.db2Ptbl1.getTableName(), -1);
        Assert.assertEquals((long)25L, (long)db2Ptbl1Partitions.size());
        Deadline.startTimer((String)"");
        List db2Ptbl1PartitionsOS = objectStore.getPartitions("hive", this.db2.getName(), this.db2Ptbl1.getTableName(), -1);
        Assert.assertTrue((boolean)db2Ptbl1Partitions.containsAll(db2Ptbl1PartitionsOS));
        cachedStore.shutdown();
    }

    @Test
    public void testPrewarmBlackList() {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_CACHED_OBJECTS_BLACKLIST, (String)"hive.cs_db2.*");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        ObjectStore objectStore = (ObjectStore)cachedStore.getRawStore();
        CachedStore.setCachePrewarmedState((boolean)false);
        CachedStore.prewarm((RawStore)objectStore);
        SharedCache sharedCache = CachedStore.getSharedCache();
        List db1Tables = sharedCache.listCachedTableNames("hive", this.db1.getName());
        Assert.assertEquals((long)2L, (long)db1Tables.size());
        List db2Tables = sharedCache.listCachedTableNames("hive", this.db2.getName());
        Assert.assertEquals((long)0L, (long)db2Tables.size());
        cachedStore.shutdown();
    }

    @Test
    public void testPrewarmWhiteList() {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_CACHED_OBJECTS_WHITELIST, (String)"hive.cs_db1.*");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        ObjectStore objectStore = (ObjectStore)cachedStore.getRawStore();
        CachedStore.setCachePrewarmedState((boolean)false);
        CachedStore.prewarm((RawStore)objectStore);
        SharedCache sharedCache = CachedStore.getSharedCache();
        List db1Tables = sharedCache.listCachedTableNames("hive", this.db1.getName());
        Assert.assertEquals((long)2L, (long)db1Tables.size());
        List db2Tables = sharedCache.listCachedTableNames("hive", this.db2.getName());
        Assert.assertEquals((long)0L, (long)db2Tables.size());
        cachedStore.shutdown();
    }

    public void testPrewarmMemoryEstimation() {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"44Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        ObjectStore objectStore = (ObjectStore)cachedStore.getRawStore();
        CachedStore.setCachePrewarmedState((boolean)false);
        CachedStore.prewarm((RawStore)objectStore);
        SharedCache sharedCache = CachedStore.getSharedCache();
        List db1Tables = sharedCache.listCachedTableNames("hive", this.db1.getName());
        Assert.assertEquals((long)2L, (long)db1Tables.size());
        List db2Tables = sharedCache.listCachedTableNames("hive", this.db2.getName());
        Assert.assertEquals((long)0L, (long)db2Tables.size());
        cachedStore.shutdown();
    }

    @Test
    public void testCacheUpdate() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        ObjectStore objectStore = (ObjectStore)cachedStore.getRawStore();
        CachedStore.setCachePrewarmedState((boolean)false);
        CachedStore.prewarm((RawStore)objectStore);
        objectStore.dropTable("hive", this.db1Utbl1.getDbName(), this.db1Utbl1.getTableName());
        Deadline.startTimer((String)"");
        objectStore.dropPartitions("hive", this.db1Ptbl1.getDbName(), this.db1Ptbl1.getTableName(), this.db1Ptbl1PtnNames);
        this.updateCache(cachedStore);
        List allDatabases = cachedStore.getAllDatabases("hive");
        Assert.assertEquals((long)2L, (long)allDatabases.size());
        Assert.assertTrue((boolean)allDatabases.contains(this.db1.getName()));
        Assert.assertTrue((boolean)allDatabases.contains(this.db2.getName()));
        List db1Tbls = cachedStore.getAllTables("hive", this.db1.getName());
        Assert.assertEquals((long)1L, (long)db1Tbls.size());
        Assert.assertTrue((boolean)db1Tbls.contains(this.db1Ptbl1.getTableName()));
        List db1Ptns = cachedStore.getPartitions("hive", this.db1.getName(), this.db1Ptbl1.getTableName(), -1);
        Assert.assertEquals((long)0L, (long)db1Ptns.size());
        List db2Tbls = cachedStore.getAllTables("hive", this.db2.getName());
        Assert.assertEquals((long)2L, (long)db2Tbls.size());
        Assert.assertTrue((boolean)db2Tbls.contains(this.db2Utbl1.getTableName()));
        Assert.assertTrue((boolean)db2Tbls.contains(this.db2Ptbl1.getTableName()));
        List db2Ptns = cachedStore.getPartitions("hive", this.db2.getName(), this.db2Ptbl1.getTableName(), -1);
        Assert.assertEquals((long)25L, (long)db2Ptns.size());
        Deadline.startTimer((String)"");
        List db2PtnsOS = objectStore.getPartitions("hive", this.db2.getName(), this.db2Ptbl1.getTableName(), -1);
        Assert.assertTrue((boolean)db2Ptns.containsAll(db2PtnsOS));
        Table db1Utbl2 = this.createUnpartitionedTableObject(this.db1);
        db1Utbl2.setTableName(this.db1.getName() + "_unptntbl2");
        objectStore.createTable(db1Utbl2);
        this.db1Ptbl1Ptns = this.createPartitionObjects(this.db1Ptbl1).getPartitions();
        Deadline.startTimer((String)"");
        objectStore.addPartition(this.db1Ptbl1Ptns.get(0));
        objectStore.addPartition(this.db1Ptbl1Ptns.get(1));
        objectStore.addPartition(this.db1Ptbl1Ptns.get(2));
        objectStore.addPartition(this.db1Ptbl1Ptns.get(3));
        objectStore.addPartition(this.db1Ptbl1Ptns.get(4));
        this.updateCache(cachedStore);
        allDatabases = cachedStore.getAllDatabases("hive");
        Assert.assertEquals((long)2L, (long)allDatabases.size());
        Assert.assertTrue((boolean)allDatabases.contains(this.db1.getName()));
        Assert.assertTrue((boolean)allDatabases.contains(this.db2.getName()));
        db1Tbls = cachedStore.getAllTables("hive", this.db1.getName());
        Assert.assertEquals((long)2L, (long)db1Tbls.size());
        Assert.assertTrue((boolean)db1Tbls.contains(this.db1Ptbl1.getTableName()));
        Assert.assertTrue((boolean)db1Tbls.contains(db1Utbl2.getTableName()));
        db2Tbls = cachedStore.getAllTables("hive", this.db2.getName());
        Assert.assertEquals((long)2L, (long)db2Tbls.size());
        Assert.assertTrue((boolean)db2Tbls.contains(this.db2Utbl1.getTableName()));
        Assert.assertTrue((boolean)db2Tbls.contains(this.db2Ptbl1.getTableName()));
        db1Ptns = cachedStore.getPartitions("hive", this.db1.getName(), this.db1Ptbl1.getTableName(), -1);
        Assert.assertEquals((long)5L, (long)db1Ptns.size());
        db2Ptns = cachedStore.getPartitions("hive", this.db2.getName(), this.db2Ptbl1.getTableName(), -1);
        Assert.assertEquals((long)25L, (long)db2Ptns.size());
        Deadline.startTimer((String)"");
        db2PtnsOS = objectStore.getPartitions("hive", this.db2.getName(), this.db2Ptbl1.getTableName(), -1);
        Assert.assertTrue((boolean)db2Ptns.containsAll(db2PtnsOS));
        objectStore.dropTable("hive", db1Utbl2.getDbName(), db1Utbl2.getTableName());
        cachedStore.shutdown();
    }

    @Test
    public void testCacheUpdatePartitionColStats() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        ObjectStore objectStore = new ObjectStore();
        objectStore.setConf(conf);
        Database tpcdsdb = this.createDatabaseObject("tpcdsdb", "user1");
        objectStore.createDatabase(tpcdsdb);
        FieldSchema soldDateCol = new FieldSchema("ss_sold_date_sk", "int", "");
        FieldSchema customerCol = new FieldSchema("ss_customer_sk", "int", "");
        List<FieldSchema> columns = Arrays.asList(soldDateCol, customerCol);
        List<FieldSchema> partitionsColumns = Collections.singletonList(soldDateCol);
        Table salesTable = this.createTable(tpcdsdb.getName(), "store_sales", this.createStorageDescriptor(columns), partitionsColumns);
        objectStore.createTable(salesTable);
        MTable salesMTable = objectStore.ensureGetMTable(salesTable.getCatName(), salesTable.getDbName(), salesTable.getTableName());
        HashMap<String, ColumnStatisticsData> partitionStats = new HashMap<String, ColumnStatisticsData>();
        ColumnStatisticsData data1 = new ColStatsBuilder<Long>(Long.TYPE).numNulls(100L).numDVs(50L).hll(1L, 2L, 3L).kll(1L, 2L, 3L).build();
        partitionStats.put("1999", data1);
        ColumnStatisticsData data2 = new ColStatsBuilder<Long>(Long.TYPE).numNulls(200L).numDVs(100L).hll(1L, 2L, 3L, 4L).kll(1L, 2L, 3L, 4L).build();
        partitionStats.put("2000", data2);
        ArrayList<String> partNames = new ArrayList<String>();
        for (Map.Entry pStat : partitionStats.entrySet()) {
            List<String> partitionValue = Collections.singletonList((String)pStat.getKey());
            Partition p = this.createPartition(salesTable, partitionValue);
            objectStore.addPartition(p);
            String pName = FileUtils.makePartName(Collections.singletonList(soldDateCol.getName()), partitionValue);
            partNames.add(pName);
            ColumnStatistics stats = StatisticsTestUtils.createColumnStatistics((ColumnStatisticsData)pStat.getValue(), salesTable, soldDateCol, pName);
            objectStore.updatePartitionColumnStatistics(salesTable, salesMTable, stats, partitionValue, null, -1L);
        }
        List rawStats = objectStore.getPartitionColumnStatistics("hive", salesTable.getDbName(), salesTable.getTableName(), partNames, Collections.singletonList(soldDateCol.getName()), "hive");
        objectStore.shutdown();
        CachedStore cachedStore = new CachedStore();
        cachedStore.setConfForTest(conf);
        this.updateCache(cachedStore);
        List cachedStats = CachedStore.getSharedCache().getPartitionColStatsListFromCache("hive", salesTable.getDbName(), salesTable.getTableName(), partNames, Collections.singletonList(soldDateCol.getName()), null, true);
        Assert.assertNotNull((Object)rawStats);
        Assert.assertNotNull((Object)cachedStats);
        Assert.assertEquals((long)rawStats.size(), (long)cachedStats.size());
        for (int i = 0; i < rawStats.size(); ++i) {
            this.assertLongStatsEquals((ColumnStatistics)rawStats.get(i), (ColumnStatistics)cachedStats.get(i));
        }
        cachedStore.shutdown();
    }

    @Test
    public void testCreateAndGetDatabase() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        ObjectStore objectStore = (ObjectStore)cachedStore.getRawStore();
        String dbName = "testCreateAndGetDatabase";
        String dbOwner = "user1";
        Database db = this.createDatabaseObject(dbName, dbOwner);
        objectStore.createDatabase(db);
        db = objectStore.getDatabase("hive", dbName);
        CachedStore.setCachePrewarmedState((boolean)false);
        CachedStore.prewarm((RawStore)objectStore);
        Database dbRead = cachedStore.getDatabase("hive", dbName);
        Assert.assertEquals((Object)db, (Object)dbRead);
        List allDatabases = cachedStore.getAllDatabases("hive");
        Assert.assertEquals((long)3L, (long)allDatabases.size());
        String dbName1 = "testCreateAndGetDatabase1";
        Database localDb1 = this.createDatabaseObject(dbName1, dbOwner);
        cachedStore.createDatabase(localDb1);
        localDb1 = cachedStore.getDatabase("hive", dbName1);
        dbRead = objectStore.getDatabase("hive", dbName1);
        Assert.assertEquals((Object)localDb1, (Object)dbRead);
        allDatabases = cachedStore.getAllDatabases("hive");
        Assert.assertEquals((long)4L, (long)allDatabases.size());
        objectStore.dropDatabase("hive", dbName);
        objectStore.dropDatabase("hive", dbName1);
        cachedStore.shutdown();
    }

    @Test
    public void testDropDatabase() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        ObjectStore objectStore = (ObjectStore)cachedStore.getRawStore();
        String dbName = "testDropDatabase";
        String dbOwner = "user1";
        Database db = this.createDatabaseObject(dbName, dbOwner);
        objectStore.createDatabase(db);
        db = objectStore.getDatabase("hive", dbName);
        CachedStore.setCachePrewarmedState((boolean)false);
        CachedStore.prewarm((RawStore)objectStore);
        Database dbRead = cachedStore.getDatabase("hive", dbName);
        Assert.assertEquals((Object)db, (Object)dbRead);
        List allDatabases = cachedStore.getAllDatabases("hive");
        Assert.assertEquals((long)3L, (long)allDatabases.size());
        cachedStore.dropDatabase("hive", dbName);
        allDatabases = objectStore.getAllDatabases("hive");
        Assert.assertEquals((long)2L, (long)allDatabases.size());
        String dbName1 = "testDropDatabase1";
        Database localDb1 = this.createDatabaseObject(dbName1, dbOwner);
        cachedStore.createDatabase(localDb1);
        localDb1 = cachedStore.getDatabase("hive", dbName1);
        dbRead = objectStore.getDatabase("hive", dbName1);
        Assert.assertEquals((Object)localDb1, (Object)dbRead);
        allDatabases = cachedStore.getAllDatabases("hive");
        Assert.assertEquals((long)3L, (long)allDatabases.size());
        objectStore.dropDatabase("hive", dbName1);
        this.updateCache(cachedStore);
        this.updateCache(cachedStore);
        allDatabases = cachedStore.getAllDatabases("hive");
        Assert.assertEquals((long)2L, (long)allDatabases.size());
        cachedStore.shutdown();
    }

    @Test
    public void testAlterDatabase() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        ObjectStore objectStore = (ObjectStore)cachedStore.getRawStore();
        CachedStore.setCachePrewarmedState((boolean)false);
        CachedStore.prewarm((RawStore)objectStore);
        List allDatabases = cachedStore.getAllDatabases("hive");
        Assert.assertEquals((long)2L, (long)allDatabases.size());
        String dbOwner = "user2";
        Database db = new Database(this.db1);
        db.setOwnerName(dbOwner);
        String dbName = this.db1.getName();
        cachedStore.alterDatabase("hive", dbName, db);
        db = cachedStore.getDatabase("hive", dbName);
        Database dbRead = objectStore.getDatabase("hive", dbName);
        Assert.assertEquals((Object)db, (Object)dbRead);
        dbOwner = "user3";
        db = new Database(this.db1);
        db.setOwnerName(dbOwner);
        objectStore.alterDatabase("hive", dbName, db);
        db = objectStore.getDatabase("hive", dbName);
        this.updateCache(cachedStore);
        this.updateCache(cachedStore);
        dbRead = cachedStore.getDatabase("hive", dbName);
        Assert.assertEquals((Object)db, (Object)dbRead);
        cachedStore.shutdown();
    }

    @Test
    public void testCreateAndGetTable() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        ObjectStore objectStore = (ObjectStore)cachedStore.getRawStore();
        CachedStore.setCachePrewarmedState((boolean)false);
        CachedStore.prewarm((RawStore)objectStore);
        List allDatabases = cachedStore.getAllDatabases("hive");
        Assert.assertEquals((long)2L, (long)allDatabases.size());
        List db1Tables = cachedStore.getAllTables("hive", this.db1.getName());
        Assert.assertEquals((long)2L, (long)db1Tables.size());
        List db2Tables = cachedStore.getAllTables("hive", this.db2.getName());
        Assert.assertEquals((long)2L, (long)db2Tables.size());
        Table db1Utbl2 = this.createUnpartitionedTableObject(this.db1);
        db1Utbl2.setTableName(this.db1.getName() + "_unptntbl2");
        cachedStore.createTable(db1Utbl2);
        db1Tables = cachedStore.getAllTables("hive", this.db1.getName());
        Assert.assertEquals((long)3L, (long)db1Tables.size());
        db1Utbl2 = cachedStore.getTable("hive", db1Utbl2.getDbName(), db1Utbl2.getTableName());
        Table tblRead = objectStore.getTable("hive", db1Utbl2.getDbName(), db1Utbl2.getTableName());
        Assert.assertEquals((Object)db1Utbl2, (Object)tblRead);
        Table db2Utbl2 = this.createUnpartitionedTableObject(this.db2);
        db2Utbl2.setTableName(this.db2.getName() + "_unptntbl2");
        objectStore.createTable(db2Utbl2);
        db2Utbl2 = objectStore.getTable("hive", db2Utbl2.getDbName(), db2Utbl2.getTableName());
        this.updateCache(cachedStore);
        db2Tables = cachedStore.getAllTables("hive", this.db2.getName());
        Assert.assertEquals((long)3L, (long)db2Tables.size());
        tblRead = cachedStore.getTable("hive", db2Utbl2.getDbName(), db2Utbl2.getTableName());
        Assert.assertEquals((Object)db2Utbl2, (Object)tblRead);
        objectStore.dropTable("hive", db1Utbl2.getDbName(), db1Utbl2.getTableName());
        db1Utbl2 = cachedStore.getTable("hive", db1Utbl2.getDbName(), db1Utbl2.getTableName());
        objectStore.dropTable("hive", db2Utbl2.getDbName(), db2Utbl2.getTableName());
        cachedStore.shutdown();
    }

    public void testGetAllTablesPrewarmMemoryLimit() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"44Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        ObjectStore objectStore = (ObjectStore)cachedStore.getRawStore();
        CachedStore.setCachePrewarmedState((boolean)false);
        CachedStore.prewarm((RawStore)objectStore);
        SharedCache sharedCache = CachedStore.getSharedCache();
        List db1Tables = sharedCache.listCachedTableNames("hive", this.db1.getName());
        Assert.assertEquals((long)2L, (long)db1Tables.size());
        List db2Tables = sharedCache.listCachedTableNames("hive", this.db2.getName());
        Assert.assertEquals((long)0L, (long)db2Tables.size());
        List db2TablesCS = cachedStore.getAllTables("hive", this.db2.getName());
        Assert.assertEquals((long)2L, (long)db2TablesCS.size());
        cachedStore.shutdown();
    }

    @Test
    public void testGetAllTablesBlacklist() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_CACHED_OBJECTS_BLACKLIST, (String)"hive.cs_db2.*");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        ObjectStore objectStore = (ObjectStore)cachedStore.getRawStore();
        CachedStore.setCachePrewarmedState((boolean)false);
        CachedStore.prewarm((RawStore)objectStore);
        SharedCache sharedCache = CachedStore.getSharedCache();
        List db1Tables = sharedCache.listCachedTableNames("hive", this.db1.getName());
        Assert.assertEquals((long)2L, (long)db1Tables.size());
        List db2Tables = sharedCache.listCachedTableNames("hive", this.db2.getName());
        Assert.assertEquals((long)0L, (long)db2Tables.size());
        List db2TablesCS = cachedStore.getAllTables("hive", this.db2.getName());
        Assert.assertEquals((long)2L, (long)db2TablesCS.size());
        cachedStore.shutdown();
    }

    @Test
    public void testGetAllTablesWhitelist() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_CACHED_OBJECTS_WHITELIST, (String)"hive.cs_db1.*");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        ObjectStore objectStore = (ObjectStore)cachedStore.getRawStore();
        CachedStore.setCachePrewarmedState((boolean)false);
        CachedStore.prewarm((RawStore)objectStore);
        SharedCache sharedCache = CachedStore.getSharedCache();
        List db1Tables = sharedCache.listCachedTableNames("hive", this.db1.getName());
        Assert.assertEquals((long)2L, (long)db1Tables.size());
        List db2Tables = sharedCache.listCachedTableNames("hive", this.db2.getName());
        Assert.assertEquals((long)0L, (long)db2Tables.size());
        List db2TablesCS = cachedStore.getAllTables("hive", this.db2.getName());
        Assert.assertEquals((long)2L, (long)db2TablesCS.size());
        cachedStore.shutdown();
    }

    @Test
    public void testGetTableByPattern() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        ObjectStore objectStore = (ObjectStore)cachedStore.getRawStore();
        CachedStore.setCachePrewarmedState((boolean)false);
        CachedStore.prewarm((RawStore)objectStore);
        List db1Tables = cachedStore.getTables("hive", this.db1.getName(), "cs_db1.*");
        Assert.assertEquals((long)2L, (long)db1Tables.size());
        db1Tables = cachedStore.getTables("hive", this.db1.getName(), "cs_db1.un*");
        Assert.assertEquals((long)1L, (long)db1Tables.size());
        db1Tables = cachedStore.getTables("hive", this.db1.getName(), ".*tbl1");
        Assert.assertEquals((long)2L, (long)db1Tables.size());
        db1Tables = cachedStore.getTables("hive", this.db1.getName(), ".*tbl1", TableType.MANAGED_TABLE, 1);
        Assert.assertEquals((long)1L, (long)db1Tables.size());
        db1Tables = cachedStore.getTables("hive", this.db1.getName(), ".*tbl1", TableType.MANAGED_TABLE, -1);
        Assert.assertEquals((long)2L, (long)db1Tables.size());
        cachedStore.shutdown();
    }

    @Test
    public void testAlterTable() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        ObjectStore objectStore = (ObjectStore)cachedStore.getRawStore();
        CachedStore.setCachePrewarmedState((boolean)false);
        CachedStore.prewarm((RawStore)objectStore);
        List db1Tables = cachedStore.getAllTables("hive", this.db1.getName());
        Assert.assertEquals((long)2L, (long)db1Tables.size());
        List db2Tables = cachedStore.getAllTables("hive", this.db2.getName());
        Assert.assertEquals((long)2L, (long)db2Tables.size());
        Table db1Utbl1Read = cachedStore.getTable("hive", this.db1Utbl1.getDbName(), this.db1Utbl1.getTableName());
        String newOwner = "newOwner";
        Table db1Utbl1ReadAlt = new Table(db1Utbl1Read);
        db1Utbl1ReadAlt.setOwner(newOwner);
        cachedStore.alterTable("hive", db1Utbl1Read.getDbName(), db1Utbl1Read.getTableName(), db1Utbl1ReadAlt, "0");
        db1Utbl1Read = cachedStore.getTable("hive", db1Utbl1ReadAlt.getDbName(), db1Utbl1ReadAlt.getTableName());
        Table db1Utbl1ReadOS = objectStore.getTable("hive", db1Utbl1ReadAlt.getDbName(), db1Utbl1ReadAlt.getTableName());
        Assert.assertEquals((Object)db1Utbl1Read, (Object)db1Utbl1ReadOS);
        Table db2Utbl1Read = objectStore.getTable("hive", this.db2Utbl1.getDbName(), this.db2Utbl1.getTableName());
        Table db2Utbl1ReadAlt = new Table(db2Utbl1Read);
        db2Utbl1ReadAlt.setOwner(newOwner);
        objectStore.alterTable("hive", db2Utbl1Read.getDbName(), db2Utbl1Read.getTableName(), db2Utbl1ReadAlt, "0");
        this.updateCache(cachedStore);
        db2Utbl1Read = objectStore.getTable("hive", db2Utbl1ReadAlt.getDbName(), db2Utbl1ReadAlt.getTableName());
        Table d21Utbl1ReadCS = cachedStore.getTable("hive", db2Utbl1ReadAlt.getDbName(), db2Utbl1ReadAlt.getTableName());
        Assert.assertEquals((Object)db2Utbl1Read, (Object)d21Utbl1ReadCS);
        cachedStore.shutdown();
    }

    @Test
    public void testDropTable() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        ObjectStore objectStore = (ObjectStore)cachedStore.getRawStore();
        CachedStore.setCachePrewarmedState((boolean)false);
        CachedStore.prewarm((RawStore)objectStore);
        List db1Tables = cachedStore.getAllTables("hive", this.db1.getName());
        Assert.assertEquals((long)2L, (long)db1Tables.size());
        List db2Tables = cachedStore.getAllTables("hive", this.db2.getName());
        Assert.assertEquals((long)2L, (long)db2Tables.size());
        Table db1Utbl1Read = cachedStore.getTable("hive", this.db1Utbl1.getDbName(), this.db1Utbl1.getTableName());
        cachedStore.dropTable("hive", db1Utbl1Read.getDbName(), db1Utbl1Read.getTableName());
        db1Tables = cachedStore.getAllTables("hive", this.db1.getName());
        Assert.assertEquals((long)1L, (long)db1Tables.size());
        Table db1Utbl1ReadOS = objectStore.getTable("hive", db1Utbl1Read.getDbName(), db1Utbl1Read.getTableName());
        Assert.assertNull((Object)db1Utbl1ReadOS);
        Table db2Utbl1Read = objectStore.getTable("hive", this.db2Utbl1.getDbName(), this.db2Utbl1.getTableName());
        objectStore.dropTable("hive", db2Utbl1Read.getDbName(), db2Utbl1Read.getTableName());
        db2Tables = objectStore.getAllTables("hive", this.db2.getName());
        Assert.assertEquals((long)1L, (long)db2Tables.size());
        this.updateCache(cachedStore);
        db2Tables = cachedStore.getAllTables("hive", this.db2.getName());
        Assert.assertEquals((long)1L, (long)db2Tables.size());
        Table db2Utbl1ReadCS = cachedStore.getTable("hive", db2Utbl1Read.getDbName(), db2Utbl1Read.getTableName());
        Assert.assertNull((Object)db2Utbl1ReadCS);
        cachedStore.shutdown();
    }

    @Test
    public void testSharedStoreDb() {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        SharedCache sharedCache = CachedStore.getSharedCache();
        Database localDb1 = this.createDatabaseObject("db1", "user1");
        Database localDb2 = this.createDatabaseObject("db2", "user1");
        Database localDb3 = this.createDatabaseObject("db3", "user1");
        Database newDb1 = this.createDatabaseObject("newdb1", "user1");
        sharedCache.addDatabaseToCache(localDb1);
        sharedCache.addDatabaseToCache(localDb2);
        sharedCache.addDatabaseToCache(localDb3);
        Assert.assertEquals((long)3L, (long)sharedCache.getCachedDatabaseCount());
        sharedCache.alterDatabaseInCache("hive", "db1", newDb1);
        Assert.assertEquals((long)3L, (long)sharedCache.getCachedDatabaseCount());
        sharedCache.removeDatabaseFromCache("hive", "db2");
        Assert.assertEquals((long)2L, (long)sharedCache.getCachedDatabaseCount());
        List dbs = sharedCache.listCachedDatabases("hive");
        Assert.assertEquals((long)2L, (long)dbs.size());
        Assert.assertTrue((boolean)dbs.contains("newdb1"));
        Assert.assertTrue((boolean)dbs.contains("db3"));
        cachedStore.shutdown();
    }

    @Test
    public void testSharedStoreTable() {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        SharedCache sharedCache = CachedStore.getSharedCache();
        Table tbl1 = new Table();
        StorageDescriptor sd1 = new StorageDescriptor();
        ArrayList<FieldSchema> cols1 = new ArrayList<FieldSchema>();
        cols1.add(new FieldSchema("col1", "int", ""));
        HashMap<String, String> params1 = new HashMap<String, String>();
        params1.put("key", "value");
        sd1.setCols(cols1);
        sd1.setParameters(params1);
        sd1.setLocation("loc1");
        tbl1.setSd(sd1);
        tbl1.setPartitionKeys(new ArrayList());
        Table tbl2 = new Table();
        StorageDescriptor sd2 = new StorageDescriptor();
        ArrayList<FieldSchema> cols2 = new ArrayList<FieldSchema>();
        cols2.add(new FieldSchema("col1", "int", ""));
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("key", "value");
        sd2.setCols(cols2);
        sd2.setParameters(params2);
        sd2.setLocation("loc2");
        tbl2.setSd(sd2);
        tbl2.setPartitionKeys(new ArrayList());
        Table tbl3 = new Table();
        StorageDescriptor sd3 = new StorageDescriptor();
        ArrayList<FieldSchema> cols3 = new ArrayList<FieldSchema>();
        cols3.add(new FieldSchema("col3", "int", ""));
        HashMap<String, String> params3 = new HashMap<String, String>();
        params3.put("key2", "value2");
        sd3.setCols(cols3);
        sd3.setParameters(params3);
        sd3.setLocation("loc3");
        tbl3.setSd(sd3);
        tbl3.setPartitionKeys(new ArrayList());
        Table newTbl1 = new Table();
        newTbl1.setDbName("db2");
        newTbl1.setTableName("tbl1");
        StorageDescriptor newSd1 = new StorageDescriptor();
        ArrayList<FieldSchema> newCols1 = new ArrayList<FieldSchema>();
        newCols1.add(new FieldSchema("newcol1", "int", ""));
        HashMap<String, String> newParams1 = new HashMap<String, String>();
        newParams1.put("key", "value");
        newSd1.setCols(newCols1);
        newSd1.setParameters(newParams1);
        newSd1.setLocation("loc1");
        newTbl1.setSd(newSd1);
        newTbl1.setPartitionKeys(new ArrayList());
        sharedCache.addTableToCache("hive", "db1", "tbl1", tbl1);
        sharedCache.addTableToCache("hive", "db1", "tbl2", tbl2);
        sharedCache.addTableToCache("hive", "db1", "tbl3", tbl3);
        sharedCache.addTableToCache("hive", "db2", "tbl1", tbl1);
        Assert.assertEquals((long)4L, (long)sharedCache.getCachedTableCount());
        Assert.assertEquals((long)2L, (long)sharedCache.getSdCache().size());
        Table t = sharedCache.getTableFromCache("hive", "db1", "tbl1");
        Assert.assertEquals((Object)"loc1", (Object)t.getSd().getLocation());
        sharedCache.removeTableFromCache("hive", "db1", "tbl1");
        Assert.assertEquals((long)3L, (long)sharedCache.getCachedTableCount());
        Assert.assertEquals((long)2L, (long)sharedCache.getSdCache().size());
        sharedCache.alterTableInCache("hive", "db2", "tbl1", newTbl1);
        Assert.assertEquals((long)3L, (long)sharedCache.getCachedTableCount());
        Assert.assertEquals((long)3L, (long)sharedCache.getSdCache().size());
        sharedCache.removeTableFromCache("hive", "db1", "tbl2");
        Assert.assertEquals((long)2L, (long)sharedCache.getCachedTableCount());
        Assert.assertEquals((long)2L, (long)sharedCache.getSdCache().size());
        cachedStore.shutdown();
    }

    @Test
    public void testSharedStorePartition() {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        SharedCache sharedCache = CachedStore.getSharedCache();
        String dbName = "db1";
        String tbl1Name = "tbl1";
        String tbl2Name = "tbl2";
        String owner = "user1";
        Database db = this.createDatabaseObject(dbName, owner);
        sharedCache.addDatabaseToCache(db);
        FieldSchema col1 = new FieldSchema("col1", "int", "integer column");
        FieldSchema col2 = new FieldSchema("col2", "string", "string column");
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(col1);
        cols.add(col2);
        ArrayList<FieldSchema> ptnCols = new ArrayList<FieldSchema>();
        StorageDescriptor sd = this.createStorageDescriptor(cols);
        Table tbl1 = this.createTable(dbName, tbl1Name, sd, ptnCols);
        sharedCache.addTableToCache("hive", dbName, tbl1Name, tbl1);
        Table tbl2 = this.createTable(dbName, tbl2Name, sd, ptnCols);
        sharedCache.addTableToCache("hive", dbName, tbl2Name, tbl2);
        Partition part1 = new Partition();
        StorageDescriptor sd1 = new StorageDescriptor();
        ArrayList<FieldSchema> cols1 = new ArrayList<FieldSchema>();
        cols1.add(new FieldSchema("col1", "int", ""));
        HashMap<String, String> params1 = new HashMap<String, String>();
        params1.put("key", "value");
        sd1.setCols(cols1);
        sd1.setParameters(params1);
        sd1.setLocation("loc1");
        part1.setSd(sd1);
        part1.setValues(Collections.singletonList("201701"));
        Partition part2 = new Partition();
        StorageDescriptor sd2 = new StorageDescriptor();
        ArrayList<FieldSchema> cols2 = new ArrayList<FieldSchema>();
        cols2.add(new FieldSchema("col1", "int", ""));
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("key", "value");
        sd2.setCols(cols2);
        sd2.setParameters(params2);
        sd2.setLocation("loc2");
        part2.setSd(sd2);
        part2.setValues(Collections.singletonList("201702"));
        Partition part3 = new Partition();
        StorageDescriptor sd3 = new StorageDescriptor();
        ArrayList<FieldSchema> cols3 = new ArrayList<FieldSchema>();
        cols3.add(new FieldSchema("col3", "int", ""));
        HashMap<String, String> params3 = new HashMap<String, String>();
        params3.put("key2", "value2");
        sd3.setCols(cols3);
        sd3.setParameters(params3);
        sd3.setLocation("loc3");
        part3.setSd(sd3);
        part3.setValues(Collections.singletonList("201703"));
        Partition newPart1 = new Partition();
        newPart1.setDbName(dbName);
        newPart1.setTableName(tbl1Name);
        StorageDescriptor newSd1 = new StorageDescriptor();
        ArrayList<FieldSchema> newCols1 = new ArrayList<FieldSchema>();
        newCols1.add(new FieldSchema("newcol1", "int", ""));
        HashMap<String, String> newParams1 = new HashMap<String, String>();
        newParams1.put("key", "value");
        newSd1.setCols(newCols1);
        newSd1.setParameters(newParams1);
        newSd1.setLocation("loc1new");
        newPart1.setSd(newSd1);
        newPart1.setValues(Collections.singletonList("201701"));
        sharedCache.addPartitionToCache("hive", dbName, tbl1Name, part1);
        sharedCache.addPartitionToCache("hive", dbName, tbl1Name, part2);
        sharedCache.addPartitionToCache("hive", dbName, tbl1Name, part3);
        sharedCache.addPartitionToCache("hive", dbName, tbl2Name, part1);
        Partition t = sharedCache.getPartitionFromCache("hive", dbName, tbl1Name, Collections.singletonList("201701"));
        Assert.assertEquals((Object)"loc1", (Object)t.getSd().getLocation());
        sharedCache.removePartitionFromCache("hive", dbName, tbl2Name, Collections.singletonList("201701"));
        t = sharedCache.getPartitionFromCache("hive", dbName, tbl2Name, Collections.singletonList("201701"));
        Assert.assertNull((Object)t);
        sharedCache.alterPartitionInCache("hive", dbName, tbl1Name, Collections.singletonList("201701"), newPart1);
        t = sharedCache.getPartitionFromCache("hive", dbName, tbl1Name, Collections.singletonList("201701"));
        Assert.assertEquals((Object)"loc1new", (Object)t.getSd().getLocation());
        cachedStore.shutdown();
    }

    public void testAggrStatsRepeatedRead() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        ObjectStore objectStore = (ObjectStore)cachedStore.getRawStore();
        String dbName = "testTableColStatsOps";
        String tblName = "tbl";
        String colName = "f1";
        Database db = new DatabaseBuilder().setName(dbName).setLocation("some_location").build(conf);
        cachedStore.createDatabase(db);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema(colName, "int", null));
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("col", "int", null));
        StorageDescriptor sd = new StorageDescriptor(cols, null, "input", "output", false, 0, new SerDeInfo("serde", "seriallib", new HashMap()), null, null, null);
        Table tbl = new Table(tblName, dbName, null, 0, 0, 0, sd, partCols, new HashMap(), null, null, TableType.MANAGED_TABLE.toString());
        tbl.setCatName("hive");
        cachedStore.createTable(tbl);
        ArrayList<String> partVals1 = new ArrayList<String>();
        partVals1.add("1");
        ArrayList<String> partVals2 = new ArrayList<String>();
        partVals2.add("2");
        Partition ptn1 = this.createPartition(tbl, partVals1);
        ptn1.setCatName("hive");
        cachedStore.addPartition(ptn1);
        Partition ptn2 = this.createPartition(tbl, partVals2);
        ptn2.setCatName("hive");
        cachedStore.addPartition(ptn2);
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc statsDesc = new ColumnStatisticsDesc(true, dbName, tblName);
        statsDesc.setPartName("col");
        ArrayList<ColumnStatisticsObj> colStatObjs = new ArrayList<ColumnStatisticsObj>();
        ColumnStatisticsData data = new ColumnStatisticsData();
        ColumnStatisticsObj colStats = new ColumnStatisticsObj(colName, "int", data);
        LongColumnStatsDataInspector longStats = new LongColumnStatsDataInspector();
        longStats.setLowValue(0L);
        longStats.setHighValue(100L);
        longStats.setNumNulls(50L);
        longStats.setNumDVs(30L);
        data.setLongStats((LongColumnStatsData)longStats);
        colStatObjs.add(colStats);
        stats.setStatsDesc(statsDesc);
        stats.setStatsObj(colStatObjs);
        stats.setEngine("hive");
        cachedStore.updatePartitionColumnStatistics(stats.deepCopy(), partVals1, null, -1L);
        cachedStore.updatePartitionColumnStatistics(stats.deepCopy(), partVals2, null, -1L);
        ArrayList<String> colNames = new ArrayList<String>();
        colNames.add(colName);
        ArrayList<String> aggrPartVals = new ArrayList<String>();
        aggrPartVals.add("1");
        aggrPartVals.add("2");
        AggrStats aggrStats = cachedStore.get_aggr_stats_for("hive", dbName, tblName, aggrPartVals, colNames, "hive");
        Assert.assertEquals((long)100L, (long)((ColumnStatisticsObj)aggrStats.getColStats().get(0)).getStatsData().getLongStats().getNumNulls());
        aggrStats = cachedStore.get_aggr_stats_for("hive", dbName, tblName, aggrPartVals, colNames, "hive");
        Assert.assertEquals((long)100L, (long)((ColumnStatisticsObj)aggrStats.getColStats().get(0)).getStatsData().getLongStats().getNumNulls());
        objectStore.deletePartitionColumnStatistics("hive", db.getName(), tbl.getTableName(), Warehouse.makePartName((List)tbl.getPartitionKeys(), partVals1), partVals1, colName, "hive");
        objectStore.deletePartitionColumnStatistics("hive", db.getName(), tbl.getTableName(), Warehouse.makePartName((List)tbl.getPartitionKeys(), partVals2), partVals2, colName, "hive");
        objectStore.dropPartition("hive", db.getName(), tbl.getTableName(), partVals1);
        objectStore.dropPartition("hive", db.getName(), tbl.getTableName(), partVals2);
        objectStore.dropTable("hive", db.getName(), tbl.getTableName());
        objectStore.dropDatabase("hive", db.getName());
        cachedStore.shutdown();
    }

    @Test
    public void testPartitionAggrStats() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        String dbName = "testTableColStatsOps1";
        String tblName = "tbl1";
        String colName = "f1";
        Database db = new Database(dbName, null, "some_location", null);
        db.setCatalogName("hive");
        cachedStore.createDatabase(db);
        FieldSchema col = new FieldSchema(colName, "int", null);
        List<FieldSchema> cols = Collections.singletonList(col);
        List<FieldSchema> partCols = Collections.singletonList(new FieldSchema("col", "int", null));
        StorageDescriptor sd = this.createStorageDescriptor(cols);
        Table table = this.createTable(dbName, tblName, sd, partCols);
        cachedStore.createTable(table);
        List<String> partVals1 = Collections.singletonList("1");
        cachedStore.addPartition(this.createPartition(table, partVals1));
        ColumnStatisticsData data = new ColStatsBuilder<Long>(Long.TYPE).numNulls(50L).numDVs(30L).low(0L).high(100L).build();
        ColumnStatistics stats = StatisticsTestUtils.createColumnStatistics(data, table, col, "part1");
        cachedStore.updatePartitionColumnStatistics(stats, partVals1, null, -1L);
        List<String> partVals2 = Collections.singletonList("2");
        cachedStore.addPartition(this.createPartition(table, partVals2));
        data = new ColStatsBuilder<Long>(Long.TYPE).numNulls(50L).numDVs(40L).low(0L).high(100L).build();
        stats = StatisticsTestUtils.createColumnStatistics(data, table, col, "part2");
        cachedStore.updatePartitionColumnStatistics(stats, partVals2, null, -1L);
        List<String> colNames = Collections.singletonList(colName);
        List<String> aggrPartVals = Arrays.asList("1", "2");
        AggrStats aggrStats = cachedStore.get_aggr_stats_for("hive", dbName, tblName, aggrPartVals, colNames, "hive");
        ColumnStatisticsData computedData = ((ColumnStatisticsObj)aggrStats.getColStats().get(0)).getStatsData();
        ColumnStatisticsData expectedData = new ColStatsBuilder<Long>(Long.TYPE).numNulls(100L).numDVs(40L).low(0L).high(100L).build();
        Assert.assertEquals((Object)expectedData, (Object)computedData);
        aggrStats = cachedStore.get_aggr_stats_for("hive", dbName, tblName, aggrPartVals, colNames, "hive");
        computedData = ((ColumnStatisticsObj)aggrStats.getColStats().get(0)).getStatsData();
        Assert.assertEquals((Object)expectedData, (Object)computedData);
        cachedStore.shutdown();
    }

    @Test
    public void testPartitionAggrStatsBitVectorKll() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        String dbName = "testTableColStatsOps2";
        String tblName = "tbl2";
        String colName = "f1";
        Database db = new Database(dbName, null, "some_location", null);
        db.setCatalogName("hive");
        cachedStore.createDatabase(db);
        FieldSchema col = new FieldSchema(colName, "int", null);
        List<FieldSchema> cols = Collections.singletonList(col);
        List<FieldSchema> partCols = Collections.singletonList(new FieldSchema("col", "int", null));
        StorageDescriptor sd = this.createStorageDescriptor(cols);
        Table table = this.createTable(dbName, tblName, sd, partCols);
        cachedStore.createTable(table);
        List<String> partVals1 = Collections.singletonList("1");
        cachedStore.addPartition(this.createPartition(table, partVals1));
        ColumnStatisticsData data = new ColStatsBuilder<Long>(Long.TYPE).numNulls(50L).numDVs(30L).low(0L).high(100L).hll(1L, 2L, 3L).kll(1L, 2L, 3L).build();
        ColumnStatistics stats = StatisticsTestUtils.createColumnStatistics(data, table, col, "part1");
        cachedStore.updatePartitionColumnStatistics(stats, partVals1, null, -1L);
        List<String> partVals2 = Collections.singletonList("2");
        cachedStore.addPartition(this.createPartition(table, partVals2));
        data = new ColStatsBuilder<Long>(Long.TYPE).numNulls(50L).numDVs(30L).low(0L).high(100L).hll(1L, 2L, 3L, 4L).kll(2L, 3L, 4L, 5L).build();
        stats = StatisticsTestUtils.createColumnStatistics(data, table, col, "part2");
        cachedStore.updatePartitionColumnStatistics(stats, partVals2, null, -1L);
        List<String> colNames = Collections.singletonList(colName);
        List<String> aggrPartVals = Arrays.asList("1", "2");
        AggrStats aggrStats = cachedStore.get_aggr_stats_for("hive", dbName, tblName, aggrPartVals, colNames, "hive");
        ColumnStatisticsData columnStatsData = ((ColumnStatisticsObj)aggrStats.getColStats().get(0)).getStatsData();
        ColumnStatisticsData expectedData = new ColStatsBuilder<Long>(Long.TYPE).numNulls(100L).numDVs(4L).low(0L).high(100L).hll(1L, 2L, 3L).kll(1L, 2L, 3L, 2L, 3L, 4L, 5L).build();
        StatisticsTestUtils.assertEqualStatistics(expectedData, columnStatsData);
        aggrStats = cachedStore.get_aggr_stats_for("hive", dbName, tblName, aggrPartVals, colNames, "hive");
        columnStatsData = ((ColumnStatisticsObj)aggrStats.getColStats().get(0)).getStatsData();
        StatisticsTestUtils.assertEqualStatistics(expectedData, columnStatsData);
        cachedStore.shutdown();
    }

    @Test
    public void testMultiThreadedSharedCacheOps() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        SharedCache sharedCache = CachedStore.getSharedCache();
        ArrayList<String> dbNames = new ArrayList<String>(Arrays.asList("db1", "db2", "db3", "db4", "db5"));
        ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>();
        ExecutorService executor = Executors.newFixedThreadPool(50, r -> {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        });
        for (String string : dbNames) {
            Callable<Object> callable = () -> {
                Database db = this.createDatabaseObject(string, "user1");
                sharedCache.addDatabaseToCache(db);
                return null;
            };
            tasks.add(callable);
        }
        executor.invokeAll(tasks);
        for (String string : dbNames) {
            Database database = sharedCache.getDatabaseFromCache("hive", string);
            Assert.assertNotNull((Object)database);
            Assert.assertEquals((Object)string, (Object)database.getName());
        }
        ArrayList<String> tblNames = new ArrayList<String>(Arrays.asList("tbl1", "tbl2", "tbl3", "tbl4", "tbl5"));
        tasks.clear();
        for (String string : tblNames) {
            FieldSchema col1 = new FieldSchema("col1", "int", "integer column");
            FieldSchema col2 = new FieldSchema("col2", "string", "string column");
            ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
            cols.add(col1);
            cols.add(col2);
            FieldSchema ptnCol1 = new FieldSchema("part1", "string", "string partition column");
            ArrayList<FieldSchema> ptnCols = new ArrayList<FieldSchema>();
            ptnCols.add(ptnCol1);
            Callable<Object> callable = () -> {
                Table tbl = this.createTable((String)dbNames.get(0), string, this.createStorageDescriptor(cols), ptnCols);
                sharedCache.addTableToCache("hive", (String)dbNames.get(0), string, tbl);
                return null;
            };
            tasks.add(callable);
        }
        executor.invokeAll(tasks);
        for (String string : tblNames) {
            Table tbl = sharedCache.getTableFromCache("hive", (String)dbNames.get(0), string);
            Assert.assertNotNull((Object)tbl);
            Assert.assertEquals((Object)string, (Object)tbl.getTableName());
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("aaa", "bbb", "ccc", "ddd", "eee"));
        tasks.clear();
        for (String tblName : tblNames) {
            Table tbl = sharedCache.getTableFromCache("hive", (String)dbNames.get(0), tblName);
            for (String ptnVal : arrayList) {
                Callable<Object> c = () -> {
                    Partition ptn = this.createPartition(tbl, Collections.singletonList(ptnVal));
                    sharedCache.addPartitionToCache("hive", (String)dbNames.get(0), tblName, ptn);
                    return null;
                };
                tasks.add(c);
            }
        }
        executor.invokeAll(tasks);
        for (String tblName : tblNames) {
            for (String ptnVal : arrayList) {
                Partition ptn = sharedCache.getPartitionFromCache("hive", (String)dbNames.get(0), tblName, Collections.singletonList(ptnVal));
                Assert.assertNotNull((Object)ptn);
                Assert.assertEquals((Object)tblName, (Object)ptn.getTableName());
                Assert.assertEquals((Object)tblName, (Object)ptn.getTableName());
                Assert.assertEquals(Collections.singletonList(ptnVal), (Object)ptn.getValues());
            }
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList("fff", "ggg"));
        ArrayList<String> dropPtnTblNames = new ArrayList<String>(Arrays.asList("tbl1", "tbl2", "tbl3"));
        ArrayList<String> addPtnTblNames = new ArrayList<String>(Arrays.asList("tbl4", "tbl5"));
        tasks.clear();
        for (String tblName : dropPtnTblNames) {
            for (String string : arrayList) {
                Callable<Object> c = () -> {
                    sharedCache.removePartitionFromCache("hive", (String)dbNames.get(0), tblName, Collections.singletonList(string));
                    return null;
                };
                tasks.add(c);
            }
        }
        for (String tblName : addPtnTblNames) {
            Table tbl = sharedCache.getTableFromCache("hive", (String)dbNames.get(0), tblName);
            for (String ptnVal : arrayList2) {
                Callable<Object> c = () -> {
                    Partition ptn = this.createPartition(tbl, Collections.singletonList(ptnVal));
                    sharedCache.addPartitionToCache("hive", (String)dbNames.get(0), tblName, ptn);
                    return null;
                };
                tasks.add(c);
            }
        }
        executor.invokeAll(tasks);
        for (String tblName : addPtnTblNames) {
            for (String string : arrayList2) {
                Partition ptn = sharedCache.getPartitionFromCache("hive", (String)dbNames.get(0), tblName, Collections.singletonList(string));
                Assert.assertNotNull((Object)ptn);
                Assert.assertEquals((Object)tblName, (Object)ptn.getTableName());
                Assert.assertEquals((Object)tblName, (Object)ptn.getTableName());
                Assert.assertEquals(Collections.singletonList(string), (Object)ptn.getValues());
            }
        }
        for (String tblName : dropPtnTblNames) {
            List ptns = sharedCache.listCachedPartitions("hive", (String)dbNames.get(0), tblName, 100);
            Assert.assertEquals((long)0L, (long)ptns.size());
        }
        cachedStore.shutdown();
    }

    @Test
    public void testPartitionSize() {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"5Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTestExceptSharedCache(conf);
        String dbName = "db1";
        String tbl1Name = "tbl1";
        String tbl2Name = "tbl2";
        String owner = "user1";
        Database db = this.createDatabaseObject(dbName, owner);
        FieldSchema col1 = new FieldSchema("col1", "int", "integer column");
        FieldSchema col2 = new FieldSchema("col2", "string", "string column");
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(col1);
        cols.add(col2);
        StorageDescriptor sd = this.createStorageDescriptor(cols);
        ArrayList<FieldSchema> ptnCols = new ArrayList<FieldSchema>();
        Table tbl1 = this.createTable(dbName, tbl1Name, sd, ptnCols);
        Table tbl2 = this.createTable(dbName, tbl2Name, sd, ptnCols);
        HashMap<String, Integer> tableSizeMap = new HashMap<String, Integer>();
        String tbl1Key = CacheUtils.buildTableKey((String)"hive", (String)dbName, (String)tbl1Name);
        String tbl2Key = CacheUtils.buildTableKey((String)"hive", (String)dbName, (String)tbl2Name);
        tableSizeMap.put(tbl1Key, 1000);
        tableSizeMap.put(tbl2Key, 4500);
        Partition part1 = new Partition();
        StorageDescriptor sd1 = new StorageDescriptor();
        ArrayList<FieldSchema> cols1 = new ArrayList<FieldSchema>();
        cols1.add(new FieldSchema("col1", "int", ""));
        HashMap<String, String> params1 = new HashMap<String, String>();
        params1.put("key", "value");
        sd1.setCols(cols1);
        sd1.setParameters(params1);
        sd1.setLocation("loc1");
        part1.setSd(sd1);
        part1.setValues(Collections.singletonList("201701"));
        Partition part2 = new Partition();
        StorageDescriptor sd2 = new StorageDescriptor();
        ArrayList<FieldSchema> cols2 = new ArrayList<FieldSchema>();
        cols2.add(new FieldSchema("col1", "int", ""));
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("key", "value");
        sd2.setCols(cols2);
        sd2.setParameters(params2);
        sd2.setLocation("loc2");
        part2.setSd(sd2);
        part2.setValues(Collections.singletonList("201702"));
        Partition part3 = new Partition();
        StorageDescriptor sd3 = new StorageDescriptor();
        ArrayList<FieldSchema> cols3 = new ArrayList<FieldSchema>();
        cols3.add(new FieldSchema("col3", "int", ""));
        HashMap<String, String> params3 = new HashMap<String, String>();
        params3.put("key2", "value2");
        sd3.setCols(cols3);
        sd3.setParameters(params3);
        sd3.setLocation("loc3");
        part3.setSd(sd3);
        part3.setValues(Collections.singletonList("201703"));
        Partition newPart1 = new Partition();
        newPart1.setDbName(dbName);
        newPart1.setTableName(tbl1Name);
        StorageDescriptor newSd1 = new StorageDescriptor();
        ArrayList<FieldSchema> newCols1 = new ArrayList<FieldSchema>();
        newCols1.add(new FieldSchema("newcol1", "int", ""));
        HashMap<String, String> newParams1 = new HashMap<String, String>();
        newParams1.put("key", "value");
        newSd1.setCols(newCols1);
        newSd1.setParameters(newParams1);
        newSd1.setLocation("loc1new");
        newPart1.setSd(newSd1);
        newPart1.setValues(Collections.singletonList("201701"));
        SharedCache sharedCache = CachedStore.getSharedCache();
        sharedCache.setConcurrencyLevel(1);
        sharedCache.setTableSizeMap(tableSizeMap);
        sharedCache.initialize(conf);
        sharedCache.addDatabaseToCache(db);
        sharedCache.addTableToCache("hive", dbName, tbl1Name, tbl1);
        sharedCache.addTableToCache("hive", dbName, tbl2Name, tbl2);
        sharedCache.addPartitionToCache("hive", dbName, tbl1Name, part1);
        sharedCache.addPartitionToCache("hive", dbName, tbl1Name, part2);
        sharedCache.addPartitionToCache("hive", dbName, tbl1Name, part3);
        Partition p = sharedCache.getPartitionFromCache("hive", dbName, tbl1Name, Collections.singletonList("201701"));
        Assert.assertNull((Object)p);
        sharedCache.addPartitionToCache("hive", dbName, tbl2Name, newPart1);
        p = sharedCache.getPartitionFromCache("hive", dbName, tbl2Name, Collections.singletonList("201701"));
        Assert.assertNotNull((Object)p);
        cachedStore.shutdown();
    }

    @Test
    public void testShowTables() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"5kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTestExceptSharedCache(conf);
        ObjectStore objectStore = (ObjectStore)cachedStore.getRawStore();
        HashMap<String, Integer> tableSizeMap = new HashMap<String, Integer>();
        String db1Utbl1TblKey = CacheUtils.buildTableKey((String)"hive", (String)this.db1Utbl1.getDbName(), (String)this.db1Utbl1.getTableName());
        String db1Ptbl1TblKey = CacheUtils.buildTableKey((String)"hive", (String)this.db1Ptbl1.getDbName(), (String)this.db1Ptbl1.getTableName());
        String db2Utbl1TblKey = CacheUtils.buildTableKey((String)"hive", (String)this.db2Utbl1.getDbName(), (String)this.db2Utbl1.getTableName());
        String db2Ptbl1TblKey = CacheUtils.buildTableKey((String)"hive", (String)this.db2Ptbl1.getDbName(), (String)this.db2Ptbl1.getTableName());
        tableSizeMap.put(db1Utbl1TblKey, 4000);
        tableSizeMap.put(db1Ptbl1TblKey, 4000);
        tableSizeMap.put(db2Utbl1TblKey, 4000);
        tableSizeMap.put(db2Ptbl1TblKey, 4000);
        SharedCache sc = CachedStore.getSharedCache();
        sc.setConcurrencyLevel(1);
        sc.setTableSizeMap(tableSizeMap);
        sc.initialize(conf);
        CachedStore.setCachePrewarmedState((boolean)false);
        CachedStore.prewarm((RawStore)objectStore);
        List db1Tables = cachedStore.getAllTables("hive", this.db1.getName());
        Assert.assertEquals((long)2L, (long)db1Tables.size());
        List db2Tables = cachedStore.getAllTables("hive", this.db2.getName());
        Assert.assertEquals((long)2L, (long)db2Tables.size());
        cachedStore.shutdown();
    }

    @Test
    public void testTableEviction() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"5kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTestExceptSharedCache(conf);
        ObjectStore objectStore = (ObjectStore)cachedStore.getRawStore();
        HashMap<String, Integer> tableSizeMap = new HashMap<String, Integer>();
        String db1Utbl1TblKey = CacheUtils.buildTableKey((String)"hive", (String)this.db1Utbl1.getDbName(), (String)this.db1Utbl1.getTableName());
        String db1Ptbl1TblKey = CacheUtils.buildTableKey((String)"hive", (String)this.db1Ptbl1.getDbName(), (String)this.db1Ptbl1.getTableName());
        String db2Utbl1TblKey = CacheUtils.buildTableKey((String)"hive", (String)this.db2Utbl1.getDbName(), (String)this.db2Utbl1.getTableName());
        String db2Ptbl1TblKey = CacheUtils.buildTableKey((String)"hive", (String)this.db2Ptbl1.getDbName(), (String)this.db2Ptbl1.getTableName());
        tableSizeMap.put(db1Utbl1TblKey, 4000);
        tableSizeMap.put(db1Ptbl1TblKey, 4000);
        tableSizeMap.put(db2Utbl1TblKey, 4000);
        tableSizeMap.put(db2Ptbl1TblKey, 4000);
        Table tblDb1Utbl1 = objectStore.getTable("hive", this.db1Utbl1.getDbName(), this.db1Utbl1.getTableName());
        Table tblDb1Ptbl1 = objectStore.getTable("hive", this.db1Ptbl1.getDbName(), this.db1Ptbl1.getTableName());
        Table tblDb2Utbl1 = objectStore.getTable("hive", this.db2Utbl1.getDbName(), this.db2Utbl1.getTableName());
        Table tblDb2Ptbl1 = objectStore.getTable("hive", this.db2Ptbl1.getDbName(), this.db2Ptbl1.getTableName());
        SharedCache sc = CachedStore.getSharedCache();
        sc.setConcurrencyLevel(1);
        sc.setTableSizeMap(tableSizeMap);
        sc.initialize(conf);
        sc.addDatabaseToCache(this.db1);
        sc.addDatabaseToCache(this.db2);
        sc.addTableToCache("hive", this.db1Utbl1.getDbName(), this.db1Utbl1.getTableName(), tblDb1Utbl1);
        sc.addTableToCache("hive", this.db1Ptbl1.getDbName(), this.db1Ptbl1.getTableName(), tblDb1Ptbl1);
        sc.addTableToCache("hive", this.db2Utbl1.getDbName(), this.db2Utbl1.getTableName(), tblDb2Utbl1);
        sc.addTableToCache("hive", this.db2Ptbl1.getDbName(), this.db2Ptbl1.getTableName(), tblDb2Ptbl1);
        List db1Tables = sc.listCachedTableNames("hive", this.db1.getName());
        Assert.assertEquals((long)0L, (long)db1Tables.size());
        List db2Tables = sc.listCachedTableNames("hive", this.db2.getName());
        Assert.assertEquals((long)1L, (long)db2Tables.size());
        cachedStore.shutdown();
    }

    @Test
    public void testPrimaryKeys() {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        SharedCache sharedCache = CachedStore.getSharedCache();
        Database db = this.createDatabaseObject("db", "testUser");
        Table tbl = this.createUnpartitionedTableObject(db);
        sharedCache.addTableToCache("hive", "db", tbl.getTableName(), tbl);
        Assert.assertEquals((long)1L, (long)sharedCache.getCachedTableCount());
        List<SQLPrimaryKey> origKeys = this.createPrimaryKeys(tbl);
        SQLAllTableConstraints constraints = new SQLAllTableConstraints();
        constraints.setPrimaryKeys(origKeys);
        sharedCache.addTableConstraintsToCache("hive", "db", tbl.getTableName(), constraints);
        List cachedKeys = sharedCache.listCachedPrimaryKeys("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals(origKeys, (Object)cachedKeys);
        SQLPrimaryKey modifiedKey = origKeys.get(0).deepCopy();
        modifiedKey.setColumn_name("col2");
        modifiedKey.setPk_name("pk_modified");
        sharedCache.addPrimaryKeysToCache("hive", tbl.getDbName(), tbl.getTableName(), Collections.singletonList(modifiedKey));
        constraints = new SQLAllTableConstraints();
        ArrayList<SQLPrimaryKey> list = new ArrayList<SQLPrimaryKey>();
        list.add(origKeys.get(0));
        list.add(modifiedKey);
        constraints.setPrimaryKeys(list);
        sharedCache.refreshAllTableConstraintsInCache("hive", tbl.getDbName(), tbl.getTableName(), constraints);
        cachedKeys = sharedCache.listCachedPrimaryKeys("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals((Object)cachedKeys, (Object)constraints.getPrimaryKeys());
        sharedCache.removeConstraintFromCache("hive", tbl.getDbName(), tbl.getTableName(), "pk1");
        constraints = new SQLAllTableConstraints();
        constraints.setPrimaryKeys(Collections.singletonList(modifiedKey));
        sharedCache.refreshAllTableConstraintsInCache("hive", tbl.getDbName(), tbl.getTableName(), constraints);
        cachedKeys = sharedCache.listCachedPrimaryKeys("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals(Collections.singletonList(modifiedKey), (Object)cachedKeys);
        cachedStore.shutdown();
    }

    @Test
    public void testNotNullConstraint() {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        SharedCache sharedCache = CachedStore.getSharedCache();
        Database db = this.createDatabaseObject("db", "testUser");
        Table tbl = this.createUnpartitionedTableObject(db);
        sharedCache.addTableToCache("hive", "db", tbl.getTableName(), tbl);
        Assert.assertEquals((long)1L, (long)sharedCache.getCachedTableCount());
        List<SQLNotNullConstraint> origKeys = this.createNotNullConstraint(tbl);
        SQLAllTableConstraints constraints = new SQLAllTableConstraints();
        constraints.setNotNullConstraints(origKeys);
        sharedCache.addTableConstraintsToCache("hive", "db", tbl.getTableName(), constraints);
        List cachedKeys = sharedCache.listCachedNotNullConstraints("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals(origKeys, (Object)cachedKeys);
        SQLNotNullConstraint modifiedKey = origKeys.get(0).deepCopy();
        modifiedKey.setColumn_name("col2");
        modifiedKey.setNn_name("nn_modified");
        sharedCache.addNotNullConstraintsToCache("hive", tbl.getDbName(), tbl.getTableName(), Collections.singletonList(modifiedKey));
        constraints = new SQLAllTableConstraints();
        ArrayList<SQLNotNullConstraint> list = new ArrayList<SQLNotNullConstraint>();
        list.add(origKeys.get(0));
        list.add(modifiedKey);
        constraints.setNotNullConstraints(list);
        sharedCache.refreshAllTableConstraintsInCache("hive", tbl.getDbName(), tbl.getTableName(), constraints);
        cachedKeys = sharedCache.listCachedNotNullConstraints("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals((Object)cachedKeys, (Object)constraints.getNotNullConstraints());
        sharedCache.removeConstraintFromCache("hive", tbl.getDbName(), tbl.getTableName(), "nn1");
        constraints = new SQLAllTableConstraints();
        constraints.setNotNullConstraints(Collections.singletonList(modifiedKey));
        sharedCache.refreshAllTableConstraintsInCache("hive", tbl.getDbName(), tbl.getTableName(), constraints);
        cachedKeys = sharedCache.listCachedNotNullConstraints("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals(Collections.singletonList(modifiedKey), (Object)cachedKeys);
        cachedStore.shutdown();
    }

    @Test
    public void testUniqueConstraint() {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        SharedCache sharedCache = CachedStore.getSharedCache();
        Database db = this.createDatabaseObject("db", "testUser");
        Table tbl = this.createUnpartitionedTableObject(db);
        sharedCache.addTableToCache("hive", "db", tbl.getTableName(), tbl);
        Assert.assertEquals((long)1L, (long)sharedCache.getCachedTableCount());
        List<SQLUniqueConstraint> origKeys = this.createUniqueConstraint(tbl);
        SQLAllTableConstraints constraints = new SQLAllTableConstraints();
        constraints.setUniqueConstraints(origKeys);
        sharedCache.addTableConstraintsToCache("hive", "db", tbl.getTableName(), constraints);
        List cachedKeys = sharedCache.listCachedUniqueConstraint("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals(origKeys, (Object)cachedKeys);
        SQLUniqueConstraint modifiedKey = origKeys.get(0).deepCopy();
        modifiedKey.setColumn_name("col2");
        modifiedKey.setUk_name("uk_modified");
        sharedCache.addUniqueConstraintsToCache("hive", tbl.getDbName(), tbl.getTableName(), Collections.singletonList(modifiedKey));
        cachedKeys = sharedCache.listCachedUniqueConstraint("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals((Object)cachedKeys, new ArrayList());
        constraints = new SQLAllTableConstraints();
        ArrayList<SQLUniqueConstraint> list = new ArrayList<SQLUniqueConstraint>();
        list.add(origKeys.get(0));
        list.add(modifiedKey);
        constraints.setUniqueConstraints(list);
        sharedCache.refreshAllTableConstraintsInCache("hive", tbl.getDbName(), tbl.getTableName(), constraints);
        cachedKeys = sharedCache.listCachedUniqueConstraint("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals((Object)cachedKeys, (Object)constraints.getUniqueConstraints());
        sharedCache.removeConstraintFromCache("hive", tbl.getDbName(), tbl.getTableName(), "uk1");
        constraints = new SQLAllTableConstraints();
        constraints.setUniqueConstraints(Collections.singletonList(modifiedKey));
        sharedCache.refreshAllTableConstraintsInCache("hive", tbl.getDbName(), tbl.getTableName(), constraints);
        cachedKeys = sharedCache.listCachedUniqueConstraint("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals(Collections.singletonList(modifiedKey), (Object)cachedKeys);
        cachedStore.shutdown();
    }

    @Test
    public void testForeignKeys() {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        SharedCache sharedCache = CachedStore.getSharedCache();
        Database db = this.createDatabaseObject("db", "testUser");
        Database db1 = this.createDatabaseObject("db1", "testUser");
        Table tbl = this.createUnpartitionedTableObject(db);
        Table tbl1 = this.createUnpartitionedTableObject(db1);
        sharedCache.addTableToCache("hive", "db", tbl.getTableName(), tbl);
        sharedCache.addTableToCache("hive", "db1", tbl1.getTableName(), tbl1);
        Assert.assertEquals((long)2L, (long)sharedCache.getCachedTableCount());
        List<SQLForeignKey> origKeys = this.createForeignKeys(tbl, tbl, "fk1");
        SQLAllTableConstraints constraints = new SQLAllTableConstraints();
        constraints.setForeignKeys(origKeys);
        sharedCache.addTableConstraintsToCache("hive", "db", tbl.getTableName(), constraints);
        List cachedKeys = sharedCache.listCachedForeignKeys("hive", tbl.getDbName(), tbl.getTableName(), tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals(origKeys, (Object)cachedKeys);
        cachedKeys = sharedCache.listCachedForeignKeys("hive", tbl.getDbName(), tbl.getTableName(), "dummyDB", "dummyTable");
        Assert.assertEquals((long)0L, (long)cachedKeys.size());
        SQLForeignKey modifiedKey = origKeys.get(0).deepCopy();
        modifiedKey.setFkcolumn_name("col3");
        modifiedKey.setFk_name("fk_modified");
        sharedCache.addForeignKeysToCache("hive", tbl.getDbName(), tbl.getTableName(), Collections.singletonList(modifiedKey));
        cachedKeys = sharedCache.listCachedForeignKeys("hive", tbl.getDbName(), tbl.getTableName(), tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals((Object)cachedKeys, new ArrayList());
        constraints = new SQLAllTableConstraints();
        ArrayList<SQLForeignKey> list = new ArrayList<SQLForeignKey>();
        list.add(modifiedKey);
        list.add(origKeys.get(0));
        constraints.setForeignKeys(list);
        sharedCache.refreshAllTableConstraintsInCache("hive", tbl.getDbName(), tbl.getTableName(), constraints);
        cachedKeys = sharedCache.listCachedForeignKeys("hive", tbl.getDbName(), tbl.getTableName(), tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals((Object)cachedKeys, (Object)constraints.getForeignKeys());
        sharedCache.removeConstraintFromCache("hive", tbl.getDbName(), tbl.getTableName(), "fk1");
        constraints = new SQLAllTableConstraints();
        constraints.setForeignKeys(Collections.singletonList(modifiedKey));
        sharedCache.refreshAllTableConstraintsInCache("hive", tbl.getDbName(), tbl.getTableName(), constraints);
        cachedKeys = sharedCache.listCachedForeignKeys("hive", tbl.getDbName(), tbl.getTableName(), tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals(Collections.singletonList(modifiedKey), (Object)cachedKeys);
        cachedStore.shutdown();
    }

    @Test
    public void testDefaultConstraint() {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        SharedCache sharedCache = CachedStore.getSharedCache();
        Database db = this.createDatabaseObject("db", "testUser");
        Table tbl = this.createUnpartitionedTableObject(db);
        sharedCache.addTableToCache("hive", "db", tbl.getTableName(), tbl);
        Assert.assertEquals((long)1L, (long)sharedCache.getCachedTableCount());
        List<SQLDefaultConstraint> origKeys = this.createDefaultConstraint(tbl);
        SQLAllTableConstraints constraints = new SQLAllTableConstraints();
        constraints.setDefaultConstraints(origKeys);
        sharedCache.addTableConstraintsToCache("hive", "db", tbl.getTableName(), constraints);
        List cachedKeys = sharedCache.listCachedDefaultConstraint("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals(origKeys, (Object)cachedKeys);
        SQLDefaultConstraint modifiedKey = origKeys.get(0).deepCopy();
        modifiedKey.setColumn_name("col2");
        modifiedKey.setDc_name("dc_modified");
        sharedCache.addDefaultConstraintsToCache("hive", tbl.getDbName(), tbl.getTableName(), Collections.singletonList(modifiedKey));
        cachedKeys = sharedCache.listCachedDefaultConstraint("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals((Object)cachedKeys, new ArrayList());
        constraints = new SQLAllTableConstraints();
        ArrayList<SQLDefaultConstraint> list = new ArrayList<SQLDefaultConstraint>();
        list.add(origKeys.get(0));
        list.add(modifiedKey);
        constraints.setDefaultConstraints(list);
        sharedCache.refreshAllTableConstraintsInCache("hive", tbl.getDbName(), tbl.getTableName(), constraints);
        cachedKeys = sharedCache.listCachedDefaultConstraint("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals((Object)cachedKeys, (Object)constraints.getDefaultConstraints());
        sharedCache.removeConstraintFromCache("hive", tbl.getDbName(), tbl.getTableName(), "dc1");
        constraints = new SQLAllTableConstraints();
        constraints.setDefaultConstraints(Collections.singletonList(modifiedKey));
        sharedCache.refreshAllTableConstraintsInCache("hive", tbl.getDbName(), tbl.getTableName(), constraints);
        cachedKeys = sharedCache.listCachedDefaultConstraint("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals(Collections.singletonList(modifiedKey), (Object)cachedKeys);
        cachedStore.shutdown();
    }

    @Test
    public void testCheckConstraint() {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        SharedCache sharedCache = CachedStore.getSharedCache();
        Database db = this.createDatabaseObject("db", "testUser");
        Table tbl = this.createUnpartitionedTableObject(db);
        sharedCache.addTableToCache("hive", "db", tbl.getTableName(), tbl);
        Assert.assertEquals((long)1L, (long)sharedCache.getCachedTableCount());
        List<SQLCheckConstraint> origKeys = this.createCheckConstraint(tbl);
        SQLAllTableConstraints constraints = new SQLAllTableConstraints();
        constraints.setCheckConstraints(origKeys);
        sharedCache.addTableConstraintsToCache("hive", "db", tbl.getTableName(), constraints);
        List cachedKeys = sharedCache.listCachedCheckConstraint("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals(origKeys, (Object)cachedKeys);
        SQLCheckConstraint modifiedKey = origKeys.get(0).deepCopy();
        modifiedKey.setColumn_name("col2");
        modifiedKey.setDc_name("cc_modified");
        sharedCache.addCheckConstraintsToCache("hive", tbl.getDbName(), tbl.getTableName(), Collections.singletonList(modifiedKey));
        cachedKeys = sharedCache.listCachedCheckConstraint("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals((Object)cachedKeys, new ArrayList());
        constraints = new SQLAllTableConstraints();
        ArrayList<SQLCheckConstraint> list = new ArrayList<SQLCheckConstraint>();
        list.add(origKeys.get(0));
        list.add(modifiedKey);
        constraints.setCheckConstraints(list);
        sharedCache.refreshAllTableConstraintsInCache("hive", tbl.getDbName(), tbl.getTableName(), constraints);
        cachedKeys = sharedCache.listCachedCheckConstraint("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals((Object)cachedKeys, (Object)constraints.getCheckConstraints());
        sharedCache.removeConstraintFromCache("hive", tbl.getDbName(), tbl.getTableName(), "cc1");
        cachedKeys = sharedCache.listCachedCheckConstraint("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals((Object)cachedKeys, new ArrayList());
        constraints = new SQLAllTableConstraints();
        constraints.setCheckConstraints(Collections.singletonList(modifiedKey));
        sharedCache.refreshAllTableConstraintsInCache("hive", tbl.getDbName(), tbl.getTableName(), constraints);
        cachedKeys = sharedCache.listCachedCheckConstraint("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals((Object)constraints.getCheckConstraints(), (Object)cachedKeys);
        cachedStore.shutdown();
    }

    @Test
    public void testAllTableConstraint() {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_MAX_CACHE_MEMORY, (String)"-1Kb");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        CachedStore cachedStore = new CachedStore();
        CachedStore.clearSharedCache();
        cachedStore.setConfForTest(conf);
        SharedCache sharedCache = CachedStore.getSharedCache();
        Database db = this.createDatabaseObject("db", "testUser");
        Table tbl = this.createUnpartitionedTableObject(db);
        sharedCache.addTableToCache("hive", "db", tbl.getTableName(), tbl);
        Assert.assertEquals((long)1L, (long)sharedCache.getCachedTableCount());
        SQLAllTableConstraints originalConstraints = new SQLAllTableConstraints();
        originalConstraints.setPrimaryKeys(this.createPrimaryKeys(tbl));
        originalConstraints.setForeignKeys(this.createForeignKeys(tbl, tbl, "fk1"));
        originalConstraints.setCheckConstraints(this.createCheckConstraint(tbl));
        originalConstraints.setDefaultConstraints(this.createDefaultConstraint(tbl));
        originalConstraints.setUniqueConstraints(this.createUniqueConstraint(tbl));
        originalConstraints.setNotNullConstraints(this.createNotNullConstraint(tbl));
        sharedCache.addTableConstraintsToCache("hive", tbl.getDbName(), tbl.getTableName(), originalConstraints);
        SQLAllTableConstraints cachedConstraints = sharedCache.listCachedAllTableConstraints("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals((Object)originalConstraints, (Object)cachedConstraints);
        SQLCheckConstraint checkConstraint = ((SQLCheckConstraint)originalConstraints.getCheckConstraints().get(0)).deepCopy();
        checkConstraint.setColumn_name("col2");
        checkConstraint.setDc_name("cc_modified");
        ArrayList<SQLCheckConstraint> cc = new ArrayList<SQLCheckConstraint>();
        cc.add((SQLCheckConstraint)originalConstraints.getCheckConstraints().get(0));
        cc.add(checkConstraint);
        originalConstraints.setCheckConstraints(cc);
        sharedCache.addCheckConstraintsToCache("hive", tbl.getDbName(), tbl.getTableName(), Collections.singletonList(checkConstraint));
        cachedConstraints = sharedCache.listCachedAllTableConstraints("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals((Object)new SQLAllTableConstraints(), (Object)cachedConstraints);
        sharedCache.refreshAllTableConstraintsInCache("hive", tbl.getDbName(), tbl.getTableName(), originalConstraints);
        cachedConstraints = sharedCache.listCachedAllTableConstraints("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals((Object)originalConstraints, (Object)cachedConstraints);
        sharedCache.removeConstraintFromCache("hive", tbl.getDbName(), tbl.getTableName(), "cc1");
        originalConstraints.getCheckConstraints().remove(0);
        sharedCache.refreshAllTableConstraintsInCache("hive", tbl.getDbName(), tbl.getTableName(), originalConstraints);
        cachedConstraints = sharedCache.listCachedAllTableConstraints("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals((Object)originalConstraints, (Object)cachedConstraints);
        sharedCache.removeConstraintFromCache("hive", tbl.getDbName(), tbl.getTableName(), "cc_modified");
        originalConstraints.getCheckConstraints().remove(0);
        sharedCache.refreshAllTableConstraintsInCache("hive", tbl.getDbName(), tbl.getTableName(), originalConstraints);
        cachedConstraints = sharedCache.listCachedAllTableConstraints("hive", tbl.getDbName(), tbl.getTableName());
        Assert.assertEquals((Object)originalConstraints, (Object)cachedConstraints);
        cachedStore.shutdown();
    }

    private List<SQLPrimaryKey> createPrimaryKeys(Table tbl) {
        SQLPrimaryKey key = new SQLPrimaryKey(tbl.getDbName(), tbl.getTableName(), "col1", 1, "pk1", false, false, false);
        key.setCatName("hive");
        return Collections.singletonList(key);
    }

    private List<SQLNotNullConstraint> createNotNullConstraint(Table tbl) {
        SQLNotNullConstraint key = new SQLNotNullConstraint("hive", tbl.getDbName(), tbl.getTableName(), "col1", "nn1", false, false, false);
        return Collections.singletonList(key);
    }

    private List<SQLUniqueConstraint> createUniqueConstraint(Table tbl) {
        SQLUniqueConstraint key = new SQLUniqueConstraint("hive", tbl.getDbName(), tbl.getTableName(), "col1", 1, "uk1", false, false, false);
        return Collections.singletonList(key);
    }

    private List<SQLForeignKey> createForeignKeys(Table primaryKeytbl, Table foreignKeyTbl, String fKeyName) {
        String foreignKeyColumn = primaryKeytbl == foreignKeyTbl ? "col2" : "col1";
        SQLForeignKey key = new SQLForeignKey(primaryKeytbl.getDbName(), primaryKeytbl.getTableName(), "col1", foreignKeyTbl.getDbName(), foreignKeyTbl.getTableName(), foreignKeyColumn, 1, 1, 1, fKeyName, "pk1", false, false, false);
        key.setCatName("hive");
        return Collections.singletonList(key);
    }

    private List<SQLDefaultConstraint> createDefaultConstraint(Table tbl) {
        SQLDefaultConstraint dc = new SQLDefaultConstraint("hive", tbl.getDbName(), tbl.getTableName(), "col1", "1", "dc1", false, false, false);
        return Collections.singletonList(dc);
    }

    private List<SQLCheckConstraint> createCheckConstraint(Table tbl) {
        SQLCheckConstraint cc = new SQLCheckConstraint("hive", tbl.getDbName(), tbl.getTableName(), "col1", "1", "cc1", false, false, false);
        return Collections.singletonList(cc);
    }

    private Table createTable(String dbName, String tblName, StorageDescriptor sd, List<FieldSchema> ptnCols) {
        sd.setStoredAsSubDirectories(false);
        Table tbl = new Table(tblName, dbName, "hive", 0, 0, 0, sd, ptnCols, Collections.emptyMap(), null, null, TableType.MANAGED_TABLE.toString());
        tbl.setCatName("hive");
        return tbl;
    }

    private StorageDescriptor createStorageDescriptor(List<FieldSchema> cols) {
        return new StorageDescriptor(cols, null, "input", "output", false, 0, new SerDeInfo("serde", "seriallib", new HashMap()), null, null, Collections.emptyMap());
    }

    private Database createDatabaseObject(String dbName, String dbOwner) {
        String dbLocation = "file:/tmp";
        HashMap dbParams = new HashMap();
        Database db = new Database(dbName, dbName, dbLocation, dbParams);
        db.setOwnerName(dbOwner);
        db.setOwnerType(PrincipalType.USER);
        db.setCatalogName("hive");
        db.setCreateTime((int)(System.currentTimeMillis() / 1000L));
        db.setType(DatabaseType.NATIVE);
        return db;
    }

    private Partition createPartition(Table tbl, List<String> values) {
        Partition ptn = new Partition(values, tbl.getDbName(), tbl.getTableName(), 0, 0, tbl.getSd(), Collections.emptyMap());
        ptn.setCatName("hive");
        return ptn;
    }

    private Table createUnpartitionedTableObject(Database db) {
        String dbName = db.getName();
        String owner = db.getName();
        String serdeLocation = "file:/tmp";
        HashMap serdeParams = new HashMap();
        HashMap tblParams = new HashMap();
        SerDeInfo serdeInfo = new SerDeInfo("serde", "seriallib", new HashMap());
        FieldSchema col1 = new FieldSchema("col1", "binary", "binary column");
        FieldSchema col2 = new FieldSchema("col2", "boolean", "boolean column");
        FieldSchema col3 = new FieldSchema("col3", "date", "date column");
        FieldSchema col4 = new FieldSchema("col4", "decimal", "decimal column");
        FieldSchema col5 = new FieldSchema("col5", "double", "double column");
        FieldSchema col6 = new FieldSchema("col6", "float", "float column");
        FieldSchema col7 = new FieldSchema("col7", "int", "int column");
        FieldSchema col8 = new FieldSchema("col8", "string", "string column");
        List<FieldSchema> cols = Arrays.asList(col1, col2, col3, col4, col5, col6, col7, col8);
        StorageDescriptor sd = new StorageDescriptor(cols, serdeLocation, "input", "output", false, 0, serdeInfo, null, null, serdeParams);
        sd.setStoredAsSubDirectories(false);
        Table tbl = new Table(dbName + "_unptntbl1", dbName, owner, 0, 0, 0, sd, new ArrayList(), tblParams, null, null, TableType.MANAGED_TABLE.toString());
        tbl.setCatName("hive");
        tbl.setWriteId(0L);
        return tbl;
    }

    private Table createPartitionedTableObject(Database db) {
        FieldSchema ptnCol1 = new FieldSchema("partCol1", "string", "string partition column");
        FieldSchema ptnCol2 = new FieldSchema("partCol2", "int", "integer partition column");
        List<FieldSchema> ptnCols = Arrays.asList(ptnCol1, ptnCol2);
        Table tbl = this.createUnpartitionedTableObject(db);
        tbl.setTableName(db.getName() + "_ptntbl1");
        tbl.setPartitionKeys(ptnCols);
        return tbl;
    }

    private PartitionObjectsAndNames createPartitionObjects(Table table) {
        ArrayList<String> partColNames = new ArrayList<String>();
        for (FieldSchema col : table.getPartitionKeys()) {
            partColNames.add(col.getName());
        }
        ArrayList<Partition> ptns = new ArrayList<Partition>();
        ArrayList<String> ptnNames = new ArrayList<String>();
        List<String> ptnCol1Vals = Arrays.asList("a", "b", "c", "d", "e");
        List<String> ptnCol2Vals = Arrays.asList("1", "2", "3", "4", "5");
        for (String ptnCol1Val : ptnCol1Vals) {
            for (String ptnCol2Val : ptnCol2Vals) {
                List<String> partVals = Arrays.asList(ptnCol1Val, ptnCol2Val);
                Partition ptn = this.createPartition(table, partVals);
                ptn.setCatName("hive");
                ptns.add(ptn);
                ptnNames.add(FileUtils.makePartName(partColNames, partVals));
            }
        }
        return new PartitionObjectsAndNames(ptns, ptnNames);
    }

    private void assertLongStatsEquals(ColumnStatistics expected, ColumnStatistics actual) {
        Assert.assertEquals((long)expected.getStatsObjSize(), (long)actual.getStatsObjSize());
        for (int i = 0; i < expected.getStatsObjSize(); ++i) {
            LongColumnStatsData expectedData = ((ColumnStatisticsObj)expected.getStatsObj().get(i)).getStatsData().getLongStats();
            LongColumnStatsData actualData = ((ColumnStatisticsObj)expected.getStatsObj().get(i)).getStatsData().getLongStats();
            Assert.assertEquals((long)expectedData.getNumDVs(), (long)actualData.getNumDVs());
            Assert.assertEquals((long)expectedData.getNumNulls(), (long)actualData.getNumNulls());
            Assert.assertEquals((long)expectedData.getHighValue(), (long)actualData.getHighValue());
            Assert.assertEquals((long)expectedData.getLowValue(), (long)actualData.getLowValue());
            Assert.assertArrayEquals((byte[])expectedData.getBitVectors(), (byte[])actualData.getBitVectors());
        }
    }

    private void updateCache(CachedStore cachedStore) throws Exception {
        int maxTries = 100;
        long updateCountBefore = cachedStore.getCacheUpdateCount();
        CachedStore.startCacheUpdateService((Configuration)cachedStore.getConf(), (boolean)true, (boolean)false);
        while (cachedStore.getCacheUpdateCount() != updateCountBefore + 1L && maxTries-- > 0) {
            Thread.sleep(1000L);
        }
        if (maxTries <= 0) {
            throw new Exception("Unable to update SharedCache in 100 attempts; possibly some bug");
        }
        CachedStore.stopCacheUpdateService((long)100L);
    }

    static class PartitionObjectsAndNames {
        private final List<Partition> ptns;
        private final List<String> ptnNames;

        PartitionObjectsAndNames(List<Partition> ptns, List<String> ptnNames) {
            this.ptns = ptns;
            this.ptnNames = ptnNames;
        }

        List<Partition> getPartitions() {
            return this.ptns;
        }

        List<String> getPartitionNames() {
            return this.ptnNames;
        }
    }
}

