/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.http.HttpServlet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HelloServlet;
import org.apache.hadoop.hive.metastore.ServletServerBuilder;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.eclipse.jetty.server.Server;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MetastoreUnitTest.class})
public class TestServletServerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(TestServletServerBuilder.class);

    private static Function<Configuration, ServletServerBuilder.Descriptor> describeServlet(Map<String, ServletServerBuilder.Descriptor> descriptors, int port, String greeting) {
        return configuration -> {
            final String name = greeting.toLowerCase();
            HelloServlet s1 = new HelloServlet(greeting){

                public String getServletName() {
                    return name + "()";
                }
            };
            ServletServerBuilder.Descriptor descriptor = new ServletServerBuilder.Descriptor(port, name, (HttpServlet)s1);
            descriptors.put(s1.getServletName(), descriptor);
            return descriptor;
        };
    }

    @Test
    public void testOne() throws Exception {
        Configuration conf = new Configuration();
        HashMap<String, ServletServerBuilder.Descriptor> descriptors = new HashMap<String, ServletServerBuilder.Descriptor>();
        Function<Configuration, ServletServerBuilder.Descriptor> fd1 = TestServletServerBuilder.describeServlet(descriptors, 0, "ONE");
        Function<Configuration, ServletServerBuilder.Descriptor> fd2 = TestServletServerBuilder.describeServlet(descriptors, 0, "TWO");
        Server server = ServletServerBuilder.startServer((Logger)LOG, (Configuration)conf, (Function[])new Function[]{fd1, fd2});
        ServletServerBuilder.Descriptor d1 = (ServletServerBuilder.Descriptor)descriptors.get("one()");
        ServletServerBuilder.Descriptor d2 = (ServletServerBuilder.Descriptor)descriptors.get("two()");
        Assert.assertTrue((d1.getPort() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)d1.getPort(), (long)d2.getPort());
        URI uri = URI.create("http://localhost:" + d1.getPort());
        Object one = TestServletServerBuilder.clientCall(uri.resolve("/one").toURL());
        Assert.assertEquals((Object)"ONE", (Object)one);
        uri = URI.create("http://localhost:" + d2.getPort());
        Object two = TestServletServerBuilder.clientCall(uri.resolve("/two").toURL());
        Assert.assertEquals((Object)"TWO", (Object)two);
        server.stop();
    }

    @Test
    public void testOnePort() throws Exception {
        int port;
        try (ServerSocket server0 = new ServerSocket(0);){
            port = server0.getLocalPort();
        }
        catch (IOException xio) {
            return;
        }
        this.onePort(port);
    }

    @Test
    public void testOnePortAuto() throws Exception {
        this.onePort(0);
    }

    void onePort(int port) throws Exception {
        Configuration conf = new Configuration();
        ServletServerBuilder ssb = new ServletServerBuilder(conf);
        HelloServlet s1 = new HelloServlet("ONE");
        HelloServlet s2 = new HelloServlet("TWO");
        ServletServerBuilder.Descriptor d1 = ssb.addServlet(port, "one", (HttpServlet)s1);
        ServletServerBuilder.Descriptor d2 = ssb.addServlet(port, "two", (HttpServlet)s2);
        Server server = ssb.startServer();
        Assert.assertTrue((d1.getPort() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)d1.getPort(), (long)d2.getPort());
        URI uri = URI.create("http://localhost:" + d1.getPort());
        Object one = TestServletServerBuilder.clientCall(uri.resolve("/one").toURL());
        Assert.assertEquals((Object)"ONE", (Object)one);
        uri = URI.create("http://localhost:" + d2.getPort());
        Object two = TestServletServerBuilder.clientCall(uri.resolve("/two").toURL());
        Assert.assertEquals((Object)"TWO", (Object)two);
        server.stop();
    }

    @Test
    public void testTwoPorts() throws Exception {
        this.runTwoPorts(-1, -2);
    }

    @Test
    public void testTwoPortsAuto() throws Exception {
        int p1;
        int p0;
        try (ServerSocket server0 = new ServerSocket(0);
             ServerSocket server1 = new ServerSocket(0);){
            p0 = server0.getLocalPort();
            p1 = server1.getLocalPort();
        }
        catch (IOException xio) {
            return;
        }
        this.runTwoPorts(p0, p1);
    }

    void runTwoPorts(int p1, int p2) throws Exception {
        Configuration conf = new Configuration();
        ServletServerBuilder ssb = new ServletServerBuilder(conf);
        HelloServlet s1 = new HelloServlet("ONE");
        HelloServlet s2 = new HelloServlet("TWO");
        ServletServerBuilder.Descriptor d1 = ssb.addServlet(p1, "one", (HttpServlet)s1);
        ServletServerBuilder.Descriptor d2 = ssb.addServlet(p2, "two", (HttpServlet)s2);
        IdentityHashMap mappings = new IdentityHashMap();
        Server server = ssb.startServer();
        Assert.assertNotEquals((long)d1.getPort(), (long)d2.getPort());
        URI uri = URI.create("http://localhost:" + d1.getPort());
        Object one = TestServletServerBuilder.clientCall(uri.resolve("/one").toURL());
        Assert.assertEquals((Object)"ONE", (Object)one);
        Object o404 = TestServletServerBuilder.clientCall(uri.resolve("/two").toURL());
        Assert.assertEquals((Object)404, (Object)o404);
        uri = URI.create("http://localhost:" + d2.getPort());
        Object two = TestServletServerBuilder.clientCall(uri.resolve("/two").toURL());
        Assert.assertEquals((Object)"TWO", (Object)two);
        o404 = TestServletServerBuilder.clientCall(uri.resolve("/one").toURL());
        Assert.assertEquals((Object)404, (Object)o404);
        server.stop();
    }

    static int findFreePort() throws IOException {
        try (ServerSocket server0 = new ServerSocket(0);){
            int n = server0.getLocalPort();
            return n;
        }
    }

    static int find2FreePort() throws IOException {
        try (ServerSocket socket0 = new ServerSocket(0);){
            int n = socket0.getLocalPort();
            return n;
        }
    }

    static Object clientCall(URL url) throws IOException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Accept", "application/json");
        con.setDoOutput(true);
        int responseCode = con.getResponseCode();
        if (responseCode == 200) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8));){
                Object object = new Gson().fromJson((Reader)reader, Object.class);
                return object;
            }
        }
        return responseCode;
    }
}

