/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.hive.common.util.ReflectionUtil;
import org.apache.thrift.transport.TTransportException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MetastoreUnitTest.class})
public class TestRemoteHiveMetastoreWithHttpJwt {
    private static final Map<String, String> DEFAULTS = new HashMap<String, String>(System.getenv());
    private static Map<String, String> envMap;
    private static String baseDir;
    private static final File jwtAuthorizedKeyFile;
    private static final File jwtUnauthorizedKeyFile;
    private static final File jwtVerificationJWKSFile;
    private static final String USER_1 = "HMS_TEST_USER_1";
    private static final String TEST_DB_NAME_PREFIX = "HMS_JWT_AUTH_DB";
    private static final Logger LOG;
    private static final int MOCK_JWKS_SERVER_PORT = 8089;
    @ClassRule
    public static final WireMockRule MOCK_JWKS_SERVER;
    private static int port;
    private static Configuration conf;

    @BeforeClass
    public static void makeEnvModifiable() throws Exception {
        envMap = new HashMap<String, String>();
        Class<?> envClass = Class.forName("java.lang.ProcessEnvironment");
        Field theUnmodifiableEnvironmentField = envClass.getDeclaredField("theUnmodifiableEnvironment");
        TestRemoteHiveMetastoreWithHttpJwt.removeStaticFinalAndSetValue(theUnmodifiableEnvironmentField, envMap);
    }

    private static void removeStaticFinalAndSetValue(Field field, Object value) throws Exception {
        ReflectionUtil.setStaticFinalFieldsModifiable((Field)field);
        field.set(null, value);
    }

    @AfterClass
    public static void stopServices() throws Exception {
        System.getenv().remove("HMS_JWT");
    }

    @BeforeClass
    public static void setUp() throws Exception {
        conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_ENABLED, (boolean)true);
        conf.set("datanucleus.autoCreateTables", "false");
        conf.set("hive.in.test", "true");
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_METADATA_TRANSFORMER_CLASS, (String)" ");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX, (long)2L);
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.LIMIT_PARTITION_REQUEST, (long)100L);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STORAGE_SCHEMA_READER_IMPL, (String)"no.such.class");
        TestRemoteHiveMetastoreWithHttpJwt.setupMockServer();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXECUTE_SET_UGI, (boolean)false);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_TRANSPORT_MODE, (String)"http");
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_CLIENT_THRIFT_TRANSPORT_MODE, (String)"http");
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_CLIENT_AUTH_MODE, (String)"JWT");
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_METASTORE_AUTHENTICATION, (String)"JWT");
        TestRemoteHiveMetastoreWithHttpJwt.startMetastoreServer();
    }

    private static void startMetastoreServer() throws Exception {
        port = MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), conf);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS, (String)("thrift://localhost:" + port));
        System.out.println("Starting MetaStore Server on port " + port);
    }

    @Before
    public void initEnvMap() {
        envMap.clear();
        envMap.putAll(DEFAULTS);
    }

    private static void setupMockServer() throws Exception {
        MOCK_JWKS_SERVER.stubFor(WireMock.get((String)"/jwks").willReturn(WireMock.ok().withBody(Files.readAllBytes(jwtVerificationJWKSFile.toPath()))));
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_METASTORE_AUTHENTICATION_JWT_JWKS_URL, (String)"http://localhost:8089/jwks");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidJWT() throws Exception {
        String validJwtToken = this.generateJWT(USER_1, jwtAuthorizedKeyFile.toPath(), TimeUnit.MINUTES.toMillis(5L));
        System.getenv().put("HMS_JWT", validJwtToken);
        String dbName = ("valid_jwt_HMS_JWT_AUTH_DB_" + UUID.randomUUID()).toLowerCase();
        HiveMetaStoreClient client = new HiveMetaStoreClient(conf);
        try {
            Database createdDb = new Database();
            createdDb.setName(dbName);
            client.createDatabase(createdDb);
            Database dbFromServer = client.getDatabase(dbName);
            Assert.assertEquals((Object)dbName, (Object)dbFromServer.getName());
        }
        finally {
            try {
                client.dropDatabase(dbName);
            }
            catch (Exception e) {
                LOG.warn("Failed to drop database: " + dbName + ". Error message: " + e);
            }
            try {
                client.close();
            }
            catch (Exception e) {
                LOG.error("Failed to close metastore client");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=TTransportException.class)
    public void testExpiredJWT() throws Exception {
        String validJwtToken = this.generateJWT(USER_1, jwtAuthorizedKeyFile.toPath(), TimeUnit.MILLISECONDS.toMillis(2L));
        System.getenv().put("HMS_JWT", validJwtToken);
        String dbName = ("expired_jwt_HMS_JWT_AUTH_DB_" + UUID.randomUUID()).toLowerCase();
        HiveMetaStoreClient client = new HiveMetaStoreClient(conf);
        try {
            Thread.sleep(TimeUnit.MILLISECONDS.toMillis(2L));
            Database createdDb = new Database();
            createdDb.setName(dbName);
            client.createDatabase(createdDb);
        }
        catch (InterruptedException e) {
        }
        finally {
            try {
                client.close();
            }
            catch (Exception e) {
                LOG.error("Failed to close metastore client");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=TTransportException.class)
    public void testInvalidJWT() throws Exception {
        String jwtToken = this.generateJWT(USER_1, jwtUnauthorizedKeyFile.toPath(), TimeUnit.MINUTES.toMillis(2L));
        System.getenv().put("HMS_JWT", jwtToken);
        String dbName = ("invalid_jwt_HMS_JWT_AUTH_DB_" + UUID.randomUUID()).toLowerCase();
        HiveMetaStoreClient client = new HiveMetaStoreClient(conf);
        try {
            Thread.sleep(TimeUnit.MILLISECONDS.toMillis(2L));
            Database createdDb = new Database();
            createdDb.setName(dbName);
            client.createDatabase(createdDb);
        }
        catch (InterruptedException e) {
        }
        finally {
            try {
                client.close();
            }
            catch (Exception e) {
                LOG.error("Failed to close metastore client");
            }
        }
    }

    private String generateJWT(String user, Path keyFile, long lifeTimeMillis) throws Exception {
        RSAKey rsaKeyPair = RSAKey.parse((String)new String(Files.readAllBytes(keyFile), StandardCharsets.UTF_8));
        RSASSASigner signer = new RSASSASigner(rsaKeyPair);
        JWSHeader header = new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(rsaKeyPair.getKeyID()).build();
        Date now = new Date();
        Date expirationTime = new Date(now.getTime() + lifeTimeMillis);
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().jwtID(UUID.randomUUID().toString()).issueTime(now).issuer("auth-server").subject(user).expirationTime(expirationTime).claim("custom-claim-or-payload", (Object)"custom-claim-or-payload").build();
        SignedJWT signedJWT = new SignedJWT(header, claimsSet);
        signedJWT.sign((JWSSigner)signer);
        return signedJWT.serialize();
    }

    static {
        baseDir = System.getProperty("basedir");
        jwtAuthorizedKeyFile = new File(baseDir, "src/test/resources/auth/jwt/jwt-authorized-key.json");
        jwtUnauthorizedKeyFile = new File(baseDir, "src/test/resources/auth/jwt/jwt-unauthorized-key.json");
        jwtVerificationJWKSFile = new File(baseDir, "src/test/resources/auth/jwt/jwt-verification-jwks.json");
        LOG = LoggerFactory.getLogger(TestRemoteHiveMetastoreWithHttpJwt.class);
        MOCK_JWKS_SERVER = new WireMockRule(8089);
        conf = null;
    }
}

