/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.sasl.AuthenticationException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStorePasswdAuthenticationProvider;
import org.apache.hadoop.hive.metastore.TestRemoteHiveMetaStore;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreCheckinTest.class})
public class TestRemoteHiveMetaStoreCustomAuth
extends TestRemoteHiveMetaStore {
    private static String correctUser = "correct_user";
    private static String correctPassword = "correct_passwd";
    private static String wrongPassword = "wrong_password";
    private static String wrongUser = "wrong_user";
    private static String testDataDir = new File(System.getProperty("java.io.tmpdir") + File.separator + TestRemoteHiveMetaStoreCustomAuth.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");

    @BeforeClass
    public static void beforeTests() throws Exception {
        TestRemoteHiveMetaStoreCustomAuth.createTestDir();
    }

    @AfterClass
    public static void afterTests() throws IOException {
        FileUtils.deleteDirectory((File)new File(testDataDir));
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.initConf();
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_METASTORE_AUTHENTICATION, (String)"CUSTOM");
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_CUSTOM_AUTHENTICATION_CLASS, (String)"org.apache.hadoop.hive.metastore.TestRemoteHiveMetaStoreCustomAuth$SimpleAuthenticationProviderImpl");
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXECUTE_SET_UGI, (boolean)false);
        super.setUp();
    }

    private static void createTestDir() {
        if (!new File(testDataDir).mkdirs()) {
            throw new RuntimeException("Could not create " + testDataDir);
        }
    }

    private String createCredFile(String userName, String passWord) throws Exception {
        String fileName = "hms_auth_" + userName + "_" + passWord + ".jceks";
        String credUrl = "jceks://file" + testDataDir + File.separator + fileName;
        Configuration credConf = new Configuration();
        credConf.set("hadoop.security.credential.provider.path", credUrl);
        CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)credConf).get(0);
        provider.createCredentialEntry(userName, passWord.toCharArray());
        provider.flush();
        return credUrl;
    }

    @Override
    protected HiveMetaStoreClient createClient() throws Exception {
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS, (String)("thrift://localhost:" + port));
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_CLIENT_AUTH_MODE, (String)"PLAIN");
        String credsCUWP = this.createCredFile(correctUser, wrongPassword);
        conf.set("hadoop.security.credential.provider.path", credsCUWP);
        String exceptionMessage = null;
        try {
            MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_CLIENT_PLAIN_USERNAME, (String)correctUser);
            HiveMetaStoreClient hiveMetaStoreClient = new HiveMetaStoreClient(conf);
        }
        catch (MetaException e) {
            exceptionMessage = e.getMessage();
        }
        Assert.assertNotNull((Object)exceptionMessage);
        Assert.assertTrue((boolean)exceptionMessage.contains("Error validating the login"));
        exceptionMessage = null;
        try {
            MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_CLIENT_PLAIN_USERNAME, (String)wrongUser);
            HiveMetaStoreClient e = new HiveMetaStoreClient(conf);
        }
        catch (MetaException e) {
            exceptionMessage = e.getMessage();
        }
        Assert.assertNotNull((Object)exceptionMessage);
        Assert.assertTrue((boolean)exceptionMessage.contains("No password found for user"));
        exceptionMessage = null;
        String credsWUWP = this.createCredFile(wrongUser, wrongPassword);
        conf.set("hadoop.security.credential.provider.path", credsWUWP);
        try {
            MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_CLIENT_PLAIN_USERNAME, (String)wrongUser);
            HiveMetaStoreClient hiveMetaStoreClient = new HiveMetaStoreClient(conf);
        }
        catch (MetaException e) {
            exceptionMessage = e.getMessage();
        }
        Assert.assertNotNull((Object)exceptionMessage);
        Assert.assertTrue((boolean)exceptionMessage.contains("Error validating the login"));
        String credsCUCP = this.createCredFile(correctUser, correctPassword);
        conf.set("hadoop.security.credential.provider.path", credsCUCP);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_CLIENT_PLAIN_USERNAME, (String)correctUser);
        return new HiveMetaStoreClient(conf);
    }

    public static class SimpleAuthenticationProviderImpl
    implements MetaStorePasswdAuthenticationProvider {
        private Map<String, String> userMap = new HashMap<String, String>();

        public SimpleAuthenticationProviderImpl() {
            this.init();
        }

        private void init() {
            this.userMap.put(correctUser, correctPassword);
        }

        public void authenticate(String user, String password) throws AuthenticationException {
            if (!this.userMap.containsKey(user)) {
                throw new AuthenticationException("Invalid user : " + user);
            }
            if (!this.userMap.get(user).equals(password)) {
                throw new AuthenticationException("Invalid passwd : " + password);
            }
        }
    }
}

