/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.retry.RetryOneTime;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.zookeeper.CreateMode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRemoteHMSZKNegative {
    private TestingServer zkServer;
    private Configuration conf;
    private CuratorFramework zkClient;
    private String rootNamespace = this.getClass().getSimpleName();

    @Before
    public void setUp() throws Exception {
        this.zkServer = new TestingServer();
        this.conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS, (String)this.zkServer.getConnectString());
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_ZOOKEEPER_NAMESPACE, (String)this.rootNamespace);
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_SERVICE_DISCOVERY_MODE, (String)"zookeeper");
        this.zkClient = CuratorFrameworkFactory.newClient((String)this.zkServer.getConnectString(), (RetryPolicy)new RetryOneTime(2000));
        this.zkClient.start();
        ((ACLBackgroundPathAndBytesable)this.zkClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath("/" + this.rootNamespace);
    }

    @Test
    public void createClient() {
        try {
            new HiveMetaStoreClient(this.conf);
            Assert.fail((String)"an exception is expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof MetaException));
            Assert.assertTrue((boolean)e.getMessage().contains("No metastore service discovered in ZooKeeper"));
        }
    }

    @After
    public void stop() throws Exception {
        if (this.zkClient != null) {
            this.zkClient.close();
        }
        if (this.zkServer != null) {
            this.zkServer.stop();
        }
    }
}

