/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.MetastoreDefaultTransformer;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionsRequest;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Ignore(value="HIVE-28659")
@Category(value={MetastoreUnitTest.class})
public class TestMetaStoreDeadlock {
    private Configuration conf;
    private static int POOL_SIZE = 3;
    private static CountDownLatch LATCH1 = new CountDownLatch(POOL_SIZE + 1);
    private static CountDownLatch LATCH2 = new CountDownLatch(POOL_SIZE);

    @Before
    public void setUp() throws Exception {
        this.conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_MAX_CONNECTIONS, (long)POOL_SIZE);
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_METADATA_TRANSFORMER_CLASS, (String)SleepOnGetPartitions.class.getName());
        MetastoreConf.setTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CLIENT_SOCKET_TIMEOUT, (long)1L, (TimeUnit)TimeUnit.HOURS);
        this.conf.setLong("hikaricp.connectionTimeout", 3600000L);
        MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), this.conf);
    }

    @Test(timeout=60000L)
    public void testLockContention() throws Exception {
        String dbName = "_test_deadlock_";
        String tableName1 = "tbl1";
        try (HiveMetaStoreClient msc = new HiveMetaStoreClient(this.conf);){
            new DatabaseBuilder().setName(dbName).create((IMetaStoreClient)msc, this.conf);
            ((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tableName1).addCol("a", "string")).addPartCol("dt", "string").create((IMetaStoreClient)msc, this.conf);
            Table table1 = msc.getTable(dbName, tableName1);
            new PartitionBuilder().inTable(table1).addValue("2024-09-29").addToTable((IMetaStoreClient)msc, this.conf);
        }
        GetPartitionsByNamesRequest request = new GetPartitionsByNamesRequest(dbName, tableName1);
        request.setNames(Arrays.asList("dt=2024-09-28"));
        request.setProcessorCapabilities(Arrays.asList("HIVEFULLACIDWRITE", "HIVEFULLACIDREAD", "HIVEMANAGEDINSERTWRITE"));
        Thread[] holdConnThreads = new Thread[POOL_SIZE];
        for (int i = 0; i < POOL_SIZE; ++i) {
            holdConnThreads[i] = new Thread(() -> {
                try (HiveMetaStoreClient client = new HiveMetaStoreClient(this.conf);){
                    LATCH1.countDown();
                    client.getPartitionsByNames(request);
                }
                catch (TException e) {
                    throw new RuntimeException(e);
                }
            });
            holdConnThreads[i].start();
        }
        LATCH2.await();
        Thread holdMS = new Thread(() -> {
            try (HiveMetaStoreClient client = new HiveMetaStoreClient(this.conf);){
                client.getPartitionsRequest(new PartitionsRequest(dbName, tableName1)).getPartitions();
            }
            catch (TException e) {
                throw new RuntimeException(e);
            }
        });
        holdMS.start();
        Thread.sleep(5000L);
        LATCH1.countDown();
        Assert.assertEquals((long)0L, (long)LATCH1.getCount());
        holdMS.join();
    }

    public static class SleepOnGetPartitions
    extends MetastoreDefaultTransformer {
        public SleepOnGetPartitions(IHMSHandler handler) throws HiveMetaException {
            super(handler);
        }

        public List<Partition> transformPartitions(List<Partition> objects, Table table, List<String> processorCapabilities, String processorId) throws MetaException {
            try {
                LATCH2.countDown();
                LATCH1.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return super.transformPartitions(objects, table, processorCapabilities, processorId);
        }
    }
}

