/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStorePreEventListener;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.util.StringUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestHmsServerAuthorization {
    private static HiveMetaStoreClient client;
    private static Configuration conf;
    private static final int DEFAULT_LIMIT_PARTITION_REQUEST = 100;
    private static String dbName1;
    private static String dbName2;
    private static final String TAB1 = "tab1";
    private static final String TAB2 = "tab2";

    protected static HiveMetaStoreClient createClient(Configuration metaStoreConf) throws Exception {
        try {
            return new HiveMetaStoreClient(metaStoreConf);
        }
        catch (Throwable e) {
            System.err.println("Unable to open the metastore");
            System.err.println(StringUtils.stringifyException((Throwable)e));
            throw new Exception(e);
        }
    }

    @BeforeClass
    public static void setUpForTest() throws Exception {
        DummyAuthorizationListenerImpl.throwExceptionAtCall = false;
        conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_CONNECTION_RETRIES, (long)3L);
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        MetastoreConf.setClass((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PRE_EVENT_LISTENERS, DummyAuthorizationListenerImpl.class, MetaStorePreEventListener.class);
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_ENABLED, (boolean)true);
        conf.set("hive.key1", "value1");
        conf.set("hive.key2", "http://www.example.com");
        conf.set("hive.key3", "");
        conf.set("hive.key4", "0");
        conf.set("datanucleus.autoCreateTables", "false");
        conf.set("hive.in.test", "true");
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX, (long)2L);
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.LIMIT_PARTITION_REQUEST, (long)100L);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STORAGE_SCHEMA_READER_IMPL, (String)"no.such.class");
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_CLIENT_FILTER_ENABLED, (boolean)false);
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_SERVER_FILTER_ENABLED, (boolean)false);
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        client = TestHmsServerAuthorization.createClient(conf);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (client != null) {
            DummyAuthorizationListenerImpl.throwExceptionAtCall = false;
            client.dropDatabase(dbName1, true, true, true);
            client.dropDatabase(dbName2, true, true, true);
            client.close();
        }
    }

    protected void creatEnv(Configuration conf) throws Exception {
        client.dropDatabase(dbName1, true, true, true);
        client.dropDatabase(dbName2, true, true, true);
        Database db1 = new DatabaseBuilder().setName(dbName1).setCatalogName("hive").create((IMetaStoreClient)client, conf);
        Database db2 = new DatabaseBuilder().setName(dbName2).setCatalogName("hive").create((IMetaStoreClient)client, conf);
        ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName1).setTableName(TAB1).addCol("id", "int")).addCol("name", "string")).create((IMetaStoreClient)client, conf);
        Table tab2 = ((TableBuilder)new TableBuilder().setDbName(dbName1).setTableName(TAB2).addCol("id", "int")).addPartCol("name", "string").create((IMetaStoreClient)client, conf);
        new PartitionBuilder().inTable(tab2).addValue("value1").addToTable((IMetaStoreClient)client, conf);
        new PartitionBuilder().inTable(tab2).addValue("value2").addToTable((IMetaStoreClient)client, conf);
    }

    @Test
    public void testGetFields() throws Exception {
        dbName1 = "db_test_get_fields_1";
        dbName2 = "db_test_get_fields_2";
        this.creatEnv(conf);
        DummyAuthorizationListenerImpl.throwExceptionAtCall = true;
        try {
            List tableSchema = client.getFields(dbName1, TAB1);
            Assert.fail((String)"getFields() should fail with throw exception mode at server side");
        }
        catch (MetaException ex) {
            boolean isMessageAuthorization = ex.getMessage().contains("Authorization fails");
            Assert.assertEquals((Object)true, (Object)isMessageAuthorization);
        }
    }

    static {
        dbName1 = "testdb1";
        dbName2 = "testdb2";
    }

    public static class DummyAuthorizationListenerImpl
    extends MetaStorePreEventListener {
        private static volatile boolean throwExceptionAtCall = false;

        public DummyAuthorizationListenerImpl(Configuration config) {
            super(config);
        }

        public void onEvent(PreEventContext context) throws MetaException, NoSuchObjectException, InvalidOperationException {
            if (throwExceptionAtCall) {
                throw new MetaException("Authorization fails");
            }
        }
    }
}

