/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreCheckinTest.class})
public class TestHiveMetastoreHttpHeaders {
    private static Configuration conf;
    private static HiveMetaStoreClient msc;
    private static int port;
    private static final String testHeaderKey1 = "X-XXXX";
    private static final String testHeaderVal1 = "yyyy";
    private static final String testHeaderKey2 = "X-ZZZZ";
    private static final String testHeaderVal2 = "aaaa";

    @Before
    public void setUp() throws Exception {
        conf = MetastoreConf.newMetastoreConf();
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXECUTE_SET_UGI, (boolean)false);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_TRANSPORT_MODE, (String)"http");
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_CLIENT_THRIFT_TRANSPORT_MODE, (String)"http");
        port = MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), conf);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS, (String)("thrift://localhost:" + port));
    }

    @Test
    public void testHttpHeaders() throws Exception {
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_CLIENT_ADDITIONAL_HEADERS, (String)String.format("%s=%s,%s=%s", testHeaderKey1, testHeaderVal1, testHeaderKey2, testHeaderVal2));
        msc = new TestHiveMetaStoreClient(conf);
        Database db = new DatabaseBuilder().setName("testHttpHeader").create((IMetaStoreClient)msc, conf);
        msc.dropDatabase(db.getName());
    }

    @Test
    public void testIllegalHttpHeaders() throws Exception {
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_CLIENT_ADDITIONAL_HEADERS, (String)String.format("%s%s", testHeaderKey1, testHeaderVal1));
        msc = new TestHiveMetaStoreClient(conf);
        boolean exceptionThrown = false;
        try {
            Database db = new DatabaseBuilder().setName("testHttpHeader").create((IMetaStoreClient)msc, conf);
            msc.dropDatabase(db.getName());
        }
        catch (Exception e) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Illegal header should invoke thrown exception", (boolean)exceptionThrown);
    }

    static class TestHiveMetaStoreClient
    extends HiveMetaStoreClient {
        public TestHiveMetaStoreClient(Configuration conf) throws MetaException {
            super(conf);
        }

        protected HttpClientBuilder createHttpClientBuilder() throws MetaException {
            HttpClientBuilder builder = super.createHttpClientBuilder();
            builder.addInterceptorLast(new HttpRequestInterceptor(){

                public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
                    Header header1 = httpRequest.getFirstHeader(TestHiveMetastoreHttpHeaders.testHeaderKey1);
                    Assert.assertEquals((Object)TestHiveMetastoreHttpHeaders.testHeaderVal1, (Object)header1.getValue());
                    Header header2 = httpRequest.getFirstHeader(TestHiveMetastoreHttpHeaders.testHeaderKey2);
                    Assert.assertEquals((Object)TestHiveMetastoreHttpHeaders.testHeaderVal2, (Object)header2.getValue());
                }
            });
            return builder;
        }
    }
}

