/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.IPStackUtils;
import org.apache.hadoop.hive.metastore.AbstractHMSHandlerProxy;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.MockPartitionExpressionForMetastore;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreCheckinTest.class})
public class TestHiveMetaStoreTimeout {
    protected static HiveMetaStoreClient client;
    protected static Configuration conf;
    protected static Warehouse warehouse;
    protected static int port;
    private final String dbName = "db";

    @BeforeClass
    public static void startMetaStoreServer() throws Exception {
        conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setClass((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS, MockPartitionExpressionForMetastore.class, PartitionExpressionProxy.class);
        MetastoreConf.setTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CLIENT_SOCKET_TIMEOUT, (long)10000L, (TimeUnit)TimeUnit.MILLISECONDS);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HMS_HANDLER_PROXY_CLASS, (String)DelayedHMSHandler.class.getName());
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        warehouse = new Warehouse(conf);
        port = MetaStoreTestUtils.startMetaStoreWithRetry(conf);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS, (String)("thrift://localhost:" + port));
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXECUTE_SET_UGI, (boolean)false);
    }

    @Before
    public void setup() throws MetaException {
        DelayedHMSHandler.testTimeoutValue = -1L;
        client = new HiveMetaStoreClient(conf);
    }

    @After
    public void cleanup() throws TException {
        client.close();
        client = null;
    }

    @Test
    public void testNoTimeout() throws Exception {
        new DatabaseBuilder().setName("db").create((IMetaStoreClient)client, conf);
        client.dropDatabase("db", true, true);
    }

    @Test
    public void testTimeout() throws Exception {
        DelayedHMSHandler.testTimeoutValue = 15000L;
        Database db = new DatabaseBuilder().setName("db").build(conf);
        try {
            client.createDatabase(db);
            Assert.fail((String)"should throw timeout exception.");
        }
        catch (TTransportException e) {
            Assert.assertTrue((String)"unexpected Exception", (boolean)e.getMessage().contains("Read timed out"));
        }
        DelayedHMSHandler.testTimeoutValue = -1L;
    }

    @Test
    public void testResetTimeout() throws Exception {
        Database db = new DatabaseBuilder().setName("db").build(conf);
        try {
            client.createDatabase(db);
        }
        catch (Exception e) {
            Assert.fail((String)("should not throw timeout exception: " + e.getMessage()));
        }
        client.dropDatabase("db", true, true);
        DelayedHMSHandler.testTimeoutValue = 15000L;
        try {
            client.createDatabase(db);
            Assert.fail((String)"should throw timeout exception.");
        }
        catch (TTransportException e) {
            Assert.assertTrue((String)"unexpected Exception", (boolean)e.getMessage().contains("Read timed out"));
        }
    }

    @Test
    public void testConnectionTimeout() throws Exception {
        Configuration newConf = new Configuration(conf);
        MetastoreConf.setTimeVar((Configuration)newConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CLIENT_CONNECTION_TIMEOUT, (long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
        MetastoreConf.setVar((Configuration)newConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS, (String)("thrift://" + IPStackUtils.transformToIPv6((String)"1.1.1.1", (int)port)));
        MetastoreConf.setLongVar((Configuration)newConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_CONNECTION_RETRIES, (long)1L);
        Future<Void> future = Executors.newSingleThreadExecutor().submit(() -> {
            try (HiveMetaStoreClient c = new HiveMetaStoreClient(newConf);){
                Assert.fail((String)"should throw connection timeout exception.");
            }
            catch (MetaException e) {
                Assert.assertTrue((String)"unexpected Exception", (boolean)e.getMessage().contains("Connect timed out"));
            }
            return null;
        });
        future.get(5L, TimeUnit.SECONDS);
    }

    static class DelayedHMSHandler
    extends AbstractHMSHandlerProxy {
        static long testTimeoutValue = -1L;

        public DelayedHMSHandler(Configuration conf, IHMSHandler baseHandler, boolean local) throws MetaException {
            super(conf, baseHandler, local);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected AbstractHMSHandlerProxy.Result invokeInternal(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Object object;
                boolean isStarted = Deadline.startTimer((String)method.getName());
                try {
                    if (testTimeoutValue > 0L && (method.getName().equals("create_database") || method.getName().equals("create_database_req"))) {
                        try {
                            Thread.sleep(testTimeoutValue);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Deadline.checkTimeout();
                    }
                    object = method.invoke((Object)this.baseHandler, args);
                }
                finally {
                    if (isStarted) {
                        Deadline.stopTimer();
                    }
                }
                return new AbstractHMSHandlerProxy.Result(object, "error=false");
            }
            catch (InvocationTargetException | UndeclaredThrowableException e) {
                throw e.getCause();
            }
        }
    }
}

