/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreCheckinTest.class})
public class TestHiveMetaStoreMethods {
    HMSHandler hmsHandler;
    protected static Warehouse warehouse;
    protected static Configuration conf;

    @Before
    public void setUp() throws Exception {
        this.initConf();
        warehouse = new Warehouse(conf);
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_ENABLED, (boolean)true);
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        this.hmsHandler = new HMSHandler("hive-conf", conf);
        this.hmsHandler.init();
    }

    protected void initConf() {
        if (null == conf) {
            conf = MetastoreConf.newMetastoreConf();
        }
    }

    @Test(expected=InvalidObjectException.class)
    public void test_get_partitions_by_names() throws Exception {
        this.hmsHandler.get_partitions_by_names("dbName", "tblName", Arrays.asList("partNames"));
    }

    static {
        conf = null;
    }
}

