/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.common.IPStackUtils;
import org.apache.hadoop.hive.common.ZooKeeperHiveHelper;
import org.apache.hadoop.hive.metastore.DefaultPartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.EventCleanerTask;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStoreTestUtils {
    private static Map<Integer, Thread> map = new HashMap<Integer, Thread>();
    private static final Logger LOG = LoggerFactory.getLogger(MetaStoreTestUtils.class);
    private static final String TMP_DIR = System.getProperty("test.tmp.dir");
    public static final int RETRY_COUNT = 10;

    public static void startMetaStore(int port, HadoopThriftAuthBridge bridge, Configuration conf, boolean withHouseKeepingThreads, boolean waitForHouseKeepers) throws Exception {
        if (conf == null) {
            conf = MetastoreConf.newMetastoreConf();
        }
        Configuration finalConf = conf;
        AtomicBoolean startedBackgroundThreads = withHouseKeepingThreads && waitForHouseKeepers ? new AtomicBoolean() : null;
        Thread thread = new Thread(() -> {
            try {
                HiveMetaStore.startMetaStore((int)port, (HadoopThriftAuthBridge)bridge, (Configuration)finalConf, (boolean)withHouseKeepingThreads, (AtomicBoolean)startedBackgroundThreads);
            }
            catch (Throwable e) {
                LOG.error("Metastore Thrift Server threw an exception...", e);
            }
        }, "MetaStoreThread-" + port);
        thread.setDaemon(true);
        thread.start();
        map.put(port, thread);
        String msHost = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_BIND_HOST);
        MetaStoreTestUtils.loopUntilHMSReady(msHost, port, startedBackgroundThreads);
        String serviceDiscMode = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_SERVICE_DISCOVERY_MODE);
        if (serviceDiscMode != null && serviceDiscMode.equalsIgnoreCase("zookeeper")) {
            MetaStoreTestUtils.loopUntilZKReady(conf, msHost, port);
        }
    }

    public static void close(int port) {
        Thread thread = map.get(port);
        if (thread != null) {
            thread.stop();
        }
    }

    public static int startMetaStoreWithRetry(HadoopThriftAuthBridge bridge) throws Exception {
        return MetaStoreTestUtils.startMetaStoreWithRetry(bridge, MetastoreConf.newMetastoreConf());
    }

    public static int startMetaStoreWithRetry(Configuration conf) throws Exception {
        return MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), conf);
    }

    public static int startMetaStoreWithRetry(Configuration conf, boolean keepWarehousePath) throws Exception {
        return MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), conf, false, keepWarehousePath, false, false);
    }

    public static int startMetaStoreWithRetry(Configuration conf, boolean keepJdbcUri, boolean keepWarehousePath) throws Exception {
        return MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), conf, keepJdbcUri, keepWarehousePath, false, false);
    }

    public static int startMetaStoreWithRetry() throws Exception {
        return MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), MetastoreConf.newMetastoreConf());
    }

    public static int startMetaStoreWithRetry(HadoopThriftAuthBridge bridge, Configuration conf) throws Exception {
        return MetaStoreTestUtils.startMetaStoreWithRetry(bridge, conf, false, false, false, false);
    }

    public static int startMetaStoreWithRetry(HadoopThriftAuthBridge bridge, Configuration conf, boolean withHouseKeepingThreads) throws Exception {
        return MetaStoreTestUtils.startMetaStoreWithRetry(bridge, conf, false, false, withHouseKeepingThreads, false);
    }

    public static int startMetaStoreWithRetry(HadoopThriftAuthBridge bridge, Configuration conf, boolean keepJdbcUri, boolean keepWarehousePath, boolean withHouseKeepingThreads, boolean waitForHouseKeepers) throws Exception {
        return MetaStoreTestUtils.startMetaStoreWithRetry(bridge, conf, keepJdbcUri, keepWarehousePath, withHouseKeepingThreads, waitForHouseKeepers, true);
    }

    public static int startMetaStoreWithRetry(HadoopThriftAuthBridge bridge, Configuration conf, boolean keepJdbcUri, boolean keepWarehousePath, boolean withHouseKeepingThreads, boolean waitForHouseKeepers, boolean createTransactionalTables) throws Exception {
        ConnectException metaStoreException = null;
        String warehouseDir = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE);
        for (int tryCount = 0; tryCount < 10; ++tryCount) {
            try {
                int metaStorePort = MetaStoreTestUtils.findFreePort();
                if (!keepWarehousePath) {
                    Path postfixedWarehouseDir = new Path(warehouseDir, String.valueOf(metaStorePort));
                    MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE, (String)postfixedWarehouseDir.toString());
                    warehouseDir = postfixedWarehouseDir.toString();
                }
                Object jdbcUrl = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY);
                if (!keepJdbcUri) {
                    jdbcUrl = "jdbc:derby:memory:" + TMP_DIR + File.separator + "junit_metastore_db_" + metaStorePort + ";create=true";
                    MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY, (String)jdbcUrl);
                }
                if (MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_SERVICE_DISCOVERY_MODE).trim().isEmpty()) {
                    MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS, (String)("thrift://localhost:" + metaStorePort));
                }
                if (createTransactionalTables) {
                    Configuration txnInitConf = new Configuration(conf);
                    TestTxnDbUtil.setConfValues(txnInitConf);
                    TestTxnDbUtil.prepDb(txnInitConf);
                }
                MetaStoreTestUtils.startMetaStore(metaStorePort, bridge, conf, withHouseKeepingThreads, waitForHouseKeepers);
                Warehouse wh = new Warehouse(conf);
                if (!wh.isDir(wh.getWhRoot())) {
                    FileSystem fs = wh.getWhRoot().getFileSystem(conf);
                    fs.mkdirs(wh.getWhRoot());
                    fs.setPermission(wh.getWhRoot(), new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
                    LOG.info("MetaStore warehouse root dir ({}) is created", (Object)warehouseDir);
                }
                LOG.info("MetaStore Thrift Server started on port: {} with warehouse dir: {} with jdbcUrl: {}", new Object[]{metaStorePort, warehouseDir, jdbcUrl});
                return metaStorePort;
            }
            catch (ConnectException ce) {
                metaStoreException = ce;
                continue;
            }
        }
        throw metaStoreException;
    }

    private static void loopUntilHMSReady(String msHost, int port, AtomicBoolean houseKeepingStarted) throws Exception {
        int retries = 0;
        Throwable exc = null;
        while (retries++ < 60) {
            try {
                Socket socket = new Socket();
                InetSocketAddress sockAddr = msHost == null ? new InetSocketAddress(port) : new InetSocketAddress(msHost, port);
                socket.connect(sockAddr, 5000);
                socket.close();
                if (houseKeepingStarted == null || houseKeepingStarted.get()) {
                    return;
                }
                LOG.info("HMS started, waiting for housekeeper threads to start.");
            }
            catch (Exception e) {
                LOG.info("Waiting the HMS to start.");
                exc = e;
            }
            Thread.sleep(1000L);
        }
        if (exc == null) {
            exc = new IllegalStateException("HMS started, but housekeeping threads were not started until 60 sec.");
        }
        LOG.error("Unable to connect to metastore server: " + exc.getMessage());
        LOG.info("Printing all thread stack traces for debugging before throwing exception.");
        LOG.info(MetaStoreTestUtils.getAllThreadStacksAsString());
        throw exc;
    }

    private static void loopUntilZKReady(Configuration conf, String msHost, int port) throws Exception {
        ZooKeeperHiveHelper zkHelper = MetastoreConf.getZKConfig((Configuration)conf);
        String uri = msHost != null && !msHost.trim().isEmpty() ? msHost : InetAddress.getLocalHost().getHostName();
        uri = IPStackUtils.concatHostPort((String)uri, (int)port);
        int retries = 0;
        while (true) {
            try {
                List serverUris = zkHelper.getServerUris();
                if (!serverUris.equals(Collections.singletonList(uri))) {
                    throw new Exception("Expected metastore URI " + uri + " but got " + serverUris);
                }
                return;
            }
            catch (Exception e) {
                if (retries++ > 60) {
                    LOG.error("Unable to get metastore URI from the ZooKeeper: " + e.getMessage());
                    throw e;
                }
                Thread.sleep(1000L);
                continue;
            }
            break;
        }
    }

    private static String getAllThreadStacksAsString() {
        Map<Thread, StackTraceElement[]> threadStacks = Thread.getAllStackTraces();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Thread, StackTraceElement[]> entry : threadStacks.entrySet()) {
            Thread t = entry.getKey();
            sb.append(System.lineSeparator());
            sb.append("Name: ").append(t.getName()).append(" State: ").append((Object)t.getState());
            MetaStoreTestUtils.addStackString(entry.getValue(), sb);
        }
        return sb.toString();
    }

    private static void addStackString(StackTraceElement[] stackElems, StringBuilder sb) {
        sb.append(System.lineSeparator());
        for (StackTraceElement stackElem : stackElems) {
            sb.append(stackElem).append(System.lineSeparator());
        }
    }

    public static int findFreePort() throws IOException {
        ServerSocket socket = new ServerSocket(0);
        int port = socket.getLocalPort();
        socket.close();
        return port;
    }

    public static int findFreePortExcepting(int portToExclude) throws IOException {
        try (ServerSocket socket1 = new ServerSocket(0);){
            ServerSocket socket2;
            block12: {
                int n;
                socket2 = new ServerSocket(0);
                try {
                    if (socket1.getLocalPort() == portToExclude) break block12;
                    n = socket1.getLocalPort();
                }
                catch (Throwable throwable) {
                    try {
                        socket2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                socket2.close();
                return n;
            }
            int n = socket2.getLocalPort();
            socket2.close();
            return n;
        }
    }

    public static void setConfForStandloneMode(Configuration conf) {
        if (MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TASK_THREADS_ALWAYS).equals(MetastoreConf.ConfVars.TASK_THREADS_ALWAYS.getDefaultVal())) {
            MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TASK_THREADS_ALWAYS, (String)EventCleanerTask.class.getName());
        }
        if (MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS).equals(MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS.getDefaultVal())) {
            MetastoreConf.setClass((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS, DefaultPartitionExpressionProxy.class, PartitionExpressionProxy.class);
        }
    }

    public static String getTestWarehouseDir(String name) {
        File dir = new File(System.getProperty("java.io.tmpdir"), name);
        dir.deleteOnExit();
        return dir.getAbsolutePath();
    }

    public static void dropCatalogCascade(IMetaStoreClient client, String catName) throws TException {
        if (catName != null && !catName.equals("hive")) {
            List databases = client.getAllDatabases(catName);
            for (String db : databases) {
                client.dropDatabase(catName, db, true, false, true);
            }
            client.dropCatalog(catName);
        }
    }

    public static void waitForAssertion(String assertionContext, Runnable assertionRunnable, int msBetweenAssertionAttempts, int msOverallTimeout) throws Exception {
        if (msOverallTimeout <= 0) {
            msOverallTimeout = Integer.MAX_VALUE;
        }
        long start = System.currentTimeMillis();
        LOG.info("Waiting for assertion: " + assertionContext);
        while (true) {
            try {
                assertionRunnable.run();
                LOG.info("waitForAssertion passed in {} ms", (Object)(System.currentTimeMillis() - start));
                return;
            }
            catch (AssertionError e) {
                LOG.info("AssertionError: " + ((Throwable)((Object)e)).getMessage());
                long elapsedMs = System.currentTimeMillis() - start;
                if (elapsedMs > (long)msOverallTimeout) {
                    LOG.info("waitForAssertion failed in {} ms", (Object)elapsedMs);
                    String message = ((Throwable)((Object)e)).getMessage();
                    throw new AssertionError(message + " (waitForAssertion timeout: " + elapsedMs + "ms)", (Throwable)((Object)e));
                }
                Thread.sleep(msBetweenAssertionAttempts);
                continue;
            }
            break;
        }
    }
}

