/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.ndv.hll;

import org.apache.hadoop.hive.common.ndv.hll.HyperLogLog;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestHyperLogLog {
    private float longRangeTolerance = 5.0f;
    private float shortRangeTolerance = 2.0f;

    @Test(expected=IllegalArgumentException.class)
    public void testHLLDenseMerge() {
        HyperLogLog hll = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.DENSE).build();
        HyperLogLog hll2 = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.DENSE).build();
        HyperLogLog hll3 = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.DENSE).build();
        HyperLogLog hll4 = HyperLogLog.builder().setNumRegisterIndexBits(16).setEncoding(HyperLogLog.EncodingType.DENSE).build();
        HyperLogLog hll5 = HyperLogLog.builder().setNumRegisterIndexBits(12).setEncoding(HyperLogLog.EncodingType.DENSE).build();
        int size = 1000;
        for (int i = 0; i < size; ++i) {
            hll.addLong((long)i);
            hll2.addLong((long)(size + i));
            hll3.addLong((long)(2 * size + i));
            hll4.addLong((long)(3 * size + i));
        }
        double threshold = size > 40000 ? (double)this.longRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)size / 100.0;
        double delta4 = threshold * (double)(4 * size) / 100.0;
        Assert.assertEquals((double)size, (double)hll.count(), (double)delta);
        Assert.assertEquals((double)size, (double)hll2.count(), (double)delta);
        hll.merge(hll2);
        Assert.assertEquals((double)(2.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.DENSE, (Object)hll.getEncoding());
        hll.merge(hll2);
        Assert.assertEquals((double)(2.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.DENSE, (Object)hll.getEncoding());
        hll.merge(hll3);
        Assert.assertEquals((double)(3.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.DENSE, (Object)hll.getEncoding());
        hll.merge(hll4);
        Assert.assertEquals((double)(4.0 * (double)size), (double)hll.count(), (double)delta4);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.DENSE, (Object)hll.getEncoding());
        hll.merge(hll5);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHLLSparseMerge() {
        HyperLogLog hll = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        HyperLogLog hll2 = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        HyperLogLog hll3 = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        HyperLogLog hll4 = HyperLogLog.builder().setNumRegisterIndexBits(16).setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        HyperLogLog hll5 = HyperLogLog.builder().setNumRegisterIndexBits(12).setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        int size = 500;
        for (int i = 0; i < size; ++i) {
            hll.addLong((long)i);
            hll2.addLong((long)(size + i));
            hll3.addLong((long)(2 * size + i));
            hll4.addLong((long)(3 * size + i));
        }
        double threshold = size > 40000 ? (double)this.longRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)size / 100.0;
        double delta4 = threshold * (double)(4 * size) / 100.0;
        Assert.assertEquals((double)size, (double)hll.count(), (double)delta);
        Assert.assertEquals((double)size, (double)hll2.count(), (double)delta);
        hll.merge(hll2);
        Assert.assertEquals((double)(2.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.SPARSE, (Object)hll.getEncoding());
        hll.merge(hll2);
        Assert.assertEquals((double)(2.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.SPARSE, (Object)hll.getEncoding());
        hll.merge(hll3);
        Assert.assertEquals((double)(3.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.SPARSE, (Object)hll.getEncoding());
        hll.merge(hll4);
        Assert.assertEquals((double)(4.0 * (double)size), (double)hll.count(), (double)delta4);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.DENSE, (Object)hll.getEncoding());
        hll.merge(hll5);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHLLSparseDenseMerge() {
        HyperLogLog hll = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        HyperLogLog hll2 = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        HyperLogLog hll3 = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.DENSE).build();
        HyperLogLog hll4 = HyperLogLog.builder().setNumRegisterIndexBits(16).setEncoding(HyperLogLog.EncodingType.DENSE).build();
        HyperLogLog hll5 = HyperLogLog.builder().setNumRegisterIndexBits(12).setEncoding(HyperLogLog.EncodingType.DENSE).build();
        int size = 1000;
        for (int i = 0; i < size; ++i) {
            hll.addLong((long)i);
            hll2.addLong((long)(size + i));
            hll3.addLong((long)(2 * size + i));
            hll4.addLong((long)(3 * size + i));
        }
        double threshold = size > 40000 ? (double)this.longRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)size / 100.0;
        Assert.assertEquals((double)size, (double)hll.count(), (double)delta);
        Assert.assertEquals((double)size, (double)hll2.count(), (double)delta);
        hll.merge(hll2);
        Assert.assertEquals((double)(2.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.SPARSE, (Object)hll.getEncoding());
        hll.merge(hll2);
        Assert.assertEquals((double)(2.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.SPARSE, (Object)hll.getEncoding());
        hll.merge(hll3);
        Assert.assertEquals((double)(3.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.DENSE, (Object)hll.getEncoding());
        hll2.merge(hll4);
        Assert.assertEquals((double)(2.0 * (double)size), (double)hll2.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.DENSE, (Object)hll2.getEncoding());
        hll.merge(hll5);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHLLDenseSparseMerge() {
        HyperLogLog hll = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.DENSE).build();
        HyperLogLog hll2 = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.DENSE).build();
        HyperLogLog hll3 = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        HyperLogLog hll4 = HyperLogLog.builder().setNumRegisterIndexBits(16).setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        HyperLogLog hll5 = HyperLogLog.builder().setNumRegisterIndexBits(12).setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        int size = 1000;
        for (int i = 0; i < size; ++i) {
            hll.addLong((long)i);
            hll2.addLong((long)(size + i));
            hll3.addLong((long)(2 * size + i));
            hll4.addLong((long)(3 * size + i));
        }
        double threshold = size > 40000 ? (double)this.longRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)size / 100.0;
        Assert.assertEquals((double)size, (double)hll.count(), (double)delta);
        Assert.assertEquals((double)size, (double)hll2.count(), (double)delta);
        hll.merge(hll2);
        Assert.assertEquals((double)(2.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.DENSE, (Object)hll.getEncoding());
        hll.merge(hll2);
        Assert.assertEquals((double)(2.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.DENSE, (Object)hll.getEncoding());
        hll.merge(hll3);
        Assert.assertEquals((double)(3.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.DENSE, (Object)hll.getEncoding());
        hll3.merge(hll4);
        Assert.assertEquals((double)(2.0 * (double)size), (double)hll3.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.DENSE, (Object)hll3.getEncoding());
        hll.merge(hll5);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHLLSparseOverflowMerge() {
        HyperLogLog hll = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        HyperLogLog hll2 = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        HyperLogLog hll3 = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        HyperLogLog hll4 = HyperLogLog.builder().setNumRegisterIndexBits(16).setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        HyperLogLog hll5 = HyperLogLog.builder().setNumRegisterIndexBits(12).setEncoding(HyperLogLog.EncodingType.SPARSE).build();
        int size = 1000;
        for (int i = 0; i < size; ++i) {
            hll.addLong((long)i);
            hll2.addLong((long)(size + i));
            hll3.addLong((long)(2 * size + i));
            hll4.addLong((long)(3 * size + i));
        }
        double threshold = size > 40000 ? (double)this.longRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)size / 100.0;
        Assert.assertEquals((double)size, (double)hll.count(), (double)delta);
        Assert.assertEquals((double)size, (double)hll2.count(), (double)delta);
        hll.merge(hll2);
        Assert.assertEquals((double)(2.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.SPARSE, (Object)hll.getEncoding());
        hll.merge(hll2);
        Assert.assertEquals((double)(2.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.SPARSE, (Object)hll.getEncoding());
        hll.merge(hll3);
        Assert.assertEquals((double)(3.0 * (double)size), (double)hll.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.DENSE, (Object)hll.getEncoding());
        hll2.merge(hll4);
        Assert.assertEquals((double)(2.0 * (double)size), (double)hll2.count(), (double)delta);
        Assert.assertEquals((Object)HyperLogLog.EncodingType.DENSE, (Object)hll2.getEncoding());
        hll.merge(hll5);
    }

    @Test
    public void testHLLSparseMoreRegisterBits() {
        HyperLogLog hll = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).setNumRegisterIndexBits(16).build();
        int size = 1000;
        for (int i = 0; i < size; ++i) {
            hll.addLong((long)i);
        }
        double threshold = size > 40000 ? (double)this.longRangeTolerance : (double)this.shortRangeTolerance;
        double delta = threshold * (double)size / 100.0;
        Assert.assertEquals((double)size, (double)hll.count(), (double)delta);
    }

    @Test
    public void testHLLSquash() {
        int[] sizes = new int[]{500, 1000, 2300, 4096};
        int minBits = 9;
        for (int size : sizes) {
            int k;
            HyperLogLog[] hlls = new HyperLogLog[16];
            for (k = minBits; k < hlls.length; ++k) {
                HyperLogLog hll = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.DENSE).setNumRegisterIndexBits(k).build();
                for (int i = 0; i < size; ++i) {
                    hll.addLong((long)i);
                }
                hlls[k] = hll;
            }
            for (k = minBits; k < hlls.length; ++k) {
                for (int j = k + 1; j < hlls.length; ++j) {
                    HyperLogLog large = hlls[j];
                    HyperLogLog small = hlls[k];
                    HyperLogLog mush = large.squash(small.getNumRegisterIndexBits());
                    Assert.assertEquals((float)small.count(), (float)mush.count(), (float)0.0f);
                    double delta = Math.ceil(small.getStandardError() * (double)size);
                    Assert.assertEquals((double)size, (double)mush.count(), (double)delta);
                }
            }
        }
    }

    @Test
    public void testHLLDenseDenseSquash() {
        int i;
        HyperLogLog p14HLL = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.DENSE).setNumRegisterIndexBits(14).build();
        HyperLogLog p10HLL = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.DENSE).setNumRegisterIndexBits(10).build();
        int size = 1000000;
        for (i = 0; i < size; ++i) {
            p14HLL.addLong((long)i);
        }
        for (i = 0; i < 10000; ++i) {
            p10HLL.addLong((long)i);
        }
        p14HLL.squash(p10HLL.getNumRegisterIndexBits());
        Assert.assertEquals((double)size, (double)p14HLL.count(), (double)((double)(this.longRangeTolerance * (float)size) / 100.0));
    }

    @Test
    public void testHLLSparseDenseSquash() {
        int i;
        HyperLogLog p14HLL = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.SPARSE).setNumRegisterIndexBits(14).build();
        HyperLogLog p10HLL = HyperLogLog.builder().setEncoding(HyperLogLog.EncodingType.DENSE).setNumRegisterIndexBits(10).build();
        int size = 2000;
        for (i = 0; i < size; ++i) {
            p14HLL.addLong((long)i);
        }
        for (i = 0; i < 10000; ++i) {
            p10HLL.addLong((long)i);
        }
        p14HLL.squash(p10HLL.getNumRegisterIndexBits());
        Assert.assertEquals((double)size, (double)p14HLL.count(), (double)((double)(this.longRangeTolerance * (float)size) / 100.0));
    }

    @Test
    public void testAbletoRetainAccuracyUpToSwitchThreshold70() {
        this.testRetainAccuracy(70);
    }

    @Test
    public void testAbletoRetainAccuracyUpToSwitchThresholdMaxPer2() {
        int maxThreshold = HyperLogLog.builder().setSizeOptimized().build().getEncodingSwitchThreshold();
        this.testRetainAccuracy(maxThreshold / 2);
    }

    @Test
    public void testAbletoRetainAccuracyUpToSwitchThresholdMax() {
        int maxThreshold = HyperLogLog.builder().setSizeOptimized().build().getEncodingSwitchThreshold();
        this.testRetainAccuracy(maxThreshold);
    }

    private void testRetainAccuracy(int numElements) {
        HyperLogLog h = HyperLogLog.builder().setSizeOptimized().build();
        Assert.assertTrue((numElements <= h.getEncodingSwitchThreshold() ? 1 : 0) != 0);
        for (int ia = 0; ia <= 10; ++ia) {
            for (int i = 1; i <= numElements; ++i) {
                h.addLong((long)i);
            }
        }
        Assert.assertEquals((long)numElements, (long)h.estimateNumDistinctValues());
    }
}

