/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.hadoop.hive.metastore.properties.PropertyMap;
import org.apache.hadoop.hive.metastore.properties.PropertySchema;
import org.apache.hadoop.hive.metastore.properties.PropertyStore;

public class TransientPropertyStore
extends PropertyStore {
    private final Map<String, byte[]> properties = new TreeMap<String, byte[]>();
    private final Map<String, UUID> digests = new TreeMap<String, UUID>();

    public synchronized PropertyMap fetchProperties(String mapKey, Function<String, PropertySchema> getSchema) {
        byte[] bytes = this.properties.get(mapKey);
        if (bytes != null) {
            PropertyMap map = this.deserialize(bytes, getSchema);
            if (map.isDirty()) {
                this.saveProperties(mapKey, map);
            }
            return map;
        }
        return null;
    }

    public synchronized Map<String, PropertyMap> selectProperties(String keyPrefix, Predicate<String> keyFilter, Function<String, PropertySchema> getSchema) {
        TreeMap result = new TreeMap();
        this.properties.forEach((key, bytes) -> {
            if ((keyPrefix == null || key.startsWith(keyPrefix)) && (keyFilter == null || keyFilter.test((String)key)) && bytes != null) {
                PropertyMap map = this.deserialize((byte[])bytes, getSchema);
                if (map.isDirty()) {
                    this.saveProperties((String)key, map);
                }
                result.put(key, map);
            }
        });
        return result.isEmpty() ? Collections.emptyMap() : result;
    }

    public synchronized UUID fetchDigest(String mapKey) {
        return this.digests.get(mapKey.toString());
    }

    public synchronized Map<String, UUID> selectDigest(String keyPrefix, Predicate<String> keyFilter) {
        TreeMap result = new TreeMap();
        this.digests.forEach((name, uuid) -> {
            if (name.startsWith(keyPrefix) && (keyFilter == null || keyFilter.test((String)name))) {
                result.put(name, uuid);
            }
        });
        return result.isEmpty() ? Collections.emptyMap() : result;
    }

    public synchronized void saveProperties(String mapKey, PropertyMap map) {
        UUID digest = map.getDigest();
        byte[] data = this.serialize(map);
        this.digests.put(mapKey, digest);
        this.properties.put(mapKey, data);
        map.setClean();
    }

    public synchronized boolean dropProperties(String mapKey) {
        boolean m = this.properties.remove(mapKey) != null;
        boolean d = this.digests.remove(mapKey) != null;
        return m & d;
    }

    public synchronized boolean renameProperties(String mapKey, String newKey) {
        byte[] map;
        if (!this.properties.containsKey(newKey) && (map = this.properties.remove(mapKey)) != null) {
            this.properties.put(newKey, map);
            UUID digest = this.digests.remove(mapKey);
            if (digest != null) {
                this.digests.put(newKey, digest);
            }
            return true;
        }
        return false;
    }
}

