/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.hive.metastore.properties.SoftCache;
import org.junit.Assert;
import org.junit.Test;

public class SoftCacheTest {
    @Test
    public void testCache0() {
        SoftCache cache = new SoftCache();
        Assert.assertTrue((cache.capacity() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)cache.size());
        this.runCacheTest((SoftCache<Long, String>)cache);
    }

    @Test
    public void testCache1() {
        SoftCache cache = new SoftCache(32);
        Assert.assertEquals((long)32L, (long)cache.capacity());
        Assert.assertEquals((long)0L, (long)cache.size());
        this.runCacheTest((SoftCache<Long, String>)cache);
    }

    @Test
    public void testCacheSync2() {
        SoftCache cache = new SoftCache(32, 0.75f, true);
        Assert.assertEquals((long)32L, (long)cache.capacity());
        Assert.assertEquals((long)0L, (long)cache.size());
        this.runCacheTest((SoftCache<Long, String>)cache);
    }

    private void runCacheTest(SoftCache<Long, String> cache) {
        Object p;
        long i;
        int cpy = cache.capacity();
        for (i = 0L; i < (long)cpy; ++i) {
            p = (String)cache.put((Object)i, (Object)Long.toHexString(i));
            Assert.assertNull((Object)p);
        }
        Assert.assertEquals((long)cpy, (long)cache.size());
        for (i = 0L; i < (long)cpy; ++i) {
            p = (String)cache.get((Object)i);
            Assert.assertEquals((Object)Long.toHexString(i), (Object)p);
        }
        for (i = 0L; i < (long)cpy; ++i) {
            p = (String)cache.put((Object)i, (Object)("---" + Long.toHexString(i)));
            Assert.assertEquals((Object)Long.toHexString(i), (Object)p);
        }
        for (i = 0L; i < (long)cpy; ++i) {
            p = (String)cache.put((Object)(100L + i), (Object)("***" + Long.toHexString(100L + i)));
            Assert.assertNull((Object)p);
        }
        Assert.assertEquals((long)cpy, (long)cache.size());
        for (i = 0L; i < (long)cpy; ++i) {
            p = (String)cache.get((Object)(100L + i));
            Assert.assertEquals((Object)("***" + Long.toHexString(100L + i)), (Object)p);
        }
        for (i = 0L; i < (long)cpy; ++i) {
            p = (String)cache.remove((Object)(100L + i));
            Assert.assertEquals((Object)("***" + Long.toHexString(100L + i)), (Object)p);
        }
        Assert.assertEquals((long)0L, (long)cache.size());
        for (i = 0L; i < 4L; ++i) {
            p = (String)cache.put((Object)i, (Object)Long.toHexString(i));
            Assert.assertNull((Object)p);
        }
        TreeSet values = new TreeSet(cache.values());
        Assert.assertEquals((long)4L, (long)values.size());
        for (long i2 = 0L; i2 < 4L; ++i2) {
            Assert.assertTrue((boolean)values.contains(Long.toHexString(i2)));
        }
        TreeMap<Long, String> entries = new TreeMap<Long, String>();
        for (Map.Entry e : cache.entrySet()) {
            entries.put((Long)e.getKey(), (String)e.getValue());
        }
        Assert.assertEquals((long)4L, (long)entries.size());
        for (long i3 = 0L; i3 < 4L; ++i3) {
            String p2 = (String)entries.get(i3);
            Assert.assertEquals((Object)Long.toHexString(i3), (Object)p2);
        }
        cache.clear();
        Assert.assertEquals((long)0L, (long)cache.size());
    }
}

