/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.hive.metastore.properties.PropertySchema;
import org.apache.hadoop.hive.metastore.properties.PropertyType;
import org.apache.hadoop.hive.metastore.properties.SerializationProxy;
import org.junit.Assert;
import org.junit.Test;

public class PropertySchemaTest {
    @Test
    public void testSchema0() throws IOException {
        PropertySchema schema = new PropertySchema("table");
        Assert.assertTrue((boolean)schema.declareProperty("id", PropertyType.INTEGER));
        Assert.assertTrue((boolean)schema.declareProperty("uuid", PropertyType.STRING));
        Assert.assertTrue((boolean)schema.declareProperty("creation_date", PropertyType.DATETIME));
        Assert.assertTrue((boolean)schema.declareProperty("policy", PropertyType.JSON));
        UUID uuidnofill = schema.getDigest();
        Assert.assertTrue((boolean)schema.declareProperty("fill_ratio", PropertyType.DOUBLE, (Object)0.75));
        try {
            schema.declareProperty("id", PropertyType.DOUBLE);
            Assert.fail((String)"should have failed, id is already declared with a different type");
        }
        catch (IllegalArgumentException xill) {
            Assert.assertTrue((boolean)xill.getMessage().contains("id"));
        }
        Assert.assertFalse((boolean)schema.declareProperty("id", PropertyType.INTEGER));
        byte[] b0 = SerializationProxy.toBytes((Serializable)schema, (Object[])new Object[0]);
        PropertySchema s1 = (PropertySchema)SerializationProxy.fromBytes((byte[])b0, (Object[])new Object[0]);
        Assert.assertTrue((schema != s1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)schema, (Object)s1);
        UUID uuid0 = schema.getDigest();
        Assert.assertTrue((boolean)schema.removeProperty("fill_ratio"));
        Assert.assertFalse((boolean)schema.removeProperty("fill_ratio"));
        UUID uuid1 = schema.getDigest();
        Assert.assertNotEquals((Object)uuid0, (Object)uuid1);
        Assert.assertEquals((Object)uuidnofill, (Object)uuid1);
    }
}

