/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import java.util.Map;
import java.util.Properties;
import java.util.function.BooleanSupplier;
import org.apache.hadoop.hive.metastore.properties.JavaTestManager;
import org.apache.hadoop.hive.metastore.properties.PropertyManager;
import org.apache.hadoop.hive.metastore.properties.PropertyStore;
import org.apache.hadoop.hive.metastore.properties.PropertyType;
import org.apache.hadoop.hive.metastore.properties.TransientPropertyStore;
import org.junit.Assert;
import org.junit.Test;

public class PropertyManagerTest {
    private final PropertyStore store;
    private final PropertyManager manager;

    public PropertyManagerTest() {
        JavaTestManager.declareDomainProperty("framework", PropertyType.STRING, "Spark");
        JavaTestManager.declarePackageProperty("store", PropertyType.STRING, "ORC");
        JavaTestManager.declareClazzProperty("id", PropertyType.INTEGER, null);
        JavaTestManager.declareClazzProperty("name", PropertyType.STRING, null);
        JavaTestManager.declareClazzProperty("uuid", PropertyType.STRING, null);
        JavaTestManager.declareClazzProperty("fillfactor", PropertyType.DOUBLE, 0.75);
        JavaTestManager.declareClazzProperty("creation date", PropertyType.DATETIME, "2023-01-06T12:16:00");
        JavaTestManager.declareClazzProperty("project", PropertyType.STRING, "Hive");
        this.store = new TransientPropertyStore();
        this.manager = new JavaTestManager(this.store);
        Properties jutilp = new Properties();
        jutilp.setProperty("domain.framework", "Tez");
        jutilp.setProperty("package.store", "Iceberg");
        this.manager.importDefaultValues(jutilp);
    }

    @Test
    public void testSerDerScript() {
        this.runSerDer(() -> (Boolean)this.manager.runScript("setProperty('framework', 'llap');setProperty('ser.store', 'Parquet');setProperty('ser.der.id', 42);setProperty('ser.der.name', 'serder');setProperty('ser.der.project', 'Metastore');true;"));
    }

    @Test
    public void testSelectDirty() {
        Object result = this.manager.runScript("setProperty('framework', 'llap');setProperty('ser.store', 'Parquet');setProperty('ser.der.id', 42);setProperty('ser.der.name', 'serder');setProperty('ser.der.project', 'Metastore');selectProperties('ser.der', ()->true);");
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)1L, (long)((Map)result).size());
        this.manager.commit();
    }

    @Test
    public void testSerDer() {
        this.runSerDer(() -> {
            this.manager.setProperty("framework", (Object)"llap");
            this.manager.setProperty("ser.store", (Object)"Parquet");
            this.manager.setProperty("ser.der.id", (Object)42);
            this.manager.setProperty("ser.der.name", (Object)"serder");
            this.manager.setProperty("ser.der.project", (Object)"Metastore");
            return true;
        });
    }

    private void runSerDer(BooleanSupplier update) {
        JavaTestManager hms2 = new JavaTestManager(this.store);
        Assert.assertTrue((boolean)update.getAsBoolean());
        Assert.assertEquals((Object)"llap", (Object)this.manager.getPropertyValue("framework"));
        Assert.assertEquals((Object)"Parquet", (Object)this.manager.getPropertyValue("ser.store"));
        Assert.assertEquals((Object)42, (Object)this.manager.getPropertyValue("ser.der.id"));
        Assert.assertEquals((Object)"serder", (Object)this.manager.getPropertyValue("ser.der.name"));
        Assert.assertEquals((Object)"Metastore", (Object)this.manager.getPropertyValue("ser.der.project"));
        Assert.assertEquals((Object)"Tez", (Object)hms2.getPropertyValue("framework"));
        Assert.assertEquals((Object)"Iceberg", (Object)hms2.getPropertyValue("ser.store"));
        Assert.assertNull((Object)hms2.getPropertyValue("ser.der.id"));
        Assert.assertEquals(null, (Object)hms2.getPropertyValue("ser.der.name"));
        Assert.assertEquals((Object)"Hive", (Object)hms2.getPropertyValue("ser.der.project"));
        this.manager.commit();
        Assert.assertEquals((Object)42, (Object)this.manager.getPropertyValue("ser.der.id"));
        Assert.assertEquals((Object)"serder", (Object)this.manager.getPropertyValue("ser.der.name"));
        Assert.assertEquals((Object)"Metastore", (Object)this.manager.getPropertyValue("ser.der.project"));
        Assert.assertEquals((Object)"llap", (Object)this.manager.getPropertyValue("framework"));
        Assert.assertEquals((Object)"Parquet", (Object)this.manager.getPropertyValue("ser.store"));
        Assert.assertEquals((Object)42, (Object)hms2.getPropertyValue("ser.der.id"));
        Assert.assertEquals((Object)"serder", (Object)hms2.getPropertyValue("ser.der.name"));
        Assert.assertEquals((Object)"Metastore", (Object)hms2.getPropertyValue("ser.der.project"));
        Assert.assertEquals((Object)"llap", (Object)hms2.getPropertyValue("framework"));
        Assert.assertEquals((Object)"Parquet", (Object)hms2.getPropertyValue("ser.store"));
    }
}

