/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.UUID;
import org.apache.hadoop.hive.metastore.properties.Digester;
import org.junit.Assert;
import org.junit.Test;

public class DigesterTest {
    private final String UUID_OID = "6ba7b812-9dad-11d1-80b4-00c04fd430c8";
    private final UUID UUID_IN = UUID.fromString("6ba7b812-9dad-11d1-80b4-00c04fd430c8");

    @Test
    public void testStability() {
        boolean b = true;
        char c = 'a';
        int i4 = 10;
        double f8 = 10.0;
        String str = "some string";
        Digester d = new Digester(this.UUID_IN);
        d.digest(b).digest(c).digest(i4).digest(f8).digest(str);
        UUID uuid0 = d.getUUID();
        String stru0 = uuid0.toString();
        Assert.assertNotNull((Object)stru0);
        String stru1 = "295613e2-4b93-5c6f-94df-18ebb2634c08";
        Assert.assertEquals((Object)stru1, (Object)stru0);
        Assert.assertEquals((Object)UUID.fromString(stru1), (Object)uuid0);
    }

    @Test
    public void testSpread() {
        Digester d = new Digester();
        boolean b = true;
        char c = 'a';
        int i4 = 10;
        double f8 = 10.0;
        Date date = new Date();
        String str = "some string";
        d.digest(b).digest(c).digest(i4);
        d.digest(f8).digest(date).digest(str);
        UUID uuid0 = d.getUUID();
        String stru0 = uuid0.toString();
        Assert.assertNotNull((Object)stru0);
        d.digest(b).digest(i4).digest(c);
        d.digest(f8).digest(date).digest(str);
        UUID uuid1 = d.getUUID();
        String stru1 = uuid1.toString();
        Assert.assertNotNull((Object)stru1);
        Assert.assertNotEquals((Object)stru0, (Object)stru1);
    }

    @Test
    public void testDigestList() {
        ArrayList<Integer> li0 = new ArrayList<Integer>();
        li0.add(42);
        Digester d = new Digester();
        d.digest(li0);
        Digester d2 = d.copy();
        UUID uuid0 = d.getUUID();
        String stru0 = uuid0.toString();
        Assert.assertNotNull((Object)stru0);
        Assert.assertEquals((Object)uuid0, (Object)d2.getUUID());
        li0.add(24);
        d.digest(li0);
        UUID uuid1 = d.getUUID();
        String stru1 = uuid1.toString();
        Assert.assertNotNull((Object)stru1);
        Assert.assertNotEquals((Object)stru0, (Object)stru1);
        ArrayList<Integer> li1 = new ArrayList<Integer>();
        li1.add(42);
        li1.add(24);
        d.digest(li1);
        uuid0 = d.getUUID();
        stru0 = uuid0.toString();
        Assert.assertEquals((Object)stru0, (Object)stru1);
    }

    @Test
    public void testObjects() {
        UUID base = null;
        Digester dd = new Digester();
        HashSet<Integer> s42 = new HashSet<Integer>();
        s42.add(42);
        Object[] args = new Object[]{true, Character.valueOf('1'), (short)2, 3, Float.valueOf(4.0f), 5.0, 6L, "seven", new Date(), s42};
        for (int i = 0; i < 5; ++i) {
            args[3] = 3 + i;
            UUID u0 = dd.digest((Object)args).getUUID();
            if (base != null) {
                Assert.assertNotEquals((Object)base, (Object)u0);
            }
            base = u0;
        }
    }

    @Test
    public void testStream() {
        UUID nsTest = UUID.nameUUIDFromBytes("testStream".getBytes());
        String str0 = "Life, the Universe and Everything";
        ByteArrayInputStream in = new ByteArrayInputStream(str0.getBytes());
        Digester dd = new Digester(nsTest);
        UUID u42 = dd.digest((InputStream)in).getUUID();
        String str1 = "May the Force be with you";
        in = new ByteArrayInputStream(str1.getBytes());
        UUID u0405 = dd.digest((InputStream)in).getUUID();
        Assert.assertNotEquals((Object)u42, (Object)u0405);
        Assert.assertEquals((Object)u0405, (Object)dd.digest(str1.getBytes()).getUUID());
        Assert.assertEquals((Object)u42, (Object)dd.digest(str0.getBytes()).getUUID());
        Digester dd1 = new Digester(nsTest);
        Assert.assertEquals((Object)u0405, (Object)dd1.digest(str1.getBytes()).getUUID());
        Assert.assertEquals((Object)u42, (Object)dd1.digest(str0.getBytes()).getUUID());
        dd1 = new Digester();
        Assert.assertNotEquals((Object)u0405, (Object)dd1.digest(str1.getBytes()).getUUID());
        Assert.assertNotEquals((Object)u42, (Object)dd1.digest(str0.getBytes()).getUUID());
    }

    @Test
    public void testObjects2() {
        UUID base = null;
        HashSet<Integer> s42 = new HashSet<Integer>();
        s42.add(42);
        Digester dd = new Digester();
        UUID u0 = null;
        for (int i = 0; i < 5; ++i) {
            u0 = dd.digest(true).digest('1').digest(2).digest(3 + i).digest(4.0).digest(5.0).digest(6L).digest("seven").digest(new Date()).digest(s42).digest(u0).getUUID();
            if (base != null) {
                Assert.assertNotEquals((Object)base, (Object)u0);
            }
            base = u0;
        }
    }
}

