/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.metrics.metrics2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.metrics.MetricsTestUtils;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.metrics2.CodahaleMetrics;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore(value="HIVE-23945")
public class TestCodahaleReportersConf {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCodahaleReportersConf.class);
    private static File workDir = new File(System.getProperty("test.tmp.dir"));
    private static File jsonReportFile;

    @After
    public void after() throws Exception {
        MetricsFactory.close();
    }

    @Test
    public void testFallbackToDeprecatedConfig() throws Exception {
        Configuration conf = new Configuration();
        jsonReportFile = new File(workDir, "json_reporting");
        jsonReportFile.delete();
        conf.set("fs.defaultFS", "local");
        conf.set(MetastoreConf.ConfVars.METRICS_CLASS.getHiveName(), CodahaleMetrics.class.getCanonicalName());
        conf.set(MetastoreConf.ConfVars.HIVE_METRICS_REPORTER.getHiveName(), "JMX, JSON");
        conf.set(MetastoreConf.ConfVars.METRICS_JSON_FILE_LOCATION.getHiveName(), jsonReportFile.toString());
        conf.setTimeDuration(MetastoreConf.ConfVars.METRICS_JSON_FILE_INTERVAL.getHiveName(), 100L, TimeUnit.MILLISECONDS);
        MetricsFactory.init((Configuration)conf);
        int runs = 5;
        for (int i = 0; i < runs; ++i) {
            MetricsFactory.getInstance().incrementCounter("count2");
        }
        byte[] jsonData = MetricsTestUtils.getFileData(jsonReportFile.getAbsolutePath(), 2000, 3);
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode rootNode = objectMapper.readTree(jsonData);
        JsonNode countersNode = rootNode.path("counters");
        JsonNode methodCounterNode = countersNode.path("count2");
        JsonNode countNode = methodCounterNode.path("count");
        Assert.assertEquals((long)countNode.asInt(), (long)5L);
    }

    @Test
    public void testNoFallback() throws Exception {
        Configuration conf = new Configuration();
        jsonReportFile = new File(workDir, "json_reporting");
        jsonReportFile.delete();
        conf.set("fs.defaultFS", "local");
        conf.set(MetastoreConf.ConfVars.METRICS_CLASS.getHiveName(), CodahaleMetrics.class.getCanonicalName());
        conf.set(MetastoreConf.ConfVars.HIVE_METRICS_REPORTER.getHiveName(), "JMX, JSON");
        conf.set(MetastoreConf.ConfVars.HIVE_CODAHALE_METRICS_REPORTER_CLASSES.getHiveName(), "org.apache.hadoop.hive.common.metrics.metrics2.JmxMetricsReporter");
        conf.set(MetastoreConf.ConfVars.METRICS_JSON_FILE_LOCATION.getHiveName(), jsonReportFile.toString());
        conf.setTimeDuration(MetastoreConf.ConfVars.METRICS_JSON_FILE_INTERVAL.getHiveName(), 100L, TimeUnit.MILLISECONDS);
        MetricsFactory.init((Configuration)conf);
        int runs = 5;
        for (int i = 0; i < runs; ++i) {
            MetricsFactory.getInstance().incrementCounter("count2");
        }
        Assert.assertFalse((boolean)jsonReportFile.exists());
    }

    @Test
    public void testNoFallbackOnIncorrectConf() throws Exception {
        Configuration conf = new Configuration();
        jsonReportFile = new File(workDir, "json_reporting");
        jsonReportFile.delete();
        conf.set("fs.defaultFS", "local");
        conf.set(MetastoreConf.ConfVars.METRICS_CLASS.getHiveName(), CodahaleMetrics.class.getCanonicalName());
        conf.set(MetastoreConf.ConfVars.HIVE_METRICS_REPORTER.getHiveName(), "JMX, JSON");
        conf.set(MetastoreConf.ConfVars.HIVE_CODAHALE_METRICS_REPORTER_CLASSES.getHiveName(), "org.apache.hadoop.hive.common.metrics.NonExistentReporter");
        conf.set(MetastoreConf.ConfVars.METRICS_JSON_FILE_LOCATION.getHiveName(), jsonReportFile.toString());
        conf.setTimeDuration(MetastoreConf.ConfVars.METRICS_JSON_FILE_INTERVAL.getHiveName(), 100L, TimeUnit.MILLISECONDS);
        try {
            MetricsFactory.init((Configuration)conf);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)jsonReportFile.exists());
    }

    @Test
    public void testMetricsFactoryInitMetrics2ReporterAddedTwice() throws Exception {
        Configuration conf = new Configuration();
        jsonReportFile = File.createTempFile("TestCodahaleMetrics", ".json");
        LOGGER.info("Json metrics saved in {}", (Object)jsonReportFile.getAbsolutePath());
        conf.set(MetastoreConf.ConfVars.METRICS_CLASS.getHiveName(), CodahaleMetrics.class.getCanonicalName());
        conf.set(MetastoreConf.ConfVars.HIVE_CODAHALE_METRICS_REPORTER_CLASSES.getHiveName(), "org.apache.hadoop.hive.common.metrics.metrics2.Metrics2Reporter, org.apache.hadoop.hive.common.metrics.metrics2.Metrics2Reporter");
        conf.set(MetastoreConf.ConfVars.METRICS_JSON_FILE_LOCATION.getHiveName(), jsonReportFile.getAbsolutePath());
        conf.setTimeDuration(MetastoreConf.ConfVars.METRICS_JSON_FILE_INTERVAL.getHiveName(), 2000L, TimeUnit.MILLISECONDS);
        MetricsFactory.init((Configuration)conf);
        Assert.assertNotNull((Object)MetricsFactory.getInstance());
        MetricsFactory.close();
        MetricsFactory.init((Configuration)conf);
        Assert.assertNotNull((Object)MetricsFactory.getInstance());
    }
}

