/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.metrics.metrics2;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.metrics.MetricsTestUtils;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.common.MetricsVariable;
import org.apache.hadoop.hive.common.metrics.metrics2.CodahaleMetrics;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TestCodahaleMetrics {
    private static final Path tmpDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    private static File jsonReportFile;
    private static MetricRegistry metricRegistry;
    private static final long REPORT_INTERVAL_MS = 2000L;

    @BeforeClass
    public static void setUp() throws Exception {
        if (!tmpDir.toFile().exists()) {
            System.out.println("Creating directory " + tmpDir);
            Files.createDirectories(tmpDir, PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxr-xr-x")));
        }
        Configuration conf = new Configuration();
        jsonReportFile = File.createTempFile("TestCodahaleMetrics", ".json");
        System.out.println("Json metrics saved in " + jsonReportFile.getAbsolutePath());
        conf.set(MetastoreConf.ConfVars.METRICS_CLASS.getHiveName(), CodahaleMetrics.class.getCanonicalName());
        conf.set(MetastoreConf.ConfVars.HIVE_CODAHALE_METRICS_REPORTER_CLASSES.getHiveName(), "org.apache.hadoop.hive.common.metrics.metrics2.JsonFileMetricsReporter, org.apache.hadoop.hive.common.metrics.metrics2.JmxMetricsReporter");
        conf.set(MetastoreConf.ConfVars.METRICS_JSON_FILE_LOCATION.getHiveName(), jsonReportFile.getAbsolutePath());
        conf.setTimeDuration(MetastoreConf.ConfVars.METRICS_JSON_FILE_INTERVAL.getHiveName(), 2000L, TimeUnit.MILLISECONDS);
        MetricsFactory.init((Configuration)conf);
        metricRegistry = ((CodahaleMetrics)MetricsFactory.getInstance()).getMetricRegistry();
    }

    @AfterClass
    public static void cleanup() {
        try {
            MetricsFactory.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        jsonReportFile.delete();
    }

    @Test
    public void testScope() throws Exception {
        int runs = 5;
        for (int i = 0; i < runs; ++i) {
            MetricsFactory.getInstance().startStoredScope("method1");
            MetricsFactory.getInstance().endStoredScope("method1");
            Timer timer = (Timer)metricRegistry.getTimers().get("method1");
            Assert.assertEquals((long)(i + 1), (long)timer.getCount());
        }
        Timer timer = (Timer)metricRegistry.getTimers().get("method1");
        Assert.assertTrue((timer.getMeanRate() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testCount() throws Exception {
        int runs = 5;
        for (int i = 0; i < runs; ++i) {
            MetricsFactory.getInstance().incrementCounter("count1");
            Counter counter = (Counter)metricRegistry.getCounters().get("count1");
            Assert.assertEquals((long)(i + 1), (long)counter.getCount());
        }
    }

    @Test
    public void testConcurrency() throws Exception {
        int threads = 4;
        ExecutorService executorService = Executors.newFixedThreadPool(threads);
        int i = 0;
        while (i < threads) {
            int n = i++;
            executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    MetricsFactory.getInstance().startStoredScope("method2");
                    MetricsFactory.getInstance().endStoredScope("method2");
                    return null;
                }
            });
        }
        executorService.shutdown();
        Assert.assertTrue((boolean)executorService.awaitTermination(10000L, TimeUnit.MILLISECONDS));
        Timer timer = (Timer)metricRegistry.getTimers().get("method2");
        Assert.assertEquals((long)4L, (long)timer.getCount());
        Assert.assertTrue((timer.getMeanRate() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    @Ignore(value="flaky test HIVE-23692")
    public void testFileReporting() throws Exception {
        int runs = 5;
        String counterName = "count2";
        MetricsFactory.getInstance().incrementCounter(counterName);
        Thread.sleep(10000L);
        for (int i = 1; i <= runs; ++i) {
            MetricsFactory.getInstance().incrementCounter(counterName);
            Thread.sleep(3000L);
            Assert.assertEquals((long)(i + 1), (long)this.getCounterValue(counterName));
        }
    }

    @Test
    public void testGauge() throws Exception {
        TestMetricsVariable testVar = new TestMetricsVariable();
        testVar.setValue(20);
        MetricsFactory.getInstance().addGauge("gauge1", (MetricsVariable)testVar);
        String json = ((CodahaleMetrics)MetricsFactory.getInstance()).dumpJson();
        MetricsTestUtils.verifyMetricsJson(json, MetricsTestUtils.GAUGE, "gauge1", testVar.getValue());
        testVar.setValue(40);
        json = ((CodahaleMetrics)MetricsFactory.getInstance()).dumpJson();
        MetricsTestUtils.verifyMetricsJson(json, MetricsTestUtils.GAUGE, "gauge1", testVar.getValue());
    }

    @Test
    public void testMeter() throws Exception {
        String json = ((CodahaleMetrics)MetricsFactory.getInstance()).dumpJson();
        MetricsTestUtils.verifyMetricsJson(json, MetricsTestUtils.METER, "meter", "");
        MetricsFactory.getInstance().markMeter("meter");
        json = ((CodahaleMetrics)MetricsFactory.getInstance()).dumpJson();
        MetricsTestUtils.verifyMetricsJson(json, MetricsTestUtils.METER, "meter", "1");
        MetricsFactory.getInstance().markMeter("meter");
        json = ((CodahaleMetrics)MetricsFactory.getInstance()).dumpJson();
        MetricsTestUtils.verifyMetricsJson(json, MetricsTestUtils.METER, "meter", "2");
    }

    private int getCounterValue(String name) throws FileNotFoundException {
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse((Reader)new FileReader(jsonReportFile.getAbsolutePath()));
        JsonObject jobj = element.getAsJsonObject();
        jobj = jobj.getAsJsonObject("counters").getAsJsonObject(name);
        return jobj.get("count").getAsInt();
    }

    class TestMetricsVariable
    implements MetricsVariable {
        private int gaugeVal;

        TestMetricsVariable() {
        }

        public Object getValue() {
            return this.gaugeVal;
        }

        public void setValue(int gaugeVal) {
            this.gaugeVal = gaugeVal;
        }
    }
}

