/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import org.apache.hadoop.hive.common.IPStackUtils;
import org.junit.Assert;
import org.junit.Test;

public class IPStackUtilsTest {
    @Test
    public void testIPv4LoopbackWhenIPv4StackIsForced() {
        IPStackUtils.setPreferIPv4Stack((boolean)true);
        IPStackUtils.setPreferIPv6Addresses((boolean)false);
        String loopback = IPStackUtils.resolveLoopbackAddress();
        Assert.assertEquals((Object)"127.0.0.1", (Object)loopback);
    }

    @Test
    public void testIPv6LoopbackWhenIPv6IsPreferred() {
        IPStackUtils.setPreferIPv4Stack((boolean)false);
        IPStackUtils.setPreferIPv6Addresses((boolean)true);
        String loopback = IPStackUtils.resolveLoopbackAddress();
        Assert.assertEquals(IPStackUtils.LOOPBACK_ADDRESSES_IPV6.get(0), (Object)loopback);
    }

    @Test
    public void testIPv4LoopbackWhenIPv6IsNotPreferred() {
        IPStackUtils.setPreferIPv4Stack((boolean)false);
        IPStackUtils.setPreferIPv6Addresses((boolean)false);
        String loopback = IPStackUtils.resolveLoopbackAddress();
        Assert.assertEquals((Object)"127.0.0.1", (Object)loopback);
    }

    @Test
    public void testIPv4WildcardWhenIPv4StackIsForced() {
        IPStackUtils.setPreferIPv4Stack((boolean)true);
        IPStackUtils.setPreferIPv6Addresses((boolean)false);
        String wildcard = IPStackUtils.resolveWildcardAddress();
        Assert.assertEquals((Object)"0.0.0.0", (Object)wildcard);
    }

    @Test
    public void testIPv6WildcardWhenIPv6IsPreferred() {
        IPStackUtils.setPreferIPv4Stack((boolean)false);
        IPStackUtils.setPreferIPv6Addresses((boolean)true);
        String wildcard = IPStackUtils.resolveWildcardAddress();
        Assert.assertEquals(IPStackUtils.WILDCARD_ADDRESSES_IPV6.get(0), (Object)wildcard);
    }

    @Test
    public void testIPv4WildcardWhenIPv6IsNotPreferred() {
        IPStackUtils.setPreferIPv4Stack((boolean)false);
        IPStackUtils.setPreferIPv6Addresses((boolean)false);
        String wildcard = IPStackUtils.resolveWildcardAddress();
        Assert.assertEquals((Object)"0.0.0.0", (Object)wildcard);
    }

    @Test
    public void testConcatHostPort() {
        Assert.assertEquals((Object)"192.168.1.1:8080", (Object)IPStackUtils.concatHostPort((String)"192.168.1.1", (int)8080));
        Assert.assertEquals((Object)"[2001:db8::1]:8080", (Object)IPStackUtils.concatHostPort((String)"2001:db8::1", (int)8080));
        Assert.assertEquals((Object)"[::1]:9090", (Object)IPStackUtils.concatHostPort((String)"::1", (int)9090));
        Assert.assertEquals((Object)"example.com:443", (Object)IPStackUtils.concatHostPort((String)"example.com", (int)443));
    }

    @Test
    public void testWildcardWhenIPv4StackIsForcedAndIPv4WildcardProvided() {
        IPStackUtils.setPreferIPv4Stack((boolean)true);
        IPStackUtils.setPreferIPv6Addresses((boolean)false);
        String result = IPStackUtils.adaptWildcardAddress((String)"0.0.0.0");
        Assert.assertEquals((Object)"0.0.0.0", (Object)result);
    }

    @Test
    public void testWildcardWhenIPv4StackIsForcedAndIPv6WildcardProvided() {
        IPStackUtils.setPreferIPv4Stack((boolean)true);
        IPStackUtils.setPreferIPv6Addresses((boolean)false);
        String result = IPStackUtils.adaptWildcardAddress((String)((String)IPStackUtils.WILDCARD_ADDRESSES_IPV6.get(0)));
        Assert.assertEquals((Object)"0.0.0.0", (Object)result);
    }

    @Test
    public void testWildcardWhenIPv6IsPreferredAndIPv6WildcardProvided() {
        IPStackUtils.setPreferIPv4Stack((boolean)false);
        IPStackUtils.setPreferIPv6Addresses((boolean)true);
        String result = IPStackUtils.adaptWildcardAddress((String)((String)IPStackUtils.WILDCARD_ADDRESSES_IPV6.get(0)));
        Assert.assertEquals(IPStackUtils.WILDCARD_ADDRESSES_IPV6.get(0), (Object)result);
    }

    @Test
    public void testWildcardWhenIPv6IsPreferredAndIPv4WildcardProvided() {
        IPStackUtils.setPreferIPv4Stack((boolean)false);
        IPStackUtils.setPreferIPv6Addresses((boolean)true);
        String result = IPStackUtils.adaptWildcardAddress((String)"0.0.0.0");
        Assert.assertEquals(IPStackUtils.WILDCARD_ADDRESSES_IPV6.get(0), (Object)result);
    }

    @Test
    public void testWildcardWhenIPv6IsNotPreferredAndIPv4WildcardProvided() {
        IPStackUtils.setPreferIPv4Stack((boolean)false);
        IPStackUtils.setPreferIPv6Addresses((boolean)false);
        String result = IPStackUtils.adaptWildcardAddress((String)"0.0.0.0");
        Assert.assertEquals((Object)"0.0.0.0", (Object)result);
    }

    @Test
    public void testWildcardWhenIPv6IsNotPreferredAndIPv6WildcardProvided() {
        IPStackUtils.setPreferIPv4Stack((boolean)false);
        IPStackUtils.setPreferIPv6Addresses((boolean)false);
        String result = IPStackUtils.adaptWildcardAddress((String)((String)IPStackUtils.WILDCARD_ADDRESSES_IPV6.get(0)));
        Assert.assertEquals((Object)"0.0.0.0", (Object)result);
    }

    @Test
    public void testAdaptWildcardAddress() {
        Assert.assertEquals((Object)"192.168.1.1", (Object)IPStackUtils.adaptWildcardAddress((String)"192.168.1.1"));
        Assert.assertEquals((Object)"2001:db8::1", (Object)IPStackUtils.adaptWildcardAddress((String)"2001:db8::1"));
        Assert.assertEquals((Object)"example.com", (Object)IPStackUtils.adaptWildcardAddress((String)"example.com"));
    }

    @Test
    public void testGetHostAndPortWithIPv4() {
        IPStackUtils.HostPort result = IPStackUtils.getHostAndPort((String)"192.168.1.1:8080");
        Assert.assertEquals((Object)"192.168.1.1", (Object)result.getHostname());
        Assert.assertEquals((long)8080L, (long)result.getPort());
    }

    @Test
    public void testGetHostAndPortWithValidIPv6WithSquaredBrackets() {
        IPStackUtils.HostPort result = IPStackUtils.getHostAndPort((String)"[2001:0db8::1]:8080");
        Assert.assertEquals((Object)"2001:0db8::1", (Object)result.getHostname());
        Assert.assertEquals((long)8080L, (long)result.getPort());
    }

    @Test
    public void testGetHostAndPortWithValidIPv6WithoutSquaredBrackets() {
        IPStackUtils.HostPort result = IPStackUtils.getHostAndPort((String)"2001:0db8::1:8080");
        Assert.assertEquals((Object)"2001:0db8::1", (Object)result.getHostname());
        Assert.assertEquals((long)8080L, (long)result.getPort());
    }

    @Test
    public void testGetHostAndPortWithHostname() {
        IPStackUtils.HostPort result = IPStackUtils.getHostAndPort((String)"example.com:80");
        Assert.assertEquals((Object)"example.com", (Object)result.getHostname());
        Assert.assertEquals((long)80L, (long)result.getPort());
    }

    @Test
    public void testGetHostPortWithInvalidAndPort() {
        try {
            IPStackUtils.getHostAndPort((String)"192.168.1.1:70000");
            Assert.fail((String)"Expected IllegalArgumentException to be thrown");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Port number out of range (0-65535).", (Object)e.getMessage());
        }
        try {
            IPStackUtils.getHostAndPort((String)"192.168.1.1");
            Assert.fail((String)"Expected IllegalArgumentException to be thrown");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Input does not contain a port.", (Object)e.getMessage());
        }
        try {
            IPStackUtils.getHostAndPort((String)":8080");
            Assert.fail((String)"Expected IllegalArgumentException to be thrown");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Host address is null or empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetPort() {
        Assert.assertEquals((long)8080L, (long)IPStackUtils.getPort((String)"8080"));
        Assert.assertEquals((long)65535L, (long)IPStackUtils.getPort((String)"65535"));
        Assert.assertEquals((long)0L, (long)IPStackUtils.getPort((String)"0"));
    }

    @Test
    public void testGetPortWithInvalidPort() {
        try {
            IPStackUtils.getPort((String)"70000");
            Assert.fail((String)"Expected IllegalArgumentException to be thrown");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Port number out of range (0-65535).", (Object)e.getMessage());
        }
        try {
            IPStackUtils.getPort((String)"-1");
            Assert.fail((String)"Expected IllegalArgumentException to be thrown");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Port number out of range (0-65535).", (Object)e.getMessage());
        }
        try {
            IPStackUtils.getPort((String)"abc");
            Assert.fail((String)"Expected IllegalArgumentException to be thrown");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"For input string: \"abc\"", (Object)e.getMessage());
        }
    }
}

