/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.utils.TableFetcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTableFetcher {
    @Test
    public void testEmpty() {
        TableFetcher fetcher = new TableFetcher.Builder((IMetaStoreClient)Mockito.mock(IMetaStoreClient.class), null, null, null).build();
        Assert.assertEquals((Object)"", (Object)fetcher.tableFilter);
    }

    @Test
    public void testAsterisk() {
        TableFetcher fetcher = new TableFetcher.Builder((IMetaStoreClient)Mockito.mock(IMetaStoreClient.class), "hive", "*", "*").build();
        Assert.assertEquals((Object)"hive_filter_field_tableName__ like \".*\"", (Object)fetcher.tableFilter);
    }

    @Test
    public void testCustomCondition() {
        TableFetcher fetcher = new TableFetcher.Builder((IMetaStoreClient)Mockito.mock(IMetaStoreClient.class), "hive", "*", "*").tableCondition("hive_filter_field_params__table_param like \"some_value\" ").build();
        Assert.assertEquals((Object)"hive_filter_field_params__table_param like \"some_value\"  and hive_filter_field_tableName__ like \".*\"", (Object)fetcher.tableFilter);
    }
}

