/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import org.apache.hadoop.hive.metastore.utils.Retry;
import org.junit.Assert;
import org.junit.Test;

public class RetryTest {
    @Test
    public void testRetrySuccess() {
        Retry<Void> retriable = new Retry<Void>(NullPointerException.class){
            private int count;
            {
                this.count = 0;
            }

            public Void execute() {
                if (this.count < 1) {
                    ++this.count;
                    throw new NullPointerException();
                }
                return null;
            }
        };
        try {
            retriable.run();
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testRetryFailure() {
        Retry<Void> retriable = new Retry<Void>(NullPointerException.class){

            public Void execute() {
                throw new RuntimeException();
            }
        };
        try {
            retriable.run();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(RuntimeException.class, e.getClass());
        }
    }

    @Test
    public void testRetryFailureWithDelay() {
        Retry<Void> retriable = new Retry<Void>(NullPointerException.class){

            public Void execute() {
                throw new RuntimeException();
            }
        };
        try {
            retriable.runWithDelay();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(RuntimeException.class, e.getClass());
        }
    }

    @Test
    public void testRetrySuccessWithDelay() {
        Retry<Void> retriable = new Retry<Void>(NullPointerException.class){
            private long startTime;
            {
                this.startTime = System.currentTimeMillis();
            }

            public Void execute() {
                RetryTest.this.executeWithDelay(this.startTime);
                return null;
            }
        };
        try {
            retriable.runWithDelay();
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    private void executeWithDelay(long startTime) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - startTime < 40000L) {
            throw new NullPointerException();
        }
    }

    @Test
    public void testRetryFailureWithDelayMoreThanTimeout() {
        Retry<Void> retriable = new Retry<Void>(NullPointerException.class){

            public Void execute() {
                throw new NullPointerException();
            }
        };
        long startTime = System.currentTimeMillis();
        try {
            retriable.runWithDelay();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals(NullPointerException.class, e.getClass());
            Assert.assertTrue((System.currentTimeMillis() - startTime >= 180000L ? 1 : 0) != 0);
        }
    }
}

