/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.TreeMap;
import org.apache.hadoop.hive.metastore.properties.PropertyType;
import org.junit.Assert;
import org.junit.Test;

public class PropertyTypeTest {
    private static final double EPSILON = 1.0E-9;

    @Test
    public void testRegistered() {
        for (String str : Arrays.asList("boolean", "integer", "long", "double", "date", "string")) {
            PropertyType type = PropertyType.get((String)str);
            Assert.assertNotNull((String)str, (Object)type);
            Assert.assertEquals((Object)str, (Object)type.getName());
        }
        PropertyType type = PropertyType.get((String)"boolean");
        Assert.assertFalse((boolean)PropertyType.register((PropertyType)type));
        PropertyType<String> varchar = new PropertyType<String>("varchar"){

            public String cast(Object value) {
                return value == null ? null : value.toString();
            }

            public String parse(String str) {
                return str;
            }
        };
        Assert.assertTrue((boolean)PropertyType.register((PropertyType)varchar));
        type = PropertyType.get((String)"varchar");
        Assert.assertTrue((type == varchar ? 1 : 0) != 0);
        type = new PropertyType<Boolean>("boolean"){

            public Boolean cast(Object value) {
                return value instanceof Boolean ? (Boolean)value : (value != null ? this.parse(value.toString()) : null);
            }

            public Boolean parse(String str) {
                return Boolean.valueOf(str);
            }
        };
        try {
            PropertyType.register((PropertyType)type);
            Assert.fail((String)"type is already registered");
        }
        catch (IllegalArgumentException xill) {
            Assert.assertTrue((boolean)xill.getMessage().contains("boolean"));
        }
    }

    @Test
    public void testString() {
        Assert.assertNull((Object)PropertyType.STRING.cast(null));
        Assert.assertNull((Object)PropertyType.STRING.format(null));
        Assert.assertNull((Object)PropertyType.STRING.parse(null));
        Assert.assertEquals((Object)"42", (Object)PropertyType.STRING.cast((Object)"42"));
        Assert.assertEquals((Object)"42", (Object)PropertyType.STRING.cast((Object)42));
        Assert.assertEquals((Object)"42", (Object)PropertyType.STRING.format((Object)"42"));
        Assert.assertEquals((Object)"42", (Object)PropertyType.STRING.parse("42"));
    }

    @Test
    public void testInteger() {
        Assert.assertNull((Object)PropertyType.INTEGER.cast(null));
        Assert.assertNull((Object)PropertyType.INTEGER.format(null));
        Assert.assertNull((Object)PropertyType.INTEGER.parse(null));
        Assert.assertEquals((long)42L, (long)((Integer)PropertyType.INTEGER.cast((Object)"42")).intValue());
        Assert.assertEquals((long)42L, (long)((Integer)PropertyType.INTEGER.cast((Object)42)).intValue());
        Assert.assertNull((Object)PropertyType.INTEGER.cast((Object)"foobar"));
        Assert.assertEquals((Object)"42", (Object)PropertyType.INTEGER.format((Object)42));
        Assert.assertEquals((long)42L, (long)((Integer)PropertyType.INTEGER.parse("42")).intValue());
        Assert.assertNull((Object)PropertyType.INTEGER.parse("foobar"));
    }

    @Test
    public void testLong() {
        Assert.assertNull((Object)PropertyType.LONG.cast(null));
        Assert.assertNull((Object)PropertyType.LONG.format(null));
        Assert.assertNull((Object)PropertyType.LONG.parse(null));
        Assert.assertEquals((long)42L, (long)((Long)PropertyType.LONG.cast((Object)"42")));
        Assert.assertEquals((long)42L, (long)((Long)PropertyType.LONG.cast((Object)42)));
        Assert.assertNull((Object)PropertyType.LONG.cast((Object)"foobar"));
        Assert.assertEquals((Object)"42", (Object)PropertyType.LONG.format((Object)42L));
        Assert.assertEquals((long)42L, (long)((Long)PropertyType.LONG.parse("42")));
        Assert.assertNull((Object)PropertyType.LONG.parse("foobar"));
    }

    @Test
    public void testDouble() {
        Assert.assertNull((Object)PropertyType.DOUBLE.cast(null));
        Assert.assertNull((Object)PropertyType.DOUBLE.format(null));
        Assert.assertNull((Object)PropertyType.DOUBLE.parse(null));
        Assert.assertEquals((double)42.0, (double)((Double)PropertyType.DOUBLE.cast((Object)"42")), (double)1.0E-9);
        Assert.assertEquals((double)42.0, (double)((Double)PropertyType.DOUBLE.cast((Object)42)), (double)1.0E-9);
        Assert.assertNull((Object)PropertyType.DOUBLE.cast((Object)"foobar"));
        Assert.assertEquals((Object)"42.0", (Object)PropertyType.DOUBLE.format((Object)42.0));
        Assert.assertEquals((double)42.0, (double)((Double)PropertyType.DOUBLE.parse("42")), (double)1.0E-9);
        Assert.assertNull((Object)PropertyType.DOUBLE.parse("foobar"));
    }

    @Test
    public void testDatetime() {
        String dateStr = "2007-12-03T10:15:30.00Z";
        Date date = Date.from(Instant.parse(dateStr));
        Assert.assertNull((Object)PropertyType.DATETIME.cast(null));
        Assert.assertNull((Object)PropertyType.DATETIME.format(null));
        Assert.assertNull((Object)PropertyType.DATETIME.parse(null));
        Assert.assertEquals((Object)date, (Object)PropertyType.DATETIME.cast((Object)date));
        Assert.assertEquals((Object)date, (Object)PropertyType.DATETIME.cast((Object)dateStr));
        Assert.assertEquals((Object)date, (Object)PropertyType.DATETIME.cast((Object)date.getTime()));
        Assert.assertEquals((Object)dateStr, (Object)PropertyType.DATETIME.format((Object)date));
        Assert.assertEquals((Object)date, (Object)PropertyType.DATETIME.parse(dateStr));
        Assert.assertNull((Object)PropertyType.DATETIME.parse("foobar"));
    }

    @Test
    public void testJson() {
        Assert.assertNull((Object)PropertyType.JSON.cast(null));
        Assert.assertNull((Object)PropertyType.JSON.format(null));
        Assert.assertNull((Object)PropertyType.JSON.parse(null));
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put("i", 12.0);
        map.put("s", "foobar");
        Assert.assertEquals((Object)42.0, (Object)PropertyType.JSON.cast((Object)"42"));
        Assert.assertEquals((Object)42.0, (Object)PropertyType.JSON.parse("42"));
        String msrc = "{\"i\":12.0,\"s\":\"foobar\"}";
        Assert.assertEquals(map, (Object)PropertyType.JSON.parse(msrc));
        Assert.assertEquals((Object)msrc, (Object)PropertyType.JSON.format(map));
    }
}

