/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.hadoop.hive.metastore.properties.CachingPropertyStore;
import org.apache.hadoop.hive.metastore.properties.PropertyMap;
import org.apache.hadoop.hive.metastore.properties.PropertySchema;
import org.apache.hadoop.hive.metastore.properties.PropertyStore;
import org.apache.hadoop.hive.metastore.properties.PropertyType;
import org.apache.hadoop.hive.metastore.properties.SerializationProxy;
import org.apache.hadoop.hive.metastore.properties.TransientPropertyStore;
import org.junit.Assert;
import org.junit.Test;

public class PropertyMapTest {
    private final PropertyStore store;
    private final PropertySchema table = new PropertySchema("table");

    public PropertyMapTest() {
        this.table.declareProperty("id", PropertyType.INTEGER);
        this.table.declareProperty("name", PropertyType.STRING);
        this.table.declareProperty("uuid", PropertyType.STRING);
        this.table.declareProperty("project", PropertyType.STRING, (Object)"Hive");
        this.table.declareProperty("policy", PropertyType.JSON);
        this.store = new TransientPropertyStore();
    }

    private static PropertyMap fetchProperties(PropertyStore store, String name, Function<String, PropertySchema> getSchema) {
        PropertyMap map = store.fetchProperties(name, getSchema);
        return map != null ? map : new PropertyMap(getSchema.apply(name));
    }

    private static Map<String, PropertyMap> selectProperties(PropertyStore store, String mapPrefix, Predicate<String> nameFilter, Function<String, PropertySchema> getSchema) {
        return store.selectProperties(mapPrefix, nameFilter, getSchema);
    }

    private PropertySchema fetchSchema(String name) {
        return this.table;
    }

    @Test
    public void testBasics() {
        PropertyMap map = new PropertyMap(this.table);
        map.setClean();
        try {
            map.putProperty("nosuchproperty", (Object)32);
            Assert.fail((String)"schema does not describe nosuchproperty");
        }
        catch (IllegalArgumentException xill) {
            Assert.assertTrue((boolean)xill.getMessage().contains("nosuchproperty"));
        }
        Assert.assertFalse((boolean)map.isDirty());
        try {
            map.putProperty("id", (Object)"notavalidvalue");
            Assert.fail((String)"schema expects an int");
        }
        catch (IllegalArgumentException xill) {
            Assert.assertTrue((boolean)xill.getMessage().contains("notavalidvalue"));
        }
        Assert.assertFalse((boolean)map.isDirty());
        try {
            this.table.declareProperty(null, PropertyType.BOOLEAN);
            Assert.fail((String)"null name!");
        }
        catch (IllegalArgumentException xill) {
            Assert.assertTrue((boolean)xill.getMessage().contains("name"));
        }
        Assert.assertFalse((boolean)map.isDirty());
        try {
            this.table.declareProperty("whatever", null);
            Assert.fail((String)"null type!");
        }
        catch (IllegalArgumentException xill) {
            Assert.assertTrue((boolean)xill.getMessage().contains("type"));
        }
        Assert.assertFalse((boolean)map.isDirty());
    }

    @Test
    public void testMap0() {
        this.runMap0(this.store);
    }

    @Test
    public void testMap1() {
        CachingPropertyStore caching = new CachingPropertyStore(this.store);
        this.runMap0((PropertyStore)caching);
    }

    private void runMap0(PropertyStore store) {
        PropertyMap map = PropertyMapTest.fetchProperties(store, "p0", this::fetchSchema);
        Assert.assertEquals((Object)PropertyType.INTEGER, (Object)map.getTypeOf("id"));
        Assert.assertNull((Object)map.putProperty("id", (Object)42));
        Assert.assertEquals((Object)PropertyType.STRING, (Object)map.getTypeOf("name"));
        Assert.assertNull((Object)map.putProperty("name", (Object)"table0"));
        UUID digest0 = map.getDigest();
        Assert.assertNotNull((Object)digest0);
        Assert.assertEquals((Object)"table0", (Object)map.putProperty("name", (Object)"TABLE0"));
        UUID digest1 = map.getDigest();
        Assert.assertNotNull((Object)digest1);
        Assert.assertNotEquals((Object)digest0, (Object)digest1);
        Assert.assertEquals((Object)"TABLE0", (Object)map.putProperty("name", (Object)"table0"));
        UUID digest2 = map.getDigest();
        Assert.assertNotNull((Object)digest2);
        Assert.assertEquals((Object)digest0, (Object)digest2);
        Assert.assertTrue((boolean)map.isDirty());
        Assert.assertEquals((Object)"table0", (Object)map.getPropertyValue("name"));
        Assert.assertEquals((Object)"Hive", (Object)map.getPropertyValue("project"));
    }

    @Test
    public void testSelect0() throws IOException, ClassNotFoundException {
        this.runSelect0(this.store);
    }

    @Test
    public void testSelect1() throws IOException, ClassNotFoundException {
        CachingPropertyStore caching = new CachingPropertyStore(this.store);
        this.runSelect0((PropertyStore)caching);
    }

    private void runSelect0(PropertyStore store) {
        for (int i = 0; i < 16; ++i) {
            String name = "table" + Integer.toOctalString(i);
            PropertyMap map = PropertyMapTest.fetchProperties(store, name, this::fetchSchema);
            Assert.assertEquals((Object)PropertyType.INTEGER, (Object)map.getTypeOf("id"));
            Assert.assertNull((Object)map.putProperty("id", (Object)(42 + i)));
            Assert.assertEquals((Object)PropertyType.STRING, (Object)map.getTypeOf("name"));
            Assert.assertNull((Object)map.putProperty("name", (Object)("relation" + Integer.toOctalString(i))));
            store.saveProperties(name, map);
        }
        Map<String, PropertyMap> selected = PropertyMapTest.selectProperties(store, "table", null, this::fetchSchema);
        Assert.assertNotNull(selected);
    }

    @Test
    public void testSerDer0() throws IOException, ClassNotFoundException {
        this.runSerDer(this.store);
    }

    @Test
    public void testSerDer1() throws IOException, ClassNotFoundException {
        CachingPropertyStore caching = new CachingPropertyStore(this.store);
        this.runSerDer((PropertyStore)caching);
    }

    private void runSerDer(PropertyStore store) throws IOException {
        PropertyMap map = PropertyMapTest.fetchProperties(store, "serder", this::fetchSchema);
        map.putProperty("id", (Object)42);
        map.putProperty("name", (Object)"serder");
        map.putProperty("project", (Object)"Metastore");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(128);
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(map);
        byte[] data = baos.toByteArray();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));
        Function<String, PropertySchema> getSchema = this::fetchSchema;
        PropertyMap copy = (PropertyMap)SerializationProxy.read((InputStream)in, (Object[])new Object[]{getSchema});
        Assert.assertEquals((Object)42, (Object)copy.getProperty("id"));
        Assert.assertEquals((Object)"serder", (Object)copy.getProperty("name"));
        Assert.assertEquals((Object)map.getProperty("id"), (Object)copy.getProperty("id"));
        Assert.assertEquals((Object)map.getPropertyValue("name"), (Object)copy.getPropertyValue("name"));
        Assert.assertTrue((boolean)map.isDirty());
        store.saveProperties("serder", map);
        map = PropertyMapTest.fetchProperties(store, "serder", this::fetchSchema);
        Assert.assertFalse((boolean)map.isDirty());
        Assert.assertEquals((Object)42, (Object)map.getPropertyValue("id"));
        Assert.assertEquals((Object)"serder", (Object)map.getPropertyValue("name"));
        Assert.assertEquals((Object)"Metastore", (Object)map.getPropertyValue("project"));
        Assert.assertEquals((Object)"Metastore", (Object)map.removeProperty("project"));
        Assert.assertTrue((boolean)map.isDirty());
        Assert.assertEquals((Object)"Hive", (Object)map.getPropertyValue("project"));
        store.saveProperties("serder", map);
        Assert.assertFalse((boolean)map.isDirty());
        Assert.assertEquals((Object)"Hive", (Object)map.getPropertyValue("project"));
    }

    @Test
    public void testImportExport() {
        Properties ptys = new Properties();
        ptys.setProperty("id", "42");
        ptys.setProperty("name", "serder");
        ptys.setProperty("project", "Metastore");
        PropertyMap map = new PropertyMap(this.table);
        map.importFromProperties(ptys);
        PropertyMap ctl = new PropertyMap(this.table);
        ctl.putProperty("id", (Object)42);
        ctl.putProperty("name", (Object)"serder");
        ctl.putProperty("project", (Object)"Metastore");
        Assert.assertEquals((long)map.hashCode(), (long)ctl.hashCode());
        Assert.assertEquals((Object)map.getDigest(), (Object)ctl.getDigest());
        Assert.assertEquals((Object)map, (Object)ctl);
        Properties ctlp = new Properties();
        ctl.exportToProperties(ctlp);
        Assert.assertEquals((Object)ctlp, (Object)ptys);
    }
}

