/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.hadoop.hive.metastore.properties.PocExternal;
import org.apache.hadoop.hive.metastore.properties.SerializationProxy;
import org.junit.Assert;
import org.junit.Test;

public class PocExternalTest {
    @Test
    public void testExternal() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(128);
        ObjectOutputStream out = new ObjectOutputStream(baos);
        PocExternal poc = new PocExternal("fourty-two", 42);
        out.writeObject(poc);
        byte[] data = baos.toByteArray();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));
        PocExternal poci = (PocExternal)in.readObject();
        Assert.assertEquals((Object)poc.getString(), (Object)poci.getString());
        Assert.assertEquals((long)poc.getInt(), (long)poci.getInt());
    }

    @Test
    public void testExternalProxy() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(128);
        ObjectOutputStream out = new ObjectOutputStream(baos);
        PocExternal poc = new PocExternal("fourty-two", 42);
        byte[] data = SerializationProxy.toBytes((Serializable)poc, (Object[])new Object[0]);
        PocExternal poci = (PocExternal)SerializationProxy.fromBytes((byte[])data, (Object[])new Object[0]);
        Assert.assertEquals((Object)poc.getString(), (Object)poci.getString());
        Assert.assertEquals((long)poc.getInt(), (long)poci.getInt());
    }

    @Test
    public void testExternalDerive() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(128);
        ObjectOutputStream out = new ObjectOutputStream(baos);
        PocExternalDerive pocx = new PocExternalDerive("fourty-two", 42);
        out.writeObject(pocx);
        byte[] data = baos.toByteArray();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));
        PocExternal poci = (PocExternal)in.readObject();
        Assert.assertEquals((Object)"fOurty-twO", (Object)poci.getString());
        Assert.assertEquals((long)43L, (long)poci.getInt());
        Assert.assertEquals((Object)pocx.getString(), (Object)poci.getString());
        Assert.assertEquals((long)pocx.getInt(), (long)poci.getInt());
    }

    @Test
    public void testPoc3() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(128);
        ObjectOutputStream out = new ObjectOutputStream(baos);
        Poc3 pocx = new Poc3("fourty-two", 42);
        out.writeObject(pocx);
        byte[] data = baos.toByteArray();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));
        Poc3 poc3 = (Poc3)in.readObject();
        Assert.assertEquals((Object)"other42", (Object)poc3.getOther());
        data = SerializationProxy.toBytes((Serializable)poc3, (Object[])new Object[]{"alien"});
        poc3 = (Poc3)SerializationProxy.fromBytes((byte[])data, (Object[])new Object[]{true});
        Assert.assertEquals((Object)"ALIEN", (Object)poc3.getOther());
    }

    static {
        SerializationProxy.registerType((int)253, PocExternal.class);
    }

    public static class PocExternalDerive
    extends PocExternal {
        private static final long serialVersionUID = 202212281720L;

        private Object writeReplace() throws ObjectStreamException {
            return new SerializationProxy((Serializable)this);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("proxy required");
        }

        public PocExternalDerive(String str, int i) {
            super(str, i);
        }

        public PocExternalDerive(ObjectInput in) throws IOException {
            this(202212281720L, in);
        }

        protected PocExternalDerive(long version, DataInput in) throws IOException {
            super(version, in);
        }

        @Override
        public void write(ObjectOutput out) throws IOException {
            super.write(202212281720L, out);
        }

        public void write(ObjectOutput out, String more) throws IOException {
            super.write(202212281720L, out);
            out.writeUTF(more);
        }

        @Override
        public String getString() {
            return this.aString.replace('o', 'O');
        }

        @Override
        public int getInt() {
            return this.anInt + 1;
        }
    }

    public static class Poc3
    extends PocExternalDerive {
        private static final long serialVersionUID = 202301021116L;
        private String other;

        private Object writeReplace() throws ObjectStreamException {
            return new SerializationProxy((Serializable)this);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("proxy required");
        }

        public Poc3(String str, int i) {
            super(str, i);
            this.other = "other" + i;
        }

        public Poc3(ObjectInput in) throws IOException {
            super(202301021116L, in);
            this.other = in.readUTF();
        }

        public Poc3(ObjectInput in, boolean up) throws IOException {
            super(202301021116L, in);
            this.other = in.readUTF();
            if (up) {
                this.other = this.other.toUpperCase();
            }
        }

        public String getOther() {
            return this.other;
        }

        @Override
        public void write(ObjectOutput out) throws IOException {
            super.write(202301021116L, out);
            out.writeUTF(this.other);
        }

        @Override
        public void write(ObjectOutput out, String alien) throws IOException {
            super.write(202301021116L, out);
            out.writeUTF(alien);
        }
    }
}

