/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import org.apache.hadoop.hive.metastore.properties.PropertyManager;
import org.apache.hadoop.hive.metastore.properties.PropertySchema;
import org.apache.hadoop.hive.metastore.properties.PropertyStore;
import org.apache.hadoop.hive.metastore.properties.PropertyType;

public class JavaTestManager
extends PropertyManager {
    static final PropertySchema DOMAIN = new PropertySchema("domain");
    static final PropertySchema PACKAGE = new PropertySchema("package");
    static final PropertySchema CLAZZ = new PropertySchema("clazz");
    static final PropertySchema[] SCHEMAS = new PropertySchema[]{DOMAIN, PACKAGE, CLAZZ};

    public static void initialize() {
        PropertyManager.declare((String)"jtm", JavaTestManager.class);
    }

    JavaTestManager(PropertyStore store) {
        this("jtm", store);
    }

    public JavaTestManager(String ns, PropertyStore store) {
        super(ns, store);
    }

    public PropertySchema getSchema(String schemaName) {
        switch (schemaName) {
            case "domain": {
                return DOMAIN;
            }
            case "package": {
                return PACKAGE;
            }
            case "clazz": {
                return CLAZZ;
            }
        }
        return null;
    }

    protected PropertySchema schemaOf(String[] keys) {
        return keys.length > 0 && keys.length < SCHEMAS.length ? SCHEMAS[keys.length - 1] : CLAZZ;
    }

    protected int getMapNameLength(String[] keys) {
        return SCHEMAS.length;
    }

    public static void declareDomainProperty(String name, PropertyType type, Object defaultValue) {
        DOMAIN.declareProperty(name, type, defaultValue);
    }

    public static void declarePackageProperty(String name, PropertyType type, Object defaultValue) {
        PACKAGE.declareProperty(name, type, defaultValue);
    }

    public static void declareClazzProperty(String name, PropertyType type, Object defaultValue) {
        CLAZZ.declareProperty(name, type, defaultValue);
    }
}

