/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.spark.client.SparkClient;
import org.apache.hive.spark.client.SparkLauncherSparkClient;
import org.apache.hive.spark.client.SparkSubmitSparkClient;
import org.apache.hive.spark.client.rpc.RpcServer;

@InterfaceAudience.Private
public final class SparkClientFactory {
    static final String CONF_CLIENT_ID = "spark.client.authentication.client_id";
    static final String CONF_KEY_SECRET = "spark.client.authentication.secret";
    private static volatile RpcServer server = null;
    private static final Object serverLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Map<String, String> conf, HiveConf hiveConf) throws IOException {
        if (server == null) {
            Object object = serverLock;
            synchronized (object) {
                if (server == null) {
                    try {
                        server = new RpcServer(conf, hiveConf);
                    }
                    catch (InterruptedException ie) {
                        throw Throwables.propagate((Throwable)ie);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        if (server != null) {
            Object object = serverLock;
            synchronized (object) {
                if (server != null) {
                    server.close();
                    server = null;
                }
            }
        }
    }

    public static SparkClient createClient(Map<String, String> sparkConf, HiveConf hiveConf, String sessionId) throws IOException {
        Preconditions.checkState((server != null ? 1 : 0) != 0, (Object)"Invalid state: Hive on Spark RPC Server has not been initialized");
        switch (hiveConf.getVar(HiveConf.ConfVars.SPARK_CLIENT_TYPE)) {
            case "spark-submit": {
                return new SparkSubmitSparkClient(server, sparkConf, hiveConf, sessionId);
            }
            case "spark-launcher": {
                return new SparkLauncherSparkClient(server, sparkConf, hiveConf, sessionId);
            }
        }
        throw new IllegalArgumentException("Unknown Hive on Spark launcher type " + hiveConf.getVar(HiveConf.ConfVars.SPARK_CLIENT_TYPE) + " valid options are " + "spark-submit" + " or " + "spark-launcher");
    }

    @VisibleForTesting
    public static int getServerPort() {
        return server.getPort();
    }
}

