/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.client;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Objects;
import org.apache.hive.spark.client.BaseProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobResultSerializer
extends Serializer<BaseProtocol.JobResult<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(JobResultSerializer.class);

    public BaseProtocol.JobResult<?> read(Kryo kryo, Input input, Class type) {
        try {
            return (BaseProtocol.JobResult)new ObjectInputStream((InputStream)input).readObject();
        }
        catch (Exception e) {
            throw new KryoException("Error during Java deserialization.", (Throwable)e);
        }
    }

    public void write(Kryo kryo, Output output, BaseProtocol.JobResult<?> object) {
        try {
            this.safeWriteToOutput(output, object);
        }
        catch (Exception e) {
            LOG.warn("Unable to serialize JobResult object " + object, (Throwable)e);
            BaseProtocol.JobResult serializableJobResult = new BaseProtocol.JobResult(object.id, object.result, JobResultSerializer.convertToSerializableSparkException(object.error), object.sparkCounters);
            try {
                this.safeWriteToOutput(output, serializableJobResult);
            }
            catch (Exception ex) {
                throw new KryoException("Error during Java serialization.", (Throwable)ex);
            }
        }
    }

    private void safeWriteToOutput(Output output, BaseProtocol.JobResult<?> jobResult) throws IOException {
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(boas);
        oos.writeObject(jobResult);
        oos.flush();
        output.write(boas.toByteArray());
        output.flush();
    }

    @VisibleForTesting
    static RuntimeException convertToSerializableSparkException(Throwable error) {
        RuntimeException serializableThrowable = new RuntimeException(error.getClass().getName() + ": " + Objects.toString(error.getMessage(), ""), error.getCause() == null ? null : JobResultSerializer.convertToSerializableSparkException(error.getCause()));
        serializableThrowable.setStackTrace(error.getStackTrace());
        Arrays.stream(error.getSuppressed()).map(JobResultSerializer::convertToSerializableSparkException).forEach(serializableThrowable::addSuppressed);
        return serializableThrowable;
    }
}

