/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.util.Collections;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.RowSetFactory;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.MetadataOperation;
import org.apache.hive.service.cli.session.HiveSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetCatalogsOperation
extends MetadataOperation {
    private static final Logger LOG = LoggerFactory.getLogger((String)GetCatalogsOperation.class.getName());
    private static final TableSchema RESULT_SET_SCHEMA = new TableSchema().addStringColumn("TABLE_CAT", "Catalog name. NULL if not applicable.");
    private final RowSet rowSet = RowSetFactory.create(RESULT_SET_SCHEMA, this.getProtocolVersion(), false);

    protected GetCatalogsOperation(HiveSession parentSession) {
        super(parentSession, OperationType.GET_CATALOGS);
        LOG.info("Starting GetCatalogsOperation");
    }

    @Override
    public void runInternal() throws HiveSQLException {
        this.setState(OperationState.RUNNING);
        try {
            if (this.isAuthV2Enabled()) {
                this.authorizeMetaGets(HiveOperationType.GET_CATALOGS, null);
            }
            this.setState(OperationState.FINISHED);
            LOG.info("Fetching catalog metadata has been successfully finished");
        }
        catch (HiveSQLException e) {
            this.setState(OperationState.ERROR);
            throw e;
        }
    }

    @Override
    public TableSchema getResultSetSchema() throws HiveSQLException {
        return RESULT_SET_SCHEMA;
    }

    @Override
    public RowSet getNextRowSet(FetchOrientation orientation, long maxRows) throws HiveSQLException {
        this.assertState(Collections.singleton(OperationState.FINISHED));
        this.validateDefaultFetchOrientation(orientation);
        if (orientation.equals((Object)FetchOrientation.FETCH_FIRST)) {
            this.rowSet.setStartOffset(0L);
        }
        return this.rowSet.extractSubset((int)maxRows);
    }
}

