/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hive.service.server.HiveServer2;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveServer2 {
    @Test
    public void testMaybeStartCompactorThreadsOneCustomPool() {
        HiveServer2 hs2 = new HiveServer2();
        HiveConf conf = new HiveConf();
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_METASTORE_RUNWORKER_IN, (String)"hs2");
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_WORKER_THREADS, (long)1L);
        conf.setInt("hive.compactor.worker.pool1.threads", 1);
        Map startedWorkers = hs2.maybeStartCompactorThreads(conf);
        Assert.assertEquals((long)1L, (long)startedWorkers.size());
        Assert.assertEquals((Object)1, startedWorkers.get("pool1"));
    }

    @Test
    public void testMaybeStartCompactorThreadsZeroTotalWorkers() {
        HiveServer2 hs2 = new HiveServer2();
        HiveConf conf = new HiveConf();
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_METASTORE_RUNWORKER_IN, (String)"hs2");
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_WORKER_THREADS, (long)0L);
        conf.setInt("hive.compactor.worker.pool1.threads", 5);
        Map startedWorkers = hs2.maybeStartCompactorThreads(conf);
        Assert.assertEquals((long)0L, (long)startedWorkers.size());
    }

    @Test
    public void testMaybeStartCompactorThreadsZeroCustomWorkers() {
        HiveServer2 hs2 = new HiveServer2();
        HiveConf conf = new HiveConf();
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_METASTORE_RUNWORKER_IN, (String)"hs2");
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_WORKER_THREADS, (long)5L);
        Map startedWorkers = hs2.maybeStartCompactorThreads(conf);
        Assert.assertEquals((long)1L, (long)startedWorkers.size());
        Assert.assertEquals((Object)5, startedWorkers.get("default"));
    }

    @Test
    public void testMaybeStartCompactorThreadsMultipleCustomPools() {
        HiveServer2 hs2 = new HiveServer2();
        HiveConf conf = new HiveConf();
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_METASTORE_RUNWORKER_IN, (String)"hs2");
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_WORKER_THREADS, (long)12L);
        conf.setInt("hive.compactor.worker.pool1.threads", 3);
        conf.setInt("hive.compactor.worker.pool2.threads", 4);
        conf.setInt("hive.compactor.worker.pool3.threads", 5);
        Map startedWorkers = hs2.maybeStartCompactorThreads(conf);
        Assert.assertEquals((long)3L, (long)startedWorkers.size());
        Assert.assertEquals((Object)3, startedWorkers.get("pool1"));
        Assert.assertEquals((Object)4, startedWorkers.get("pool2"));
        Assert.assertEquals((Object)5, startedWorkers.get("pool3"));
    }

    @Test
    public void testMaybeStartCompactorThreadsMultipleCustomPoolsAndDefaultPool() {
        HiveServer2 hs2 = new HiveServer2();
        HiveConf conf = new HiveConf();
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_METASTORE_RUNWORKER_IN, (String)"hs2");
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_WORKER_THREADS, (long)15L);
        conf.setInt("hive.compactor.worker.pool1.threads", 3);
        conf.setInt("hive.compactor.worker.pool2.threads", 4);
        conf.setInt("hive.compactor.worker.pool3.threads", 5);
        Map startedWorkers = hs2.maybeStartCompactorThreads(conf);
        Assert.assertEquals((long)4L, (long)startedWorkers.size());
        Assert.assertEquals((Object)3, startedWorkers.get("pool1"));
        Assert.assertEquals((Object)4, startedWorkers.get("pool2"));
        Assert.assertEquals((Object)5, startedWorkers.get("pool3"));
        Assert.assertEquals((Object)3, startedWorkers.get("default"));
    }
}

