/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hive.service.server.HiveServer2;
import org.apache.hive.service.server.TestHS2HttpServerPam;
import org.hamcrest.CoreMatchers;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestHS2HttpServerPamConfiguration {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static HiveServer2 hiveServer2 = null;
    private static HiveConf hiveConf = null;
    private static String keyStorePassword = "123456";
    private static String keyFileName = "myKeyStore";
    private static String keyStoreType = KeyStore.getDefaultType();
    private static String testDataDir = new File(System.getProperty("java.io.tmpdir") + File.separator + TestHS2HttpServerPam.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");
    private static String sslKeyStorePath = testDataDir + File.separator + keyFileName;
    private static String excludeSuites = "^.*_(MD5|SHA1)$,^TLS_RSA_.*$,^SSL_.*$,^.*_NULL_.*$,^.*_anon_.*$";

    @BeforeClass
    public static void beforeTests() throws Exception {
        TestHS2HttpServerPamConfiguration.createTestDir();
        TestHS2HttpServerPamConfiguration.createDefaultKeyStore();
        String metastorePasswd = "693efe9fa425ad21886d73a0fa3fbc70";
        Integer webUIPort = MetaStoreTestUtils.findFreePortExcepting((int)Integer.valueOf(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT.getDefaultValue()));
        hiveConf = new HiveConf();
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_USE_PAM, true);
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_IN_TEST, false);
        hiveConf.set(HiveConf.ConfVars.METASTORE_PWD.varname, metastorePasswd);
        hiveConf.set(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT.varname, webUIPort.toString());
        hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_QUERY_HISTORY_ENABLED, false);
    }

    @Test
    public void testSslIsFalse() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(CoreMatchers.is((Object)(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_USE_SSL.varname + " has false value. It is recommended to set to true when PAM is used.")));
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PAM_SERVICES, "sshd");
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_USE_SSL, false);
        hiveServer2 = new HiveServer2();
        hiveServer2.init(hiveConf);
    }

    @Test
    public void testPamServicesAreNotConfigured() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(CoreMatchers.is((Object)(HiveConf.ConfVars.HIVE_SERVER2_PAM_SERVICES.varname + " are not configured.")));
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PAM_SERVICES, "");
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_USE_SSL, true);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SSL_KEYSTORE_PATH, sslKeyStorePath);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SSL_KEYSTORE_PASSWORD, keyStorePassword);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SSL_EXCLUDE_CIPHERSUITES, excludeSuites);
        hiveServer2 = new HiveServer2();
        hiveServer2.init(hiveConf);
    }

    @Test
    public void testPamCorrectConfiguration() {
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PAM_SERVICES, "sshd");
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_USE_SSL, true);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SSL_KEYSTORE_PATH, sslKeyStorePath);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SSL_KEYSTORE_PASSWORD, keyStorePassword);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SSL_KEYSTORE_TYPE, keyStoreType);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SSL_EXCLUDE_CIPHERSUITES, excludeSuites);
        hiveServer2 = new HiveServer2();
        hiveServer2.init(hiveConf);
    }

    @AfterClass
    public static void afterTests() throws IOException {
        FileUtils.deleteDirectory((File)new File(testDataDir));
    }

    private static void createTestDir() {
        if (!new File(testDataDir).mkdirs()) {
            throw new RuntimeException("Could not create " + testDataDir);
        }
    }

    private static void createDefaultKeyStore() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] password = keyStorePassword.toCharArray();
        ks.load(null, null);
        try (FileOutputStream fos = new FileOutputStream(sslKeyStorePath);){
            ks.store(fos, password);
        }
    }
}

