/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import javax.security.sasl.AuthenticationException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hive.service.auth.HttpAuthUtils;
import org.apache.hive.service.auth.PasswdAuthenticationProvider;
import org.apache.hive.service.server.HiveServer2;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.B64Code;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHS2HttpServerLDAP {
    private static HiveServer2 hiveServer2;
    private static Integer webUIPort;
    private static final String HOST = "localhost";
    private static final String METASTORE_PASSWD = "693efe9fa425ad21886d73a0fa3fbc70";
    private static final String VALID_USER = "validUser";
    private static final String VALID_PASS = "validPass";
    private static final String INVALID_USER = "invalidUser";
    private static final String INVALID_PASS = "invalidPass";

    @BeforeClass
    public static void beforeTests() throws Exception {
        webUIPort = MetaStoreTestUtils.findFreePortExcepting((int)Integer.parseInt(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT.getDefaultValue()));
        HiveConf hiveConf = new HiveConf();
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_IN_TEST, true);
        hiveConf.set(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT.varname, webUIPort.toString());
        hiveConf.set(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_AUTH_METHOD.varname, "LDAP");
        hiveConf.set(HiveConf.ConfVars.METASTORE_PWD.varname, METASTORE_PASSWD);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_QUERY_HISTORY_ENABLED, false);
        DummyLdapAuthenticationProviderImpl authenticationProvider = new DummyLdapAuthenticationProviderImpl();
        hiveServer2 = new HiveServer2((PasswdAuthenticationProvider)authenticationProvider);
        hiveServer2.init(hiveConf);
        hiveServer2.start();
        Thread.sleep(5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidCredentialsWithAuthorizationHeader() throws Exception {
        try (CloseableHttpClient httpclient = null;){
            BasicCookieStore httpCookieStore = new BasicCookieStore();
            HttpClientBuilder builder = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)httpCookieStore);
            httpclient = builder.build();
            HttpGet httpGet = new HttpGet("http://localhost:" + webUIPort + "/jmx");
            String authB64Code = B64Code.encode((String)"validUser:validPass", (String)"iso-8859-1");
            httpGet.setHeader(HttpHeader.AUTHORIZATION.asString(), "Basic " + authB64Code);
            httpclient.execute((HttpUriRequest)httpGet);
            Assert.assertTrue((boolean)TestHS2HttpServerLDAP.isAuthorized(httpCookieStore.getCookies()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidCredentialsWithInAuthorizationHeader() throws Exception {
        try (CloseableHttpClient httpclient = null;){
            BasicCookieStore httpCookieStore = new BasicCookieStore();
            HttpClientBuilder builder = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)httpCookieStore);
            httpclient = builder.build();
            HttpGet httpGet = new HttpGet("http://localhost:" + webUIPort + "/jmx");
            String authB64Code = B64Code.encode((String)"invalidUser:invalidPass", (String)"iso-8859-1");
            httpGet.setHeader(HttpHeader.AUTHORIZATION.asString(), "Basic " + authB64Code);
            httpclient.execute((HttpUriRequest)httpGet);
            Assert.assertFalse((boolean)TestHS2HttpServerLDAP.isAuthorized(httpCookieStore.getCookies()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidCredentialsWithRequestParameters() throws Exception {
        try (CloseableHttpClient httpclient = null;){
            BasicCookieStore httpCookieStore = new BasicCookieStore();
            HttpClientBuilder builder = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)httpCookieStore);
            httpclient = builder.build();
            BasicHttpParams params = new BasicHttpParams();
            params.setParameter("username", (Object)VALID_USER);
            params.setParameter("password", (Object)VALID_PASS);
            HttpPost httpPost = new HttpPost("http://localhost:" + webUIPort + "/login");
            httpPost.setParams((HttpParams)params);
            httpclient.execute((HttpUriRequest)httpPost);
            Assert.assertFalse((boolean)TestHS2HttpServerLDAP.isAuthorized(httpCookieStore.getCookies()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidCredentialsWithRequestParameters() throws Exception {
        try (CloseableHttpClient httpclient = null;){
            BasicCookieStore httpCookieStore = new BasicCookieStore();
            HttpClientBuilder builder = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)httpCookieStore);
            httpclient = builder.build();
            BasicHttpParams params = new BasicHttpParams();
            params.setParameter("username", (Object)INVALID_USER);
            params.setParameter("password", (Object)INVALID_PASS);
            HttpPost httpPost = new HttpPost("http://localhost:" + webUIPort + "/login");
            httpPost.setParams((HttpParams)params);
            httpclient.execute((HttpUriRequest)httpPost);
            Assert.assertFalse((boolean)TestHS2HttpServerLDAP.isAuthorized(httpCookieStore.getCookies()));
        }
    }

    @Test
    public void testEscapeAuthentication() throws Exception {
        try (CloseableHttpClient httpclient = HttpClientBuilder.create().build();){
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)new HttpGet("http://localhost:" + webUIPort + "/hiveserver2.jsp;login"));){
                this.checkForwardToLoginPage(response);
            }
            response = httpclient.execute((HttpUriRequest)new HttpGet("http://localhost:" + webUIPort + "/logs"));
            try {
                this.checkForwardToLoginPage(response);
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
    }

    private void checkForwardToLoginPage(CloseableHttpResponse response) throws Exception {
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        String content = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        Assert.assertTrue((boolean)content.contains("<meta name=\"description\" content=\"Login - Hive\">"));
        Assert.assertTrue((boolean)content.contains("<div class=\"login-form\">"));
    }

    public static boolean isAuthorized(List<Cookie> cookies) {
        Optional<Cookie> cookie = cookies.stream().filter(c -> c.getName().equals("hive.server2.webui.auth")).findAny();
        if (!cookie.isPresent()) {
            return false;
        }
        String signedCookieValue = cookie.get().getValue();
        String cookieValue = hiveServer2.getLdapAuthService().verifyAndExtract(signedCookieValue);
        String userName = HttpAuthUtils.getUserNameFromCookieToken((String)cookieValue);
        return userName.equals(VALID_USER);
    }

    @AfterClass
    public static void afterTests() {
        hiveServer2.stop();
    }

    public static class DummyLdapAuthenticationProviderImpl
    implements PasswdAuthenticationProvider {
        public void authenticate(String user, String password) throws AuthenticationException {
            if (!user.equals(TestHS2HttpServerLDAP.VALID_USER) || !password.equals(TestHS2HttpServerLDAP.VALID_PASS)) {
                throw new AuthenticationException();
            }
        }
    }
}

