/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hive.common.IPStackUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.session.SessionManager;
import org.apache.hive.service.cli.thrift.AbstractThriftCLITest;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHS2HttpServer
extends AbstractThriftCLITest {
    private static CLIService client = null;
    private static SessionManager sm = null;
    private static String metastorePasswd = "61ecbc41cdae3e6b32712a06c73606fa";
    private static Integer webUIPort = null;
    private static String apiBaseURL = null;

    @BeforeClass
    public static void beforeTests() throws Exception {
        TestHS2HttpServer.initConf(TestHS2HttpServer.class);
        webUIPort = TestHS2HttpServer.findFreePortExcepting(Integer.valueOf(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT.getDefaultValue()));
        apiBaseURL = "http://localhost:" + webUIPort + "/api/v1";
        hiveConf.set(HiveConf.ConfVars.METASTORE_PWD.varname, metastorePasswd);
        hiveConf.set(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT.varname, webUIPort.toString());
        hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_QUERY_HISTORY_ENABLED, false);
        TestHS2HttpServer.startHiveServer2WithConf(hiveConf);
        client = hiveServer2.getCliService();
        webUIPort = hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT);
        sm = hiveServer2.getCliService().getSessionManager();
    }

    @Test
    public void testStackServlet() throws Exception {
        String line;
        String baseURL = "http://localhost:" + webUIPort + "/stacks";
        URL url = new URL(baseURL);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        boolean contents = false;
        while ((line = reader.readLine()) != null) {
            if (!line.contains("Process Thread Dump:")) continue;
            contents = true;
        }
        Assert.assertTrue((boolean)contents);
    }

    @Test
    public void testBaseUrlResponseHeader() throws Exception {
        String baseURL = "http://localhost:" + webUIPort + "/";
        URL url = new URL(baseURL);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        String xfoHeader = conn.getHeaderField("X-FRAME-OPTIONS");
        String xXSSProtectionHeader = conn.getHeaderField("X-XSS-Protection");
        String xContentTypeHeader = conn.getHeaderField("X-Content-Type-Options");
        Assert.assertNotNull((Object)xfoHeader);
        Assert.assertNotNull((Object)xXSSProtectionHeader);
        Assert.assertNotNull((Object)xContentTypeHeader);
    }

    @Test
    public void testDirListingDisabledOnStaticServlet() throws Exception {
        String url = "http://localhost:" + webUIPort + "/static";
        this.getReaderForUrl(url, 403);
    }

    private BufferedReader getReaderForUrl(String urlString, int expectedStatus) throws Exception {
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)expectedStatus, (long)conn.getResponseCode());
        if (expectedStatus != 200) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        return reader;
    }

    private String readFromUrl(String urlString) throws Exception {
        String inputLine;
        BufferedReader reader = this.getReaderForUrl(urlString, 200);
        StringBuilder response = new StringBuilder();
        while ((inputLine = reader.readLine()) != null) {
            response.append(inputLine);
        }
        reader.close();
        return response.toString();
    }

    private static List<JsonNode> getListOfNodes(String json) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode rootNode = objectMapper.readTree(json);
        ArrayList<JsonNode> nodes = new ArrayList<JsonNode>();
        if (rootNode.isArray()) {
            for (JsonNode node : rootNode) {
                nodes.add(node);
            }
        }
        return nodes;
    }

    @Test
    public void testApiServletHistoricalQueries() throws Exception {
        String historicalQueriesRoute = "/queries/historical";
        SessionHandle handle = sm.openSession(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V9, "user", "passw", IPStackUtils.resolveLoopbackAddress(), new HashMap());
        String queryString = "SET " + HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY.varname + " = false";
        OperationHandle opHandle = client.executeStatement(handle, queryString, new HashMap());
        client.closeOperation(opHandle);
        opHandle = client.executeStatement(handle, "SELECT 1", new HashMap());
        client.closeOperation(opHandle);
        String queriesResponse = this.readFromUrl(apiBaseURL + historicalQueriesRoute);
        List<JsonNode> historicalQueries = TestHS2HttpServer.getListOfNodes(queriesResponse);
        Assert.assertTrue((historicalQueries.size() == 1 ? 1 : 0) != 0);
        JsonNode historicalQuery = historicalQueries.get(0);
        Assert.assertEquals((Object)historicalQuery.path("running").asBoolean(), (Object)false);
        Assert.assertEquals((Object)historicalQuery.path("state").asText(), (Object)"FINISHED");
        Assert.assertTrue((boolean)historicalQuery.path("runtime").canConvertToInt());
        Assert.assertTrue((boolean)historicalQuery.path("queryDisplay").isObject());
    }

    @Test
    public void testApiServletActiveSessions() throws Exception {
        String sessionsRoute = "/sessions";
        String initNoSessionsResponse = this.readFromUrl(apiBaseURL + sessionsRoute);
        Assert.assertTrue((boolean)"[]".equals(initNoSessionsResponse));
        SessionHandle handle1 = sm.openSession(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V9, "user", "passw", IPStackUtils.resolveLoopbackAddress(), new HashMap());
        String oneSessionResponse = this.readFromUrl(apiBaseURL + sessionsRoute);
        List<JsonNode> sessionNodes = TestHS2HttpServer.getListOfNodes(oneSessionResponse);
        Assert.assertEquals((long)sessionNodes.size(), (long)1L);
        JsonNode session = sessionNodes.get(0);
        Assert.assertEquals((Object)session.path("sessionId").asText(), (Object)handle1.getSessionId().toString());
        Assert.assertEquals((Object)session.path("username").asText(), (Object)"user");
        Assert.assertEquals((Object)session.path("ipAddress").asText(), (Object)IPStackUtils.resolveLoopbackAddress());
        Assert.assertEquals((long)session.path("operationCount").asInt(), (long)0L);
        Assert.assertTrue((boolean)session.path("activeTime").canConvertToInt());
        Assert.assertTrue((boolean)session.path("idleTime").canConvertToInt());
        SessionHandle handle2 = sm.openSession(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V9, "user", "passw", IPStackUtils.resolveLoopbackAddress(), new HashMap());
        String twoSessionsResponse = this.readFromUrl(apiBaseURL + sessionsRoute);
        List<JsonNode> twoSessionsNodes = TestHS2HttpServer.getListOfNodes(twoSessionsResponse);
        Assert.assertEquals((long)twoSessionsNodes.size(), (long)2L);
        sm.closeSession(handle1);
        sm.closeSession(handle2);
        String endNoSessionsResponse = this.readFromUrl(apiBaseURL + sessionsRoute);
        Assert.assertTrue((boolean)"[]".equals(endNoSessionsResponse));
    }

    @Test
    public void testWrongApiVersion() throws Exception {
        String wrongApiVersionUrl = "http://localhost:" + webUIPort + "/api/v2";
        URL url = new URL(wrongApiVersionUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)400L, (long)conn.getResponseCode());
    }

    @Test
    public void testWrongRoute() throws Exception {
        String wrongRouteUrl = "http://localhost:" + webUIPort + "/api/v1/nonexistingRoute";
        URL url = new URL(wrongRouteUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)404L, (long)conn.getResponseCode());
    }

    @Test
    public void testContextRootUrlRewrite() throws Exception {
        String datePattern = "[a-zA-Z]{3} [a-zA-Z]{3} [0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}";
        String dateMask = "xxxMasked_DateTime_xxx";
        String baseURL = "http://localhost:" + webUIPort + "/";
        String contextRootContent = this.getURLResponseAsString(baseURL);
        String jspUrl = "http://localhost:" + webUIPort + "/hiveserver2.jsp";
        String jspContent = this.getURLResponseAsString(jspUrl);
        String expected = contextRootContent.replaceAll(datePattern, dateMask);
        String actual = jspContent.replaceAll(datePattern, dateMask);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfStrippedFromWebUI() throws Exception {
        String pwdValFound = null;
        String pwdKeyFound = null;
        try (CloseableHttpClient httpclient = null;){
            httpclient = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet("http://localhost:" + webUIPort + "/conf");
            try (CloseableHttpResponse response1 = httpclient.execute((HttpUriRequest)httpGet);){
                String line;
                HttpEntity entity1 = response1.getEntity();
                BufferedReader br = new BufferedReader(new InputStreamReader(entity1.getContent()));
                while ((line = br.readLine()) != null) {
                    if (line.contains(metastorePasswd)) {
                        pwdValFound = line;
                    }
                    if (!line.contains(HiveConf.ConfVars.METASTORE_PWD.varname)) continue;
                    pwdKeyFound = line;
                }
                EntityUtils.consume((HttpEntity)entity1);
            }
        }
        Assert.assertNotNull(pwdKeyFound);
        Assert.assertNull((Object)pwdValFound);
    }

    private String getURLResponseAsString(String baseURL) throws IOException {
        URL url = new URL(baseURL);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((String)"Got an HTTP response code other thank OK.", (long)200L, (long)conn.getResponseCode());
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)conn.getInputStream(), (Writer)writer, (String)"UTF-8");
        return writer.toString();
    }
}

