/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.HiveAuthConstants;
import org.apache.hive.service.auth.ldap.HttpEmptyAuthenticationException;
import org.apache.hive.service.cli.thrift.ThriftHttpServlet;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ThriftHttpServletTest {
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();
    private ThriftHttpServlet thriftHttpServlet;
    private HiveConf hiveConf = new HiveConf();

    @Before
    public void setUp() throws Exception {
        String authType = HiveAuthConstants.AuthTypes.KERBEROS.toString();
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION, authType);
        this.thriftHttpServlet = new ThriftHttpServlet(null, null, null, null, null, this.hiveConf);
    }

    @Test
    public void testMissingAuthorizationHeader() throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)httpServletRequest.getHeader("Authorization")).thenReturn(null);
        this.exceptionRule.expect(HttpEmptyAuthenticationException.class);
        this.exceptionRule.expectMessage("Authorization header received from the client is empty.");
        this.thriftHttpServlet.doKerberosAuth(httpServletRequest);
    }

    @Test
    public void testEmptyAuthorizationHeader() throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)httpServletRequest.getHeader("Authorization")).thenReturn((Object)"");
        this.exceptionRule.expect(HttpEmptyAuthenticationException.class);
        this.exceptionRule.expectMessage("Authorization header received from the client is empty.");
        this.thriftHttpServlet.doKerberosAuth(httpServletRequest);
    }

    @Test
    public void testWwwAuthenticateNegotiateHeaderAddedToTheResponse() throws Exception {
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse mockResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        PrintWriter mockPrintWriter = (PrintWriter)Mockito.mock(PrintWriter.class);
        Mockito.when((Object)mockResponse.getWriter()).thenReturn((Object)mockPrintWriter);
        this.thriftHttpServlet.doPost(mockRequest, mockResponse);
        ((HttpServletResponse)Mockito.verify((Object)mockResponse)).setStatus(401);
        ((PrintWriter)Mockito.verify((Object)mockPrintWriter)).println("Authentication Error: Authorization header received from the client is empty.");
        ((HttpServletResponse)Mockito.verify((Object)mockResponse)).addHeader("WWW-Authenticate", "Negotiate");
    }

    @Test
    public void testWwwAuthenticateNegotiateHeaderNotAddedToTheResponseWhenNotEmptyAuthorizationHeaderExists() throws Exception {
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockRequest.getHeader("Authorization")).thenReturn((Object)"Authorization: Negotiate");
        HttpServletResponse mockResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        PrintWriter mockPrintWriter = (PrintWriter)Mockito.mock(PrintWriter.class);
        Mockito.when((Object)mockResponse.getWriter()).thenReturn((Object)mockPrintWriter);
        this.thriftHttpServlet.doPost(mockRequest, mockResponse);
        ((HttpServletResponse)Mockito.verify((Object)mockResponse)).setStatus(401);
        ((HttpServletResponse)Mockito.verify((Object)mockResponse, (VerificationMode)Mockito.times((int)0))).addHeader("WWW-Authenticate", "Negotiate");
    }
}

