/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import java.util.HashMap;
import org.apache.hive.service.Service;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationStatus;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.thrift.AbstractThriftCLITest;
import org.apache.hive.service.cli.thrift.ThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIServiceClient;
import org.apache.hive.service.cli.thrift.ThriftHttpCLIService;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class ThriftCLIServiceTest
extends AbstractThriftCLITest {
    static ThriftCLIServiceClient getServiceClientInternal() {
        for (Service service : hiveServer2.getServices()) {
            if (service instanceof ThriftBinaryCLIService) {
                return new ThriftCLIServiceClient((TCLIService.Iface)((ThriftBinaryCLIService)service));
            }
            if (!(service instanceof ThriftHttpCLIService)) continue;
            return new ThriftCLIServiceClient((TCLIService.Iface)((ThriftHttpCLIService)service));
        }
        throw new IllegalStateException("HiveServer2 not running Thrift service");
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testOpenSession() throws Exception {
        SessionHandle sessHandle = client.openSession(USERNAME, PASSWORD, new HashMap());
        Assert.assertNotNull((String)"Session handle should not be null", (Object)sessHandle);
        client.closeSession(sessHandle);
    }

    @Test
    public void testGetFunctions() throws Exception {
        SessionHandle sessHandle = client.openSession(USERNAME, PASSWORD, new HashMap());
        Assert.assertNotNull((String)"Session handle should not be null", (Object)sessHandle);
        String catalogName = null;
        String schemaName = null;
        String functionName = "*";
        OperationHandle opHandle = client.getFunctions(sessHandle, catalogName, schemaName, functionName);
        Assert.assertNotNull((String)"Operation handle should not be null", (Object)opHandle);
        client.closeSession(sessHandle);
    }

    @Test
    public void testExecuteStatement() throws Exception {
        HashMap opConf = new HashMap();
        SessionHandle sessHandle = client.openSession(USERNAME, PASSWORD, opConf);
        Assert.assertNotNull((String)"Session handle should not be null", (Object)sessHandle);
        String queryString = "SET hive.lock.manager=org.apache.hadoop.hive.ql.lockmgr.EmbeddedLockManager";
        client.executeStatement(sessHandle, queryString, opConf);
        queryString = "DROP TABLE IF EXISTS TEST_EXEC_THRIFT";
        client.executeStatement(sessHandle, queryString, opConf);
        queryString = "CREATE TABLE TEST_EXEC_THRIFT(ID STRING)";
        client.executeStatement(sessHandle, queryString, opConf);
        queryString = "SELECT ID+1 FROM TEST_EXEC_THRIFT";
        OperationHandle opHandle = client.executeStatement(sessHandle, queryString, opConf);
        Assert.assertNotNull((Object)opHandle);
        OperationStatus opStatus = client.getOperationStatus(opHandle, false);
        Assert.assertNotNull((Object)opStatus);
        OperationState state = opStatus.getState();
        Assert.assertEquals((String)"Query should be finished", (Object)OperationState.FINISHED, (Object)state);
        queryString = "DROP TABLE TEST_EXEC_THRIFT";
        client.executeStatement(sessHandle, queryString, opConf);
        client.closeSession(sessHandle);
    }

    @Test
    public void testExecuteStatementAsync() throws Exception {
        OperationStatus opStatus;
        HashMap opConf = new HashMap();
        SessionHandle sessHandle = client.openSession(USERNAME, PASSWORD, opConf);
        Assert.assertNotNull((String)"Session handle should not be null", (Object)sessHandle);
        OperationState state = null;
        String queryString = "SET hive.lock.manager=org.apache.hadoop.hive.ql.lockmgr.EmbeddedLockManager";
        client.executeStatement(sessHandle, queryString, opConf);
        queryString = "DROP TABLE IF EXISTS TEST_EXEC_ASYNC_THRIFT";
        client.executeStatement(sessHandle, queryString, opConf);
        queryString = "CREATE TABLE TEST_EXEC_ASYNC_THRIFT(ID STRING)";
        client.executeStatement(sessHandle, queryString, opConf);
        queryString = "SELECT ID+1 FROM TEST_EXEC_ASYNC_THRIFT";
        System.out.println("Will attempt to execute: " + queryString);
        OperationHandle opHandle = client.executeStatementAsync(sessHandle, queryString, opConf);
        Assert.assertNotNull((Object)opHandle);
        boolean isQueryRunning = true;
        long pollTimeout = System.currentTimeMillis() + 100000L;
        while (isQueryRunning) {
            if (System.currentTimeMillis() > pollTimeout) {
                System.out.println("Polling timed out");
                break;
            }
            opStatus = client.getOperationStatus(opHandle, false);
            Assert.assertNotNull((Object)opStatus);
            state = opStatus.getState();
            System.out.println("Current state: " + state);
            if (state == OperationState.CANCELED || state == OperationState.CLOSED || state == OperationState.FINISHED || state == OperationState.ERROR) {
                isQueryRunning = false;
            }
            Thread.sleep(1000L);
        }
        Assert.assertEquals((String)"Query should be finished", (Object)OperationState.FINISHED, state);
        queryString = "CREATE TABLE NON_EXISTING_TAB (ID STRING) location 'hdfs://localhost:10000/a/b/c'";
        System.out.println("Will attempt to execute: " + queryString);
        opHandle = client.executeStatementAsync(sessHandle, queryString, opConf);
        Assert.assertNotNull((Object)opHandle);
        opStatus = client.getOperationStatus(opHandle, false);
        Assert.assertNotNull((Object)opStatus);
        isQueryRunning = true;
        pollTimeout = System.currentTimeMillis() + 100000L;
        while (isQueryRunning) {
            if (System.currentTimeMillis() > pollTimeout) {
                System.out.println("Polling timed out");
                break;
            }
            state = opStatus.getState();
            System.out.println("Current state: " + state);
            if (state == OperationState.CANCELED || state == OperationState.CLOSED || state == OperationState.FINISHED || state == OperationState.ERROR) {
                isQueryRunning = false;
            }
            Thread.sleep(1000L);
            opStatus = client.getOperationStatus(opHandle, false);
        }
        Assert.assertEquals((String)"Operation should be in error state", (Object)OperationState.ERROR, (Object)state);
        Assert.assertEquals((Object)opStatus.getOperationException().getSQLState(), (Object)"08S01");
        Assert.assertEquals((long)opStatus.getOperationException().getErrorCode(), (long)40000L);
        queryString = "DROP TABLE TEST_EXEC_ASYNC_THRIFT";
        client.executeStatement(sessHandle, queryString, opConf);
        client.closeSession(sessHandle);
    }
}

