/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.cli.thrift.ThriftHttpFilter;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class TestThriftHttpFilter {
    @Parameterized.Parameter
    public String filterName;
    @Parameterized.Parameter(value=1)
    public boolean isFilterEnabled;
    @Parameterized.Parameter(value=2)
    public String headerName;
    @Parameterized.Parameter(value=3)
    public boolean isHeaderSent;
    @Parameterized.Parameter(value=4)
    public int invokeFilterChaining;
    private HiveConf hiveConf;
    private HttpServletRequest httpServletRequest;
    private HttpServletResponse httpServletResponse;
    private FilterChain filterChain;
    private FilterConfig filterConfig;

    @Parameterized.Parameters(name="{index}: filterName={0},isFilteringEnabled={1},headerName={2},isHeaderSent={3},invokeFilterChaining={4}")
    public static Collection<Object[]> data() {
        return Arrays.asList({HiveConf.ConfVars.HIVE_SERVER2_XSRF_FILTER_ENABLED.varname, true, "X-XSRF-HEADER", true, 1}, {HiveConf.ConfVars.HIVE_SERVER2_XSRF_FILTER_ENABLED.varname, true, "X-XSRF-HEADER", false, 0}, {HiveConf.ConfVars.HIVE_SERVER2_XSRF_FILTER_ENABLED.varname, false, "X-XSRF-HEADER", true, 1}, {HiveConf.ConfVars.HIVE_SERVER2_XSRF_FILTER_ENABLED.varname, false, "X-XSRF-HEADER", false, 1}, {HiveConf.ConfVars.HIVE_SERVER2_CSRF_FILTER_ENABLED.varname, true, "X-CSRF-TOKEN", true, 1}, {HiveConf.ConfVars.HIVE_SERVER2_CSRF_FILTER_ENABLED.varname, true, "X-CSRF-TOKEN", false, 0}, {HiveConf.ConfVars.HIVE_SERVER2_CSRF_FILTER_ENABLED.varname, false, "X-CSRF-TOKEN", true, 1}, {HiveConf.ConfVars.HIVE_SERVER2_CSRF_FILTER_ENABLED.varname, false, "X-CSRF-TOKEN", false, 1});
    }

    @Before
    public void setup() throws IOException {
        this.hiveConf = new HiveConf();
        this.httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.httpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        this.filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)this.httpServletRequest.getRequestURI()).thenReturn((Object)"/cliservice");
        PrintWriter printWriter = (PrintWriter)Mockito.mock(PrintWriter.class);
        Mockito.when((Object)this.httpServletResponse.getWriter()).thenReturn((Object)printWriter);
    }

    private void executeFilter() throws ServletException, IOException {
        ThriftHttpFilter thriftHttpFilter = new ThriftHttpFilter(this.hiveConf);
        thriftHttpFilter.init(this.filterConfig);
        thriftHttpFilter.doFilter((ServletRequest)this.httpServletRequest, (ServletResponse)this.httpServletResponse, this.filterChain);
        thriftHttpFilter.destroy();
    }

    private void initializeFilter() {
        this.hiveConf.setBoolean(this.filterName, this.isFilterEnabled);
        if (this.isHeaderSent) {
            Mockito.when((Object)this.httpServletRequest.getHeader(this.headerName)).thenReturn((Object)this.headerName);
        } else {
            Mockito.when((Object)this.httpServletRequest.getHeader(this.headerName)).thenReturn(null);
        }
    }

    @Test
    public void testFilter() throws ServletException, IOException {
        this.initializeFilter();
        this.executeFilter();
        ((FilterChain)Mockito.verify((Object)this.filterChain, (VerificationMode)Mockito.times((int)this.invokeFilterChaining))).doFilter((ServletRequest)this.httpServletRequest, (ServletResponse)this.httpServletResponse);
    }
}

