/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import java.io.IOException;
import java.net.ServerSocket;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hive.service.cli.thrift.ThriftCLIServiceClient;
import org.apache.hive.service.server.HiveServer2;
import org.junit.AfterClass;

public abstract class AbstractThriftCLITest {
    protected static int port;
    protected static HiveServer2 hiveServer2;
    protected static HiveConf hiveConf;
    protected static String host;
    protected static ThriftCLIServiceClient client;
    protected static String USERNAME;
    protected static String PASSWORD;
    protected static final int RETRY_COUNT = 10;

    public static void initConf(Class<?> cls) throws Exception {
        port = AbstractThriftCLITest.findFreePort();
        hiveServer2 = new HiveServer2();
        hiveConf = new HiveConfForTest(cls);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        AbstractThriftCLITest.stopHiveServer2();
    }

    public static void startHiveServer2WithConf(HiveConf hiveConf) throws Exception {
        Exception hs2Exception = null;
        boolean hs2Started = false;
        for (int tryCount = 0; tryCount < 10; ++tryCount) {
            try {
                hiveServer2 = new HiveServer2();
                hiveServer2.init(hiveConf);
                hiveServer2.start();
                Thread.sleep(5000L);
                hs2Started = true;
                break;
            }
            catch (Exception e) {
                hs2Exception = e;
                HiveConf.setIntVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT, (int)AbstractThriftCLITest.findFreePort());
                HiveConf.setIntVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PORT, (int)AbstractThriftCLITest.findFreePort());
                HiveConf.setIntVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT, (int)AbstractThriftCLITest.findFreePortExcepting(Integer.valueOf(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT.getDefaultValue())));
                continue;
            }
        }
        if (!hs2Started) {
            throw hs2Exception;
        }
        System.out.println("HiveServer2 started on port " + port);
    }

    public static void stopHiveServer2() throws Exception {
        if (hiveServer2 != null) {
            hiveServer2.stop();
        }
    }

    public static int findFreePort() throws IOException {
        ServerSocket socket = new ServerSocket(0);
        int port = socket.getLocalPort();
        socket.close();
        return port;
    }

    public static int findFreePortExcepting(int portToExclude) throws IOException {
        try (ServerSocket socket1 = new ServerSocket(0);){
            ServerSocket socket2;
            block12: {
                int n;
                socket2 = new ServerSocket(0);
                try {
                    if (socket1.getLocalPort() == portToExclude) break block12;
                    n = socket1.getLocalPort();
                }
                catch (Throwable throwable) {
                    try {
                        socket2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                socket2.close();
                return n;
            }
            int n = socket2.getLocalPort();
            socket2.close();
            return n;
        }
    }

    static {
        host = "localhost";
        USERNAME = "anonymous";
        PASSWORD = "anonymous";
    }
}

