/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import java.util.HashMap;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.IPStackUtils;
import org.apache.hadoop.hive.common.metrics.MetricsTestUtils;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.metrics2.CodahaleMetrics;
import org.apache.hadoop.hive.common.metrics.metrics2.MetricsReporting;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.MetadataOperation;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.SessionManager;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;

public class TestSessionManagerMetrics {
    private static SessionManager sm;
    private static CodahaleMetrics metrics;
    private static final int BARRIER_AWAIT_TIMEOUT = 30;
    private static final String FAIL_TO_START_MSG = "The tasks could not be started within 30 seconds before the %s metrics verification.";
    private static final String FAIL_TO_COMPLETE_MSG = "The tasks could not be completed within 30 seconds after the %s metrics verification.";

    @Before
    public void setup() throws Exception {
        HiveConf conf = new HiveConf();
        conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_THREADS, 2);
        conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_WAIT_QUEUE_SIZE, 10);
        conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_KEEPALIVE_TIME, "1000000s");
        conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_IDLE_SESSION_TIMEOUT, "500ms");
        conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_SESSION_CHECK_INTERVAL, "3s");
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_METRICS_ENABLED, true);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, false);
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_REPORTER, MetricsReporting.JSON_FILE.name() + "," + MetricsReporting.JMX.name());
        conf.setBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_METADATA_QUERIES, false);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_ENABLED, false);
        MetricsFactory.init((Configuration)conf);
        sm = new SessionManager(null, true);
        sm.init(conf);
        metrics = (CodahaleMetrics)MetricsFactory.getInstance();
        Hive doNothingHive = (Hive)Mockito.mock(Hive.class);
        Hive.set((Hive)doNothingHive);
    }

    @Test
    public void testThreadPoolMetrics() throws Exception {
        String errorMessage = null;
        CyclicBarrier ready = new CyclicBarrier(3);
        CyclicBarrier completed = new CyclicBarrier(3);
        try {
            sm.submitBackgroundOperation((Runnable)new BarrierRunnable(ready, completed));
            sm.submitBackgroundOperation((Runnable)new BarrierRunnable(ready, completed));
            sm.submitBackgroundOperation((Runnable)new BarrierRunnable(ready, completed));
            sm.submitBackgroundOperation((Runnable)new BarrierRunnable(ready, completed));
            errorMessage = String.format(FAIL_TO_START_MSG, "first");
            ready.await(30L, TimeUnit.SECONDS);
            ready.reset();
            String json = metrics.dumpJson();
            MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.GAUGE, (String)"exec_async_pool_size", (Object)2);
            MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.GAUGE, (String)"exec_async_queue_size", (Object)2);
            errorMessage = String.format(FAIL_TO_COMPLETE_MSG, "first");
            completed.await(30L, TimeUnit.SECONDS);
            completed.reset();
            errorMessage = String.format(FAIL_TO_START_MSG, "second");
            ready.await(30L, TimeUnit.SECONDS);
            json = metrics.dumpJson();
            MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.GAUGE, (String)"exec_async_pool_size", (Object)2);
            MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.GAUGE, (String)"exec_async_queue_size", (Object)0);
            errorMessage = String.format(FAIL_TO_COMPLETE_MSG, "second");
            completed.await(30L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            Assert.fail(errorMessage);
        }
    }

    @Test
    public void testOpenSessionMetrics() throws Exception {
        String json = metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.GAUGE, (String)"hs2_open_sessions", (Object)0);
        SessionHandle handle = sm.openSession(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V9, "user", "passw", IPStackUtils.resolveLoopbackAddress(), new HashMap());
        json = metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.GAUGE, (String)"hs2_open_sessions", (Object)1);
        sm.openSession(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V9, "user", "passw", IPStackUtils.resolveLoopbackAddress(), new HashMap());
        json = metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.GAUGE, (String)"hs2_open_sessions", (Object)2);
        sm.closeSession(handle);
        json = metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.GAUGE, (String)"hs2_open_sessions", (Object)1);
    }

    @Test
    public void testOpenSessionTimeMetrics() throws Exception {
        String json = metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.GAUGE, (String)"hs2_avg_open_session_time", (Object)"NaN");
        long firstSessionOpen = System.currentTimeMillis();
        SessionHandle handle = sm.openSession(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V9, "user", "passw", IPStackUtils.resolveLoopbackAddress(), new HashMap());
        json = metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.GAUGE, (String)"hs2_avg_open_session_time", (Double)Double.valueOf(System.currentTimeMillis() - firstSessionOpen), (Double)100.0);
        long secondSessionOpen = System.currentTimeMillis();
        sm.openSession(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V9, "user", "passw", IPStackUtils.resolveLoopbackAddress(), new HashMap());
        json = metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.GAUGE, (String)"hs2_avg_open_session_time", (Double)((double)(System.currentTimeMillis() - firstSessionOpen + System.currentTimeMillis() - secondSessionOpen) / 2.0), (Double)100.0);
        sm.closeSession(handle);
        json = metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.GAUGE, (String)"hs2_avg_open_session_time", (Double)Double.valueOf(System.currentTimeMillis() - secondSessionOpen), (Double)100.0);
    }

    @Ignore(value="HIVE-26039")
    @Test
    public void testActiveSessionMetrics() throws Exception {
        final CyclicBarrier ready = new CyclicBarrier(2);
        CyclicBarrier completed = new CyclicBarrier(2);
        String json = metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.GAUGE, (String)"hs2_active_sessions", (Object)0);
        SessionHandle handle = sm.openSession(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V9, "user", "passw", IPStackUtils.resolveLoopbackAddress(), new HashMap());
        final HiveSession session = sm.getSession(handle);
        OperationManager operationManager = (OperationManager)Mockito.mock(OperationManager.class);
        Mockito.when((Object)operationManager.newGetTablesOperation(session, "catalog", "schema", "table", null)).thenReturn((Object)new BlockingOperation(session, OperationType.GET_TABLES, ready, completed));
        session.setOperationManager(operationManager);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Hive.set((Hive)session.getSessionHive());
                    OperationHandle handle = session.getTables("catalog", "schema", "table", null);
                    session.closeOperation(handle);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        ready.await();
                    }
                    catch (InterruptedException | BrokenBarrierException exception) {}
                }
            }
        }).start();
        ready.await(2L, TimeUnit.SECONDS);
        ready.reset();
        json = metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.GAUGE, (String)"hs2_active_sessions", (Object)1);
        completed.await(2L, TimeUnit.SECONDS);
        ready.await(2L, TimeUnit.SECONDS);
        json = metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.GAUGE, (String)"hs2_active_sessions", (Object)0);
    }

    @Test
    public void testActiveSessionTimeMetrics() throws Exception {
        final CyclicBarrier ready = new CyclicBarrier(2);
        CyclicBarrier completed = new CyclicBarrier(2);
        String json = metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.GAUGE, (String)"hs2_avg_active_session_time", (Object)"NaN");
        SessionHandle handle = sm.openSession(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V9, "user", "passw", IPStackUtils.resolveLoopbackAddress(), new HashMap());
        final HiveSession session = sm.getSession(handle);
        OperationManager operationManager = (OperationManager)Mockito.mock(OperationManager.class);
        Mockito.when((Object)operationManager.newGetTablesOperation(session, "catalog", "schema", "table", null)).thenReturn((Object)new BlockingOperation(session, OperationType.GET_TABLES, ready, completed));
        session.setOperationManager(operationManager);
        long sessionActivateTime = System.currentTimeMillis();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Hive.set((Hive)session.getSessionHive());
                    OperationHandle handle = session.getTables("catalog", "schema", "table", null);
                    session.closeOperation(handle);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        ready.await();
                    }
                    catch (InterruptedException | BrokenBarrierException exception) {}
                }
            }
        }).start();
        ready.await(2L, TimeUnit.SECONDS);
        ready.reset();
        json = metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.GAUGE, (String)"hs2_avg_active_session_time", (Double)((double)System.currentTimeMillis() - (double)sessionActivateTime), (Double)100.0);
        completed.await(2L, TimeUnit.SECONDS);
        ready.await(2L, TimeUnit.SECONDS);
        json = metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.GAUGE, (String)"hs2_avg_active_session_time", (Object)"NaN");
    }

    @Test
    public void testAbandonedSessionMetrics() throws Exception {
        String currentValue;
        sm.start();
        String json = metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.COUNTER, (String)"hs2_abandoned_sessions", (Object)"");
        sm.openSession(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V9, "user", "passw", IPStackUtils.resolveLoopbackAddress(), new HashMap());
        int count = 10;
        String expectedValue = "1";
        do {
            Thread.sleep(3200L);
        } while (!expectedValue.equals(currentValue = MetricsTestUtils.getJsonNode((String)(json = metrics.dumpJson()), (MetricsTestUtils.MetricsCategory)MetricsTestUtils.COUNTER, (String)"hs2_abandoned_sessions").asText()) && --count > 0);
        Assert.assertEquals((Object)expectedValue, (Object)currentValue);
    }

    class BarrierRunnable
    implements Runnable {
        private final CyclicBarrier ready;
        private final CyclicBarrier completed;

        BarrierRunnable(CyclicBarrier ready, CyclicBarrier completed) {
            this.ready = ready;
            this.completed = completed;
        }

        @Override
        public void run() {
            try {
                this.ready.await();
                this.completed.await();
            }
            catch (InterruptedException | BrokenBarrierException e) {
                throw new RuntimeException(e);
            }
        }
    }

    class BlockingOperation
    extends MetadataOperation {
        private final CyclicBarrier ready;
        private final CyclicBarrier completed;

        BlockingOperation(HiveSession parentSession, OperationType opType, CyclicBarrier ready, CyclicBarrier completed) {
            super(parentSession, opType);
            this.ready = ready;
            this.completed = completed;
        }

        protected void runInternal() throws HiveSQLException {
            try {
                this.ready.await();
                this.completed.await();
            }
            catch (InterruptedException | BrokenBarrierException e) {
                throw new RuntimeException(e);
            }
        }

        public TableSchema getResultSetSchema() throws HiveSQLException {
            return null;
        }

        public RowSet getNextRowSet(FetchOrientation orientation, long maxRows) throws HiveSQLException {
            return null;
        }
    }
}

