/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.thrift.EmbeddedThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIServiceClient;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.junit.Assert;
import org.junit.Test;

public class TestSessionCleanup {
    private static final AtomicInteger salt = new AtomicInteger(new Random().nextInt());
    private final String TEST_DATA_DIR = System.getProperty("java.io.tmpdir") + File.separator + TestSessionCleanup.class.getCanonicalName() + "-" + System.currentTimeMillis() + "_" + salt.getAndIncrement();

    @Test
    public void testTempSessionFileCleanup() throws Exception {
        MyEmbeddedThriftBinaryCLIService service = new MyEmbeddedThriftBinaryCLIService();
        HiveConf hiveConf = new HiveConf();
        hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_LOG_LOCATION, this.TEST_DATA_DIR + File.separator + "operation_logs");
        service.init(hiveConf);
        ThriftCLIServiceClient client = new ThriftCLIServiceClient((TCLIService.Iface)service);
        HashSet<String> existingPipeoutFiles = new HashSet<String>(Arrays.asList(this.getPipeoutFiles(hiveConf)));
        SessionHandle sessionHandle = client.openSession("user1", "foobar", Collections.emptyMap());
        OperationHandle opHandle1 = client.executeStatement(sessionHandle, "set a=b", null);
        String queryId1 = service.getCliService().getQueryId(opHandle1.toTOperationHandle());
        Assert.assertNotNull((Object)queryId1);
        OperationHandle opHandle2 = client.executeStatement(sessionHandle, "set b=c", null);
        String queryId2 = service.getCliService().getQueryId(opHandle2.toTOperationHandle());
        Assert.assertNotNull((Object)queryId2);
        File operationLogRootDir = new File(hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_LOG_LOCATION));
        Assert.assertNotEquals((long)0L, (long)operationLogRootDir.list().length);
        client.closeSession(sessionHandle);
        Assert.assertEquals((long)0L, (long)operationLogRootDir.list().length);
        HashSet<String> finalPipeoutFiles = new HashSet<String>(Arrays.asList(this.getPipeoutFiles(hiveConf)));
        finalPipeoutFiles.removeAll(existingPipeoutFiles);
        Assert.assertTrue((boolean)finalPipeoutFiles.isEmpty());
        Assert.assertEquals((long)0L, (long)service.getCliService().getSessionManager().getOperations().size());
        Assert.assertNull((Object)service.getCliService().getSessionManager().getOperationManager().getOperationByQueryId(queryId2));
        Assert.assertNull((Object)service.getCliService().getSessionManager().getOperationManager().getOperationByQueryId(queryId1));
    }

    private String[] getPipeoutFiles(HiveConf hiveConf) {
        File localScratchDir = new File(hiveConf.getVar(HiveConf.ConfVars.LOCAL_SCRATCH_DIR));
        String[] pipeoutFiles = localScratchDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("pipeout");
            }
        });
        return pipeoutFiles;
    }

    private class MyEmbeddedThriftBinaryCLIService
    extends EmbeddedThriftBinaryCLIService {
        public CLIService getCliService() {
            return this.cliService;
        }
    }
}

