/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.util.ShutdownHookManagerInspector;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationStatus;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.thrift.EmbeddedThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIServiceClient;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestQueryShutdownHooks {
    private static final long ASYNC_QUERY_TIMEOUT_MS = 600000L;
    private EmbeddedThriftBinaryCLIService service;
    private ThriftCLIServiceClient client;
    private SessionHandle sessionHandle;
    private final Map<String, String> confOverlay = new HashMap<String, String>();

    @Before
    public void setUp() throws Exception {
        this.service = new EmbeddedThriftBinaryCLIService();
        HiveConfForTest hiveConf = new HiveConfForTest(this.getClass());
        hiveConf.setVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE, "mr");
        hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS, false);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_LOCK_MANAGER, "org.apache.hadoop.hive.ql.lockmgr.EmbeddedLockManager");
        this.service.init((HiveConf)hiveConf);
        this.client = new ThriftCLIServiceClient((TCLIService.Iface)this.service);
        this.sessionHandle = this.client.openSession("anonymous", "anonymous", new HashMap());
        this.client.executeStatement(this.sessionHandle, "select reflect(\"java.lang.System\", \"currentTimeMillis\")", new HashMap());
    }

    @After
    public void cleanup() throws HiveSQLException {
        if (this.sessionHandle != null) {
            this.client.closeSession(this.sessionHandle);
        }
        this.service.stop();
    }

    @Test
    public void testSync() throws Exception {
        String[] someQueries;
        int shutdownHooksBeforeQueries = ShutdownHookManagerInspector.getShutdownHookCount();
        for (String queryStr : someQueries = new String[]{"CREATE TABLE sample_shutdown_hook (sample_id int, sample_value string)", "INSERT INTO sample_shutdown_hook VALUES (1, 'a')", "INSERT INTO sample_shutdown_hook VALUES (2, 'b')", "INSERT INTO sample_shutdown_hook VALUES (3, 'c')", "INSERT INTO sample_shutdown_hook VALUES (4, 'd')", "INSERT INTO sample_shutdown_hook VALUES (5, 'e')", "INSERT INTO sample_shutdown_hook VALUES (6, 'f')", "INSERT INTO sample_shutdown_hook VALUES (7, 'g')", "SELECT * FROM sample_shutdown_hook", "DROP TABLE sample_shutdown_hook"}) {
            OperationHandle opHandle = this.client.executeStatement(this.sessionHandle, queryStr, this.confOverlay);
            Assert.assertNotNull((Object)opHandle);
            OperationStatus opStatus = this.client.getOperationStatus(opHandle, false);
            Assert.assertNotNull((Object)opStatus);
            OperationState state = opStatus.getState();
            Assert.assertEquals((String)"Query should be finished", (Object)OperationState.FINISHED, (Object)state);
        }
        int expectedHooks = shutdownHooksBeforeQueries;
        ShutdownHookManagerInspector.assertShutdownHookCount(expectedHooks);
    }

    @Test
    public void testAsync() throws Exception {
        int shutdownHooksBeforeQueries = ShutdownHookManagerInspector.getShutdownHookCount();
        String[] someQueries = new String[]{"select reflect(\"java.lang.Thread\", \"sleep\", bigint(1000))", "select reflect(\"java.lang.Thread\", \"sleep\", bigint(1000))", "select reflect(\"java.lang.Thread\", \"sleep\", bigint(1000))", "select reflect(\"java.lang.Thread\", \"sleep\", bigint(1000))"};
        ArrayList<OperationHandle> operationHandles = new ArrayList<OperationHandle>();
        for (String queryStr : someQueries) {
            OperationHandle opHandle = this.client.executeStatementAsync(this.sessionHandle, queryStr, this.confOverlay);
            Assert.assertNotNull((Object)opHandle);
            operationHandles.add(opHandle);
        }
        boolean allComplete = false;
        long step = 200L;
        long timeout = System.currentTimeMillis() + 600000L;
        block1: while (!allComplete) {
            allComplete = true;
            for (OperationHandle opHandle : operationHandles) {
                OperationStatus operationStatus = this.client.getOperationStatus(opHandle, false);
                if (operationStatus.getState() == OperationState.FINISHED) continue;
                if (System.currentTimeMillis() > timeout) {
                    Assert.fail((String)"Queries did not complete timely");
                }
                allComplete = false;
                Thread.sleep(200L);
                continue block1;
            }
        }
        ShutdownHookManagerInspector.assertShutdownHookCount(shutdownHooksBeforeQueries);
    }

    @Test
    public void testShutdownHookManagerIsRegistered() throws HiveSQLException, InterruptedException {
        OperationStatus operationStatus;
        int shutdownHooksBeforeQuery = ShutdownHookManagerInspector.getShutdownHookCount();
        String queryStr = "select reflect(\"java.lang.Thread\", \"sleep\", bigint(5000))";
        OperationHandle opHandle = this.client.executeStatementAsync(this.sessionHandle, queryStr, this.confOverlay);
        Assert.assertNotNull((Object)opHandle);
        ShutdownHookManagerInspector.assertShutdownHookCount(shutdownHooksBeforeQuery + 1);
        long step = 200L;
        long timeout = System.currentTimeMillis() + 600000L;
        while ((operationStatus = this.client.getOperationStatus(opHandle, false)).getState() != OperationState.FINISHED) {
            if (System.currentTimeMillis() > timeout) {
                Assert.fail((String)"Query did not complete timely");
            }
            Thread.sleep(200L);
        }
        ShutdownHookManagerInspector.assertShutdownHookCount(shutdownHooksBeforeQuery);
    }
}

