/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHookContext;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHookWithParseHooks;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.service.cli.HandleIdentifier;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.operation.SQLOperation;
import org.apache.hive.service.cli.session.HiveSession;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestQueryLifeTimeHooksWithSQLOperation {
    private static final String QUERY = "select 1";

    @Test
    public void testQueryInfoInHookContext() throws IllegalAccessException, ClassNotFoundException, InstantiationException, HiveSQLException {
        HiveConfForTest conf = new HiveConfForTest(this.getClass());
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, false);
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        conf.set(HiveConf.ConfVars.HIVE_QUERY_LIFETIME_HOOKS.varname, QueryInfoVerificationHook.class.getName());
        SessionState.start((HiveConf)conf);
        HiveSession mockHiveSession = (HiveSession)Mockito.mock(HiveSession.class);
        Mockito.when((Object)mockHiveSession.getHiveConf()).thenReturn((Object)conf);
        Mockito.when((Object)mockHiveSession.getSessionState()).thenReturn((Object)SessionState.get());
        SessionHandle sessionHandle = (SessionHandle)Mockito.mock(SessionHandle.class);
        Mockito.when((Object)sessionHandle.getHandleIdentifier()).thenReturn((Object)new HandleIdentifier());
        Mockito.when((Object)mockHiveSession.getSessionHandle()).thenReturn((Object)sessionHandle);
        SQLOperation sqlOperation = new SQLOperation(mockHiveSession, QUERY, (Map)ImmutableMap.of(), false, 0L);
        sqlOperation.run();
    }

    public static final class QueryInfoVerificationHook
    implements QueryLifeTimeHookWithParseHooks {
        public void beforeParse(QueryLifeTimeHookContext ctx) {
            Assert.assertNotNull((Object)ctx);
            Assert.assertEquals((Object)ctx.getCommand().trim(), (Object)TestQueryLifeTimeHooksWithSQLOperation.QUERY);
        }

        public void afterParse(QueryLifeTimeHookContext ctx, boolean hasError) {
            Assert.assertNotNull((Object)ctx);
            Assert.assertEquals((Object)ctx.getCommand().trim(), (Object)TestQueryLifeTimeHooksWithSQLOperation.QUERY);
            Assert.assertFalse((boolean)hasError);
        }

        public void beforeCompile(QueryLifeTimeHookContext ctx) {
            Assert.assertNotNull((Object)ctx);
            Assert.assertEquals((Object)ctx.getCommand().trim(), (Object)TestQueryLifeTimeHooksWithSQLOperation.QUERY);
        }

        public void afterCompile(QueryLifeTimeHookContext ctx, boolean hasError) {
            Assert.assertNotNull((Object)ctx);
            Assert.assertEquals((Object)ctx.getCommand().trim(), (Object)TestQueryLifeTimeHooksWithSQLOperation.QUERY);
            Assert.assertFalse((boolean)hasError);
        }

        public void beforeExecution(QueryLifeTimeHookContext ctx) {
            Assert.assertNotNull((Object)ctx);
            Assert.assertEquals((Object)ctx.getCommand().trim(), (Object)TestQueryLifeTimeHooksWithSQLOperation.QUERY);
            Assert.assertNotNull((Object)ctx.getHookContext());
            Assert.assertNotNull((Object)ctx.getHookContext().getQueryInfo());
            Assert.assertNotNull((Object)ctx.getHookContext().getQueryInfo().getQueryDisplay());
        }

        public void afterExecution(QueryLifeTimeHookContext ctx, boolean hasError) {
            Assert.assertNotNull((Object)ctx);
            Assert.assertEquals((Object)ctx.getCommand().trim(), (Object)TestQueryLifeTimeHooksWithSQLOperation.QUERY);
            Assert.assertFalse((boolean)hasError);
            Assert.assertNotNull((Object)ctx.getHookContext());
            Assert.assertNull((Object)ctx.getHookContext().getErrorMessage());
            Assert.assertNull((Object)ctx.getHookContext().getException());
            Assert.assertNotNull((Object)ctx.getHookContext().getQueryInfo());
            Assert.assertNotNull((Object)ctx.getHookContext().getQueryInfo().getQueryDisplay());
        }
    }
}

