/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.IPStackUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryInfo;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.operation.OperationLogManager;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.hive.service.cli.operation.SQLOperation;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.HiveSessionImpl;
import org.apache.hive.service.cli.session.SessionManager;
import org.apache.hive.service.cli.thrift.EmbeddedThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIServiceClient;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestOperationLogManager {
    private static final AtomicInteger salt = new AtomicInteger(new Random().nextInt());
    private final String TEST_DATA_DIR = System.getProperty("java.io.tmpdir") + File.separator + TestOperationLogManager.class.getCanonicalName() + "-" + System.currentTimeMillis() + "_" + salt.getAndIncrement();
    private HiveConf hiveConf;

    @Before
    public void setUp() throws Exception {
        this.hiveConf = new HiveConf();
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_HISTORIC_OPERATION_LOG_ENABLED, (boolean)true);
        HiveConf.setIntVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_WEBUI_MAX_HISTORIC_QUERIES, (int)1);
        HiveConf.setIntVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_WEBUI_PORT, (int)8080);
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TESTING_REMOVE_LOGS, (boolean)false);
        HiveConf.setVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_HISTORIC_OPERATION_LOG_FETCH_MAXBYTES, (String)"128B");
        HiveConf.setBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        HiveConf.setVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_LOG_LOCATION, (String)(this.TEST_DATA_DIR + File.separator + "operation_logs"));
        HiveConf.setVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, (String)"org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
    }

    @Test
    public void testOperationLogManager() throws Exception {
        MyThriftBinaryCLIService service = new MyThriftBinaryCLIService();
        service.init(this.hiveConf);
        ThriftCLIServiceClient client = new ThriftCLIServiceClient((TCLIService.Iface)service);
        SessionManager sessionManager = ((CLIService)service.getService()).getSessionManager();
        SessionHandle session1 = client.openSession("user1", "foobar", Collections.emptyMap());
        OperationHandle opHandle1 = client.executeStatement(session1, "select 1 + 1", null);
        Operation operation1 = sessionManager.getOperationManager().getOperation(opHandle1);
        String logLocation = operation1.getOperationLog().toString();
        Assert.assertEquals((Object)logLocation, (Object)((SQLOperation)operation1).getQueryInfo().getOperationLogLocation());
        File operationLogFile = new File(operation1.getOperationLog().toString());
        Assert.assertTrue((boolean)operationLogFile.exists());
        client.closeOperation(opHandle1);
        String op1HistoricLogLocation = ((SQLOperation)operation1).getQueryInfo().getOperationLogLocation();
        File op1HistoricLogFile = new File(op1HistoricLogLocation);
        Assert.assertTrue((boolean)op1HistoricLogFile.exists());
        client.closeSession(session1);
        Assert.assertTrue((boolean)op1HistoricLogFile.exists());
        SessionHandle session2 = client.openSession("user1", "foobar", Collections.emptyMap());
        OperationHandle opHandle2 = client.executeStatement(session2, "select 2 + 2", null);
        Operation operation2 = sessionManager.getOperationManager().getOperation(opHandle2);
        client.closeOperation(opHandle2);
        OperationManager operationManager = sessionManager.getOperationManager();
        Assert.assertTrue((operationManager.getAllCachedQueryIds().size() == 1 && operationManager.getLiveQueryInfos().isEmpty() ? 1 : 0) != 0);
        Assert.assertNull((Object)operationManager.getQueryInfo(opHandle1.getHandleIdentifier().toString()));
        OperationLogManager logManager = (OperationLogManager)sessionManager.getLogManager().get();
        logManager.deleteHistoricQueryLogs();
        Assert.assertFalse((boolean)op1HistoricLogFile.exists());
        String op2LogLocation = ((SQLOperation)operation2).getQueryInfo().getOperationLogLocation();
        client.closeSession(session2);
        Assert.assertNotNull((Object)operationManager.getQueryInfo(opHandle2.getHandleIdentifier().toString()));
        Assert.assertTrue((operationManager.getAllCachedQueryIds().size() == 1 && operationManager.getLiveQueryInfos().isEmpty() ? 1 : 0) != 0);
        logManager.deleteHistoricQueryLogs();
        Assert.assertTrue((boolean)new File(op2LogLocation).exists());
        FileUtils.deleteQuietly((File)new File(OperationLogManager.getHistoricLogDir()));
    }

    @Test
    public void testGetOperationLog() throws Exception {
        FakeHiveSession session = new FakeHiveSession(new SessionHandle(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V11), new HiveConf(this.hiveConf));
        session.setOperationLogSessionDir(new File(HiveConf.getVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_LOG_LOCATION)));
        session.open(new HashMap());
        FakeSQLOperation operation = new FakeSQLOperation((HiveSession)session);
        operation.createOperationLog();
        String logLocation = operation.getOperationLog().toString();
        File logFile = new File(logLocation);
        int readLenght = (int)HiveConf.getSizeVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_HISTORIC_OPERATION_LOG_FETCH_MAXBYTES);
        byte[] content = this.writeBytes(logFile, 2 * readLenght);
        operation.getQueryInfo().setOperationLogLocation(logLocation);
        String operationLog = OperationLogManager.getOperationLog((QueryInfo)operation.getQueryInfo());
        Assert.assertEquals((Object)logLocation, (Object)operation.getQueryInfo().getOperationLogLocation());
        Assert.assertEquals((Object)new String(content, content.length - readLenght, readLenght), (Object)operationLog);
        FileUtils.deleteQuietly((File)new File(OperationLogManager.getHistoricLogDir()));
    }

    private byte[] writeBytes(File logFile, int maxBytes) throws Exception {
        byte[] result;
        byte[] samples = ("abcdefghigklmnopq" + System.lineSeparator()).getBytes();
        try (FileOutputStream fos = new FileOutputStream(logFile, true);
             ByteArrayOutputStream baos = new ByteArrayOutputStream(maxBytes);){
            for (int written = 0; written < maxBytes; written += samples.length) {
                fos.write(samples);
                baos.write(samples);
            }
            result = baos.toByteArray();
        }
        return result;
    }

    private class MyThriftBinaryCLIService
    extends EmbeddedThriftBinaryCLIService {
        public MyThriftBinaryCLIService() {
            this.isEmbedded = false;
        }
    }

    private class FakeHiveSession
    extends HiveSessionImpl {
        public FakeHiveSession(SessionHandle sessionHandle, HiveConf serverConf) {
            super(sessionHandle, TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V11, "dummy", "", serverConf, IPStackUtils.resolveWildcardAddress(), null);
        }
    }

    private class FakeSQLOperation
    extends SQLOperation {
        public FakeSQLOperation(HiveSession parentSession) {
            super(parentSession, "select 1", new HashMap(), true, 0L);
        }
    }
}

