/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hive.common.io.SessionStream;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.ShowProcessListProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.operation.ShowProcessListOperation;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.SessionManager;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHiveCommandOpForProcessList {
    private static HiveConf hiveConf;
    private ByteArrayOutputStream baos;
    private static SessionState state;
    private SessionManager sessionManager;
    private ShowProcessListProcessor processor;

    @Before
    public void setupTest() throws Exception {
        hiveConf = new HiveConfForTest(this.getClass());
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, false);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        this.processor = new ShowProcessListProcessor();
        this.sessionManager = new SessionManager(null, true);
        this.sessionManager.init(hiveConf);
        this.sessionManager.start();
    }

    public void setCurrentSession() {
        SessionState.start((HiveConf)hiveConf);
        state = SessionState.get();
        this.baos = new ByteArrayOutputStream();
        TestHiveCommandOpForProcessList.state.out = new SessionStream((OutputStream)this.baos);
    }

    @Test
    public void testRunningQueryDisplay() throws HiveSQLException {
        HiveSession session1 = this.sessionManager.createSession(new SessionHandle(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V8), TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V8, "hive_test_user1", "", "10.128.00.78", new HashMap(), false, "");
        HiveSession session2 = this.sessionManager.createSession(new SessionHandle(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V8), TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V8, "hive_test_user2", "", "10.128.00.78", new HashMap(), false, "");
        CompletableFuture.runAsync(() -> {
            try {
                OperationHandle opHandle1 = session1.executeStatement("show databases", null);
                OperationHandle opHandle2 = session2.executeStatement("create table test_orc(key string,value string)", null);
                session1.closeOperation(opHandle1);
                session2.closeOperation(opHandle2);
            }
            catch (HiveSQLException e) {
                throw new RuntimeException(e);
            }
        });
        String query = "show processlist";
        this.setCurrentSession();
        ShowProcessListOperation sqlOperation = new ShowProcessListOperation(session2, query, (CommandProcessor)this.processor, (Map)ImmutableMap.of());
        sqlOperation.run();
        TestHiveCommandOpForProcessList.state.out.flush();
        String output = this.baos.toString();
        if (output != null && !output.isEmpty()) {
            Assert.assertTrue((output.contains(session1.getSessionHandle().getHandleIdentifier().toString()) || output.contains(session2.getSessionHandle().getHandleIdentifier().toString()) ? 1 : 0) != 0);
        }
        session1.close();
        session2.close();
    }
}

