/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.DfsProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.operation.HiveCommandOperation;
import org.apache.hive.service.cli.session.HiveSession;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCommandWithSpace {
    @Test
    public void testCommandWithPrefixSpace() throws IllegalAccessException, ClassNotFoundException, InstantiationException, HiveSQLException {
        String query = " dfs -ls /";
        HiveConfForTest conf = new HiveConfForTest(this.getClass());
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, false);
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        SessionState.start((HiveConf)conf);
        HiveSession mockHiveSession = (HiveSession)Mockito.mock(HiveSession.class);
        Mockito.when((Object)mockHiveSession.getHiveConf()).thenReturn((Object)conf);
        Mockito.when((Object)mockHiveSession.getSessionState()).thenReturn((Object)SessionState.get());
        DfsProcessor dfsProcessor = new DfsProcessor(new Configuration());
        HiveCommandOperation sqlOperation = new HiveCommandOperation(mockHiveSession, query, (CommandProcessor)dfsProcessor, (Map)ImmutableMap.of());
        sqlOperation.run();
    }
}

