/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.apache.hadoop.hive.common.IPStackUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveServer2TransportMode;
import org.apache.hive.service.Service;
import org.apache.hive.service.auth.HiveAuthConstants;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.CLIServiceClient;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.ICLIService;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.thrift.AbstractThriftCLITest;
import org.apache.hive.service.cli.thrift.RetryingThriftCLIServiceClient;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRetryingThriftCLIServiceClient
extends AbstractThriftCLITest {
    protected static ThriftCLIService service;

    @BeforeClass
    public static void init() throws Exception {
        TestRetryingThriftCLIServiceClient.initConf(TestRetryingThriftCLIServiceClient.class);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST, "localhost");
        hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT, 15000);
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS, false);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION, HiveAuthConstants.AuthTypes.NONE.toString());
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE, HiveServer2TransportMode.binary.toString());
        hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_CLIENT_RETRY_LIMIT, 3);
        hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_CLIENT_CONNECTION_RETRY_LIMIT, 3);
        hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_THREADS, 10);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_SHUTDOWN_TIMEOUT, "1s");
        hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_QUERY_HISTORY_ENABLED, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRetryBehaviour() throws Exception {
        TestRetryingThriftCLIServiceClient.startHiveServer2WithConf(hiveConf);
        int thriftPort = hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT);
        hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT, 17000);
        try {
            RetryingThriftCLIServiceClientTest.newRetryingCLIServiceClient(hiveConf);
            Assert.fail((String)"Expected to throw exception for invalid port");
        }
        catch (HiveSQLException sqlExc) {
            Assert.assertTrue((boolean)(sqlExc.getCause() instanceof TTransportException));
            Assert.assertTrue((boolean)sqlExc.getMessage().contains("3"));
        }
        hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT, thriftPort);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST, IPStackUtils.transformToIPv6((String)"10.17.207.11"));
        try {
            RetryingThriftCLIServiceClientTest.newRetryingCLIServiceClient(hiveConf);
            Assert.fail((String)"Expected to throw exception for invalid host");
        }
        catch (HiveSQLException sqlExc) {
            Assert.assertTrue((boolean)(sqlExc.getCause() instanceof TTransportException));
            Assert.assertTrue((boolean)sqlExc.getMessage().contains("3"));
        }
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST, IPStackUtils.resolveLoopbackAddress());
        RetryingThriftCLIServiceClient.CLIServiceClientWrapper cliServiceClient = RetryingThriftCLIServiceClientTest.newRetryingCLIServiceClient(hiveConf);
        System.out.println("## Created client");
        TestRetryingThriftCLIServiceClient.stopHiveServer2();
        Thread.sleep(5000L);
        try {
            RetryingThriftCLIServiceClientTest.handlerInst.callCount = 0;
            RetryingThriftCLIServiceClientTest.handlerInst.connectCount = 0;
            cliServiceClient.openSession("anonymous", "anonymous");
        }
        catch (HiveSQLException exc) {
            exc.printStackTrace();
            if (exc.getCause() instanceof TException) {
                Assert.assertEquals((long)1L, (long)RetryingThriftCLIServiceClientTest.handlerInst.callCount);
                Assert.assertEquals((long)3L, (long)RetryingThriftCLIServiceClientTest.handlerInst.connectCount);
            }
        }
        finally {
            cliServiceClient.closeTransport();
        }
    }

    @Test
    public void testTransportClose() throws Exception {
        hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_CLIENT_CONNECTION_RETRY_LIMIT, 0);
        try {
            TestRetryingThriftCLIServiceClient.startHiveServer2WithConf(hiveConf);
            RetryingThriftCLIServiceClient.CLIServiceClientWrapper client = RetryingThriftCLIServiceClientTest.newRetryingCLIServiceClient(hiveConf);
            client.closeTransport();
            try {
                client.openSession("anonymous", "anonymous");
                Assert.fail((String)"Shouldn't be able to open session when transport is closed.");
            }
            catch (HiveSQLException hiveSQLException) {
                // empty catch block
            }
        }
        finally {
            hiveConf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_CLIENT_CONNECTION_RETRY_LIMIT, 3);
            TestRetryingThriftCLIServiceClient.stopHiveServer2();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionLifeAfterTransportClose() throws Exception {
        try {
            TestRetryingThriftCLIServiceClient.startHiveServer2WithConf(hiveConf);
            CLIService service = null;
            for (Service s : hiveServer2.getServices()) {
                if (!(s instanceof CLIService)) continue;
                service = (CLIService)s;
            }
            if (service == null) {
                service = new CLIService(hiveServer2, true);
            }
            RetryingThriftCLIServiceClient.CLIServiceClientWrapper client = RetryingThriftCLIServiceClientTest.newRetryingCLIServiceClient(hiveConf);
            HashMap<String, String> conf = new HashMap<String, String>();
            conf.put(HiveConf.ConfVars.HIVE_SERVER2_CLOSE_SESSION_ON_DISCONNECT.varname, "false");
            SessionHandle sessionHandle = client.openSession("anonymous", "anonymous", conf);
            Assert.assertNotNull((Object)sessionHandle);
            HiveSession session = service.getSessionManager().getSession(sessionHandle);
            OperationHandle op1 = session.executeStatementAsync("show databases", null);
            Assert.assertNotNull((Object)op1);
            client.closeTransport();
            Assert.assertEquals((Object)session, (Object)service.getSessionManager().getSession(sessionHandle));
            OperationHandle op2 = session.executeStatementAsync("show databases", null);
            Assert.assertNotNull((Object)op2);
            client = RetryingThriftCLIServiceClientTest.newRetryingCLIServiceClient(hiveConf);
            client.closeSession(sessionHandle);
            for (OperationHandle op : new OperationHandle[]{op1, op2}) {
                try {
                    client.getOperationStatus(op, false);
                    Assert.fail((String)"Should have failed.");
                }
                catch (HiveSQLException hiveSQLException) {
                    // empty catch block
                }
            }
        }
        finally {
            TestRetryingThriftCLIServiceClient.stopHiveServer2();
        }
    }

    static class RetryingThriftCLIServiceClientTest
    extends RetryingThriftCLIServiceClient {
        int callCount = 0;
        int connectCount = 0;
        static RetryingThriftCLIServiceClientTest handlerInst;

        protected RetryingThriftCLIServiceClientTest(HiveConf conf) {
            super(conf);
        }

        public static RetryingThriftCLIServiceClient.CLIServiceClientWrapper newRetryingCLIServiceClient(HiveConf conf) throws HiveSQLException {
            handlerInst = new RetryingThriftCLIServiceClientTest(conf);
            TTransport tTransport = handlerInst.connectWithRetry(conf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_CLIENT_RETRY_LIMIT));
            ICLIService cliService = (ICLIService)Proxy.newProxyInstance(RetryingThriftCLIServiceClientTest.class.getClassLoader(), CLIServiceClient.class.getInterfaces(), (InvocationHandler)((Object)handlerInst));
            return new RetryingThriftCLIServiceClient.CLIServiceClientWrapper(cliService, tTransport, conf);
        }

        protected RetryingThriftCLIServiceClient.InvocationResult invokeInternal(Method method, Object[] args) throws Throwable {
            System.out.println("## Calling: " + method.getName() + ", " + this.callCount + "/" + this.getRetryLimit());
            ++this.callCount;
            return super.invokeInternal(method, args);
        }

        protected synchronized TTransport connect(HiveConf conf) throws HiveSQLException, TTransportException {
            ++this.connectCount;
            return super.connect(conf);
        }
    }
}

