/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.rpc.thrift.TStatus;
import org.apache.hive.service.rpc.thrift.TStatusCode;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveSQLException {
    @Test
    public void testExceptionToTStatus() {
        Exception ex1 = TestHiveSQLException.createException();
        ex1.initCause(TestHiveSQLException.createSimpleCause());
        TStatus status = HiveSQLException.toTStatus((Exception)ex1);
        Assert.assertEquals((Object)TStatusCode.ERROR_STATUS, (Object)status.getStatusCode());
        Assert.assertEquals((Object)ex1.getMessage(), (Object)status.getErrorMessage());
        Assert.assertEquals((Object)HiveSQLException.DEFAULT_INFO, (Object)status.getInfoMessages());
    }

    @Test
    public void testHiveSQLExceptionToTStatus() {
        String expectedMessage = "reason";
        String expectedSqlState = "sqlState";
        int expectedVendorCode = 10;
        HiveSQLException ex1 = new HiveSQLException(expectedMessage, expectedSqlState, expectedVendorCode, (Throwable)TestHiveSQLException.createSimpleCause());
        TStatus status = HiveSQLException.toTStatus((Exception)((Object)ex1));
        Assert.assertEquals((Object)TStatusCode.ERROR_STATUS, (Object)status.getStatusCode());
        Assert.assertEquals((Object)expectedSqlState, (Object)status.getSqlState());
        Assert.assertEquals((Object)expectedMessage, (Object)status.getErrorMessage());
        Assert.assertEquals((Object)HiveSQLException.DEFAULT_INFO, (Object)status.getInfoMessages());
    }

    private static Exception createException() {
        return new RuntimeException("exception1");
    }

    private static Exception createSimpleCause() {
        return new UnsupportedOperationException("exception2");
    }

    static interface Dummy {
        public void testExceptionConversion();
    }
}

