/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.common.IPStackUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.session.SessionManager;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestCLIServiceConnectionLimits {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private int limit = 10;
    private HiveConf conf = new HiveConf();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoLimit() throws HiveSQLException {
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER, 0);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_IPADDRESS, 0);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER_IPADDRESS, 0);
        CLIService service = this.getService(this.conf);
        ArrayList<SessionHandle> sessionHandles = new ArrayList<SessionHandle>();
        try {
            for (int i = 0; i < this.limit + 1; ++i) {
                SessionHandle session = service.openSession(CLIService.SERVER_VERSION, "foo", "bar", IPStackUtils.resolveLoopbackAddress(), null);
                sessionHandles.add(session);
            }
        }
        finally {
            for (SessionHandle sessionHandle : sessionHandles) {
                service.closeSession(sessionHandle);
            }
            service.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementAndDecrementConnectionsUser() throws HiveSQLException {
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER, 10);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_IPADDRESS, 0);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER_IPADDRESS, 0);
        CLIService service = this.getService(this.conf);
        ArrayList<SessionHandle> sessionHandles = new ArrayList<SessionHandle>();
        try {
            SessionHandle session;
            for (int i = 0; i < this.limit / 2; ++i) {
                session = service.openSession(CLIService.SERVER_VERSION, "foo", "bar", IPStackUtils.resolveLoopbackAddress(), null);
                sessionHandles.add(session);
            }
            for (SessionHandle sessionHandle : sessionHandles) {
                service.closeSession(sessionHandle);
            }
            sessionHandles.clear();
            for (int i = 0; i < this.limit; ++i) {
                session = service.openSession(CLIService.SERVER_VERSION, "ff", "bar", IPStackUtils.resolveLoopbackAddress(), null);
                sessionHandles.add(session);
            }
        }
        finally {
            for (SessionHandle sessionHandle : sessionHandles) {
                service.closeSession(sessionHandle);
            }
            service.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidUserName() throws HiveSQLException {
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER, 10);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_IPADDRESS, 0);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER_IPADDRESS, 0);
        CLIService service = this.getService(this.conf);
        ArrayList<SessionHandle> sessionHandles = new ArrayList<SessionHandle>();
        try {
            SessionHandle session;
            int i;
            for (i = 0; i < this.limit + 1; ++i) {
                session = service.openSession(CLIService.SERVER_VERSION, null, "bar", IPStackUtils.resolveLoopbackAddress(), null);
                sessionHandles.add(session);
            }
            for (i = 0; i < this.limit + 1; ++i) {
                session = service.openSession(CLIService.SERVER_VERSION, "", "bar", IPStackUtils.resolveLoopbackAddress(), null);
                sessionHandles.add(session);
            }
        }
        finally {
            for (SessionHandle sessionHandle : sessionHandles) {
                service.closeSession(sessionHandle);
            }
            service.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidIpaddress() throws HiveSQLException {
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER, 0);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_IPADDRESS, 10);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER_IPADDRESS, 0);
        CLIService service = this.getService(this.conf);
        ArrayList<SessionHandle> sessionHandles = new ArrayList<SessionHandle>();
        try {
            SessionHandle session;
            int i;
            for (i = 0; i < this.limit + 1; ++i) {
                session = service.openSession(CLIService.SERVER_VERSION, "foo", "bar", null, null);
                sessionHandles.add(session);
            }
            for (i = 0; i < this.limit + 1; ++i) {
                session = service.openSession(CLIService.SERVER_VERSION, "foo", "bar", "", null);
                sessionHandles.add(session);
            }
        }
        finally {
            for (SessionHandle sessionHandle : sessionHandles) {
                service.closeSession(sessionHandle);
            }
            service.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidUserIpaddress() throws HiveSQLException {
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER, 0);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_IPADDRESS, 10);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER_IPADDRESS, 0);
        CLIService service = this.getService(this.conf);
        ArrayList<SessionHandle> sessionHandles = new ArrayList<SessionHandle>();
        try {
            for (int i = 0; i < this.limit + 1; ++i) {
                SessionHandle session = service.openSession(CLIService.SERVER_VERSION, "   ", "bar", null, null);
                sessionHandles.add(session);
            }
        }
        finally {
            for (SessionHandle sessionHandle : sessionHandles) {
                service.closeSession(sessionHandle);
            }
            service.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionLimitPerUser() throws HiveSQLException {
        this.thrown.expect(HiveSQLException.class);
        this.thrown.expectMessage("Connection limit per user reached (user: foo limit: 10)");
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER, 10);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_IPADDRESS, 0);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER_IPADDRESS, 0);
        CLIService service = this.getService(this.conf);
        ArrayList<SessionHandle> sessionHandles = new ArrayList<SessionHandle>();
        try {
            for (int i = 0; i < this.limit + 1; ++i) {
                SessionHandle session = service.openSession(CLIService.SERVER_VERSION, "foo", "bar", IPStackUtils.resolveLoopbackAddress(), null);
                sessionHandles.add(session);
            }
        }
        finally {
            for (SessionHandle sessionHandle : sessionHandles) {
                service.closeSession(sessionHandle);
            }
            service.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionLimitPerIpAddress() throws HiveSQLException {
        this.thrown.expect(HiveSQLException.class);
        this.thrown.expectMessage(String.format("Connection limit per ipaddress reached (ipaddress: %s limit: 10)", IPStackUtils.resolveLoopbackAddress()));
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER, 0);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_IPADDRESS, 10);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER_IPADDRESS, 0);
        CLIService service = this.getService(this.conf);
        ArrayList<SessionHandle> sessionHandles = new ArrayList<SessionHandle>();
        try {
            for (int i = 0; i < this.limit + 1; ++i) {
                SessionHandle session = service.openSession(CLIService.SERVER_VERSION, "foo", "bar", IPStackUtils.resolveLoopbackAddress(), null);
                sessionHandles.add(session);
            }
        }
        finally {
            for (SessionHandle sessionHandle : sessionHandles) {
                service.closeSession(sessionHandle);
            }
            service.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionLimitPerUserIpAddress() throws HiveSQLException {
        this.thrown.expect(HiveSQLException.class);
        this.thrown.expectMessage(String.format("Connection limit per user:ipaddress reached (user:ipaddress: foo:%s limit: 10)", IPStackUtils.resolveLoopbackAddress()));
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER, 0);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_IPADDRESS, 0);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER_IPADDRESS, 10);
        CLIService service = this.getService(this.conf);
        ArrayList<SessionHandle> sessionHandles = new ArrayList<SessionHandle>();
        try {
            for (int i = 0; i < this.limit + 1; ++i) {
                SessionHandle session = service.openSession(CLIService.SERVER_VERSION, "foo", "bar", IPStackUtils.resolveLoopbackAddress(), null);
                sessionHandles.add(session);
            }
        }
        finally {
            for (SessionHandle sessionHandle : sessionHandles) {
                service.closeSession(sessionHandle);
            }
            service.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionMultipleLimitsUserAndIP() throws HiveSQLException {
        this.thrown.expect(HiveSQLException.class);
        this.thrown.expectMessage("Connection limit per user reached (user: foo limit: 5)");
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER, 5);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_IPADDRESS, 10);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER_IPADDRESS, 0);
        CLIService service = this.getService(this.conf);
        ArrayList<SessionHandle> sessionHandles = new ArrayList<SessionHandle>();
        try {
            for (int i = 0; i < this.limit + 1; ++i) {
                SessionHandle session = service.openSession(CLIService.SERVER_VERSION, "foo", "bar", IPStackUtils.resolveLoopbackAddress(), null);
                sessionHandles.add(session);
            }
        }
        finally {
            for (SessionHandle sessionHandle : sessionHandles) {
                service.closeSession(sessionHandle);
            }
            service.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionMultipleLimitsIPAndUserIP() throws HiveSQLException {
        this.thrown.expect(HiveSQLException.class);
        this.thrown.expectMessage(String.format("Connection limit per ipaddress reached (ipaddress: %s limit: 5)", IPStackUtils.resolveLoopbackAddress()));
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER, 0);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_IPADDRESS, 5);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER_IPADDRESS, 10);
        CLIService service = this.getService(this.conf);
        ArrayList<SessionHandle> sessionHandles = new ArrayList<SessionHandle>();
        try {
            for (int i = 0; i < this.limit + 1; ++i) {
                SessionHandle session = service.openSession(CLIService.SERVER_VERSION, "foo", "bar", IPStackUtils.resolveLoopbackAddress(), null);
                sessionHandles.add(session);
            }
        }
        finally {
            for (SessionHandle sessionHandle : sessionHandles) {
                service.closeSession(sessionHandle);
            }
            service.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionMultipleLimitsUserIPAndUser() throws HiveSQLException {
        this.thrown.expect(HiveSQLException.class);
        this.thrown.expectMessage(String.format("Connection limit per user:ipaddress reached (user:ipaddress: foo:%s limit: 10)", IPStackUtils.resolveLoopbackAddress()));
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER, 15);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_IPADDRESS, 0);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER_IPADDRESS, 10);
        CLIService service = this.getService(this.conf);
        ArrayList<SessionHandle> sessionHandles = new ArrayList<SessionHandle>();
        try {
            for (int i = 0; i < this.limit + 1; ++i) {
                SessionHandle session = service.openSession(CLIService.SERVER_VERSION, "foo", "bar", IPStackUtils.resolveLoopbackAddress(), null);
                sessionHandles.add(session);
            }
        }
        finally {
            for (SessionHandle sessionHandle : sessionHandles) {
                service.closeSession(sessionHandle);
            }
            service.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionForwardedIpAddresses() throws HiveSQLException {
        this.thrown.expect(HiveSQLException.class);
        this.thrown.expectMessage(String.format("Connection limit per ipaddress reached (ipaddress: %s limit: 10)", IPStackUtils.transformToIPv6((String)"194.167.0.3")));
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER, 0);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_IPADDRESS, 10);
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LIMIT_CONNECTIONS_PER_USER_IPADDRESS, 10);
        CLIService service = this.getService(this.conf);
        SessionManager.setForwardedAddresses((List)Lists.newArrayList((Object[])new String[]{IPStackUtils.transformToIPv6((String)"194.167.0.3"), IPStackUtils.transformToIPv6((String)"194.167.0.2"), IPStackUtils.transformToIPv6((String)"194.167.0.1")}));
        ArrayList<SessionHandle> sessionHandles = new ArrayList<SessionHandle>();
        try {
            for (int i = 0; i < this.limit + 1; ++i) {
                SessionHandle session = service.openSession(CLIService.SERVER_VERSION, "foo", "bar", IPStackUtils.transformToIPv6((String)"194.167.0.1"), null);
                sessionHandles.add(session);
            }
        }
        finally {
            SessionManager.setForwardedAddresses(Collections.emptyList());
            for (SessionHandle sessionHandle : sessionHandles) {
                service.closeSession(sessionHandle);
            }
            service.stop();
        }
    }

    private CLIService getService(HiveConf conf) {
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        CLIService service = new CLIService(null, true);
        service.init(conf);
        service.start();
        return service;
    }
}

