/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.ldap;

import java.io.IOException;
import javax.naming.NamingException;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.ldap.ChainFilterFactory;
import org.apache.hive.service.auth.ldap.DirSearch;
import org.apache.hive.service.auth.ldap.Filter;
import org.apache.hive.service.auth.ldap.FilterFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestChainFilter {
    private FilterFactory factory;
    private HiveConf conf;
    @Mock
    public Filter filter1;
    @Mock
    public Filter filter2;
    @Mock
    public Filter filter3;
    @Mock
    public FilterFactory factory1;
    @Mock
    public FilterFactory factory2;
    @Mock
    public FilterFactory factory3;
    @Mock
    private DirSearch search;

    @Before
    public void setup() {
        this.conf = new HiveConf();
        this.factory = new ChainFilterFactory(new FilterFactory[]{this.factory1, this.factory2, this.factory3});
    }

    @Test
    public void testFactoryAllNull() {
        Assert.assertNull((Object)this.factory.getInstance(this.conf));
    }

    @Test
    public void testFactoryAllEmpty() {
        ChainFilterFactory emptyFactory = new ChainFilterFactory(new FilterFactory[0]);
        Assert.assertNull((Object)emptyFactory.getInstance(this.conf));
    }

    @Test
    public void testFactory() throws AuthenticationException {
        Mockito.when((Object)this.factory1.getInstance((HiveConf)Mockito.any(HiveConf.class))).thenReturn((Object)this.filter1);
        Mockito.when((Object)this.factory2.getInstance((HiveConf)Mockito.any(HiveConf.class))).thenReturn((Object)this.filter2);
        Mockito.when((Object)this.factory3.getInstance((HiveConf)Mockito.any(HiveConf.class))).thenReturn((Object)this.filter3);
        Filter filter = this.factory.getInstance(this.conf);
        filter.apply(this.search, "User");
        ((Filter)Mockito.verify((Object)this.filter1, (VerificationMode)Mockito.times((int)1))).apply(this.search, "User");
        ((Filter)Mockito.verify((Object)this.filter2, (VerificationMode)Mockito.times((int)1))).apply(this.search, "User");
        ((Filter)Mockito.verify((Object)this.filter3, (VerificationMode)Mockito.times((int)1))).apply(this.search, "User");
    }

    @Test(expected=AuthenticationException.class)
    public void testApplyNegative() throws AuthenticationException, NamingException, IOException {
        ((Filter)Mockito.doThrow(AuthenticationException.class).when((Object)this.filter3)).apply((DirSearch)Mockito.any(), Mockito.anyString());
        Mockito.when((Object)this.factory1.getInstance((HiveConf)Mockito.any(HiveConf.class))).thenReturn((Object)this.filter1);
        Mockito.when((Object)this.factory3.getInstance((HiveConf)Mockito.any(HiveConf.class))).thenReturn((Object)this.filter3);
        Filter filter = this.factory.getInstance(this.conf);
        filter.apply(this.search, "User");
    }
}

