/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.PlainSaslHelper;
import org.apache.hive.service.auth.TSetIpAddressProcessor;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.thrift.ThriftBinaryCLIService;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.thrift.TProcessorFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestPlainSaslHelper {
    @Test
    public void testDoAsSetting() {
        HiveConf hconf = new HiveConf();
        hconf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        Assert.assertTrue((String)"default value of hive server2 doAs should be true", (boolean)hconf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS));
        CLIService cliService = new CLIService(null, true);
        cliService.init(hconf);
        ThriftBinaryCLIService tcliService = new ThriftBinaryCLIService(cliService);
        tcliService.init(hconf);
        TProcessorFactory procFactory = PlainSaslHelper.getPlainProcessorFactory((TCLIService.Iface)tcliService);
        Assert.assertEquals((String)"doAs enabled processor for unsecure mode", procFactory.getProcessor(null).getClass(), TSetIpAddressProcessor.class);
    }
}

