/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.io.IOException;
import java.util.Arrays;
import javax.naming.NamingException;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.LdapAuthenticationProviderImpl;
import org.apache.hive.service.auth.ldap.DirSearch;
import org.apache.hive.service.auth.ldap.DirSearchFactory;
import org.apache.hive.service.auth.ldap.LdapSearchFactory;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestLdapAuthenticationProviderImpl {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    public HiveConf conf;
    public LdapAuthenticationProviderImpl auth;
    @Mock
    public DirSearchFactory factory;
    @Mock
    public DirSearch search;

    @Before
    public void setup() throws AuthenticationException {
        this.conf = new HiveConf();
        this.conf.set("hive.root.logger", "DEBUG,console");
        this.conf.set("hive.server2.authentication.ldap.url", "localhost");
        Mockito.when((Object)this.factory.getInstance((HiveConf)Mockito.any(HiveConf.class), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)this.search);
    }

    @Test
    public void authenticateGivenBlankPassword() throws Exception {
        this.auth = new LdapAuthenticationProviderImpl(this.conf, (DirSearchFactory)new LdapSearchFactory());
        this.expectAuthenticationExceptionForInvalidPassword();
        this.auth.authenticate("user", "");
    }

    @Test
    public void authenticateGivenStringWithNullCharacterForPassword() throws Exception {
        this.auth = new LdapAuthenticationProviderImpl(this.conf, (DirSearchFactory)new LdapSearchFactory());
        this.expectAuthenticationExceptionForInvalidPassword();
        this.auth.authenticate("user", "\u0000");
    }

    @Test
    public void authenticateGivenNullForPassword() throws Exception {
        this.auth = new LdapAuthenticationProviderImpl(this.conf, (DirSearchFactory)new LdapSearchFactory());
        this.expectAuthenticationExceptionForInvalidPassword();
        this.auth.authenticate("user", null);
    }

    @Test
    public void testAuthenticateNoUserOrGroupFilter() throws NamingException, AuthenticationException, IOException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERDNPATTERN, "cn=%s,ou=Users,dc=mycorp,dc=com:cn=%s,ou=PowerUsers,dc=mycorp,dc=com");
        DirSearchFactory factory = (DirSearchFactory)Mockito.mock(DirSearchFactory.class);
        Mockito.lenient().when((Object)this.search.findUserDn("user1")).thenReturn((Object)"cn=user1,ou=PowerUsers,dc=mycorp,dc=com");
        Mockito.when((Object)factory.getInstance(this.conf, "cn=user1,ou=PowerUsers,dc=mycorp,dc=com", "Blah")).thenReturn((Object)this.search);
        Mockito.when((Object)factory.getInstance(this.conf, "cn=user1,ou=Users,dc=mycorp,dc=com", "Blah")).thenThrow(AuthenticationException.class);
        this.auth = new LdapAuthenticationProviderImpl(this.conf, factory);
        this.auth.authenticate("user1", "Blah");
        ((DirSearchFactory)Mockito.verify((Object)factory, (VerificationMode)Mockito.times((int)2))).getInstance((HiveConf)Mockito.isA(HiveConf.class), Mockito.anyString(), (String)Mockito.eq((Object)"Blah"));
        ((DirSearch)Mockito.verify((Object)this.search, (VerificationMode)Mockito.atLeastOnce())).close();
    }

    @Test
    public void testAuthenticateWhenUserFilterPasses() throws NamingException, AuthenticationException, IOException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERFILTER, "user1,user2");
        Mockito.when((Object)this.search.findUserDn("user1")).thenReturn((Object)"cn=user1,ou=PowerUsers,dc=mycorp,dc=com");
        Mockito.when((Object)this.search.findUserDn("user2")).thenReturn((Object)"cn=user2,ou=PowerUsers,dc=mycorp,dc=com");
        this.authenticateUserAndCheckSearchIsClosed("user1");
        this.authenticateUserAndCheckSearchIsClosed("user2");
    }

    @Test
    public void testAuthenticateWhenLoginWithDomainAndUserFilterPasses() throws NamingException, AuthenticationException, IOException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERFILTER, "user1");
        Mockito.when((Object)this.search.findUserDn("user1")).thenReturn((Object)"cn=user1,ou=PowerUsers,dc=mycorp,dc=com");
        this.authenticateUserAndCheckSearchIsClosed("user1@mydomain.com");
    }

    @Test
    public void testAuthenticateWhenLoginWithDnAndUserFilterPasses() throws NamingException, AuthenticationException, IOException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERFILTER, "user1");
        Mockito.when((Object)this.search.findUserDn("cn=user1,ou=PowerUsers,dc=mycorp,dc=com")).thenReturn((Object)"cn=user1,ou=PowerUsers,dc=mycorp,dc=com");
        this.authenticateUserAndCheckSearchIsClosed("cn=user1,ou=PowerUsers,dc=mycorp,dc=com");
    }

    @Test
    public void testAuthenticateWhenUserSearchFails() throws NamingException, AuthenticationException, IOException {
        this.thrown.expect(AuthenticationException.class);
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERFILTER, "user1,user2");
        Mockito.when((Object)this.search.findUserDn("user1")).thenReturn(null);
        this.authenticateUserAndCheckSearchIsClosed("user1");
    }

    @Test
    public void testAuthenticateWhenUserFilterFails() throws NamingException, AuthenticationException, IOException {
        this.thrown.expect(AuthenticationException.class);
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERFILTER, "user1,user2");
        Mockito.when((Object)this.search.findUserDn("user3")).thenReturn((Object)"cn=user3,ou=PowerUsers,dc=mycorp,dc=com");
        this.authenticateUserAndCheckSearchIsClosed("user3");
    }

    @Test
    public void testAuthenticateWhenGroupMembershipKeyFilterPasses() throws NamingException, AuthenticationException, IOException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPFILTER, "group1,group2");
        Mockito.when((Object)this.search.findUserDn("user1")).thenReturn((Object)"cn=user1,ou=PowerUsers,dc=mycorp,dc=com");
        Mockito.when((Object)this.search.findUserDn("user2")).thenReturn((Object)"cn=user2,ou=PowerUsers,dc=mycorp,dc=com");
        Mockito.when((Object)this.search.findGroupsForUser("cn=user1,ou=PowerUsers,dc=mycorp,dc=com")).thenReturn(Arrays.asList("cn=testGroup,ou=Groups,dc=mycorp,dc=com", "cn=group1,ou=Groups,dc=mycorp,dc=com"));
        Mockito.when((Object)this.search.findGroupsForUser("cn=user2,ou=PowerUsers,dc=mycorp,dc=com")).thenReturn(Arrays.asList("cn=testGroup,ou=Groups,dc=mycorp,dc=com", "cn=group2,ou=Groups,dc=mycorp,dc=com"));
        this.authenticateUserAndCheckSearchIsClosed("user1");
        this.authenticateUserAndCheckSearchIsClosed("user2");
    }

    @Test
    public void testAuthenticateWhenUserAndGroupMembershipKeyFiltersPass() throws NamingException, AuthenticationException, IOException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPFILTER, "group1,group2");
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERFILTER, "user1,user2");
        Mockito.when((Object)this.search.findUserDn("user1")).thenReturn((Object)"cn=user1,ou=PowerUsers,dc=mycorp,dc=com");
        Mockito.when((Object)this.search.findUserDn("user2")).thenReturn((Object)"cn=user2,ou=PowerUsers,dc=mycorp,dc=com");
        Mockito.when((Object)this.search.findGroupsForUser("cn=user1,ou=PowerUsers,dc=mycorp,dc=com")).thenReturn(Arrays.asList("cn=testGroup,ou=Groups,dc=mycorp,dc=com", "cn=group1,ou=Groups,dc=mycorp,dc=com"));
        Mockito.when((Object)this.search.findGroupsForUser("cn=user2,ou=PowerUsers,dc=mycorp,dc=com")).thenReturn(Arrays.asList("cn=testGroup,ou=Groups,dc=mycorp,dc=com", "cn=group2,ou=Groups,dc=mycorp,dc=com"));
        this.authenticateUserAndCheckSearchIsClosed("user1");
        this.authenticateUserAndCheckSearchIsClosed("user2");
    }

    @Test
    public void testAuthenticateWhenUserFilterPassesAndGroupMembershipKeyFilterFails() throws NamingException, AuthenticationException, IOException {
        this.thrown.expect(AuthenticationException.class);
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPFILTER, "group1,group2");
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERFILTER, "user1,user2");
        Mockito.when((Object)this.search.findUserDn("user1")).thenReturn((Object)"cn=user1,ou=PowerUsers,dc=mycorp,dc=com");
        Mockito.when((Object)this.search.findGroupsForUser("cn=user1,ou=PowerUsers,dc=mycorp,dc=com")).thenReturn(Arrays.asList("cn=testGroup,ou=Groups,dc=mycorp,dc=com", "cn=OtherGroup,ou=Groups,dc=mycorp,dc=com"));
        this.authenticateUserAndCheckSearchIsClosed("user1");
    }

    @Test
    public void testAuthenticateWhenUserFilterFailsAndGroupMembershipKeyFilterPasses() throws NamingException, AuthenticationException, IOException {
        this.thrown.expect(AuthenticationException.class);
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPFILTER, "group3");
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERFILTER, "user1,user2");
        Mockito.when((Object)this.search.findUserDn("user3")).thenReturn((Object)"cn=user3,ou=PowerUsers,dc=mycorp,dc=com");
        Mockito.lenient().when((Object)this.search.findGroupsForUser("cn=user3,ou=PowerUsers,dc=mycorp,dc=com")).thenReturn(Arrays.asList("cn=testGroup,ou=Groups,dc=mycorp,dc=com", "cn=group3,ou=Groups,dc=mycorp,dc=com"));
        this.authenticateUserAndCheckSearchIsClosed("user3");
    }

    @Test
    public void testAuthenticateWhenCustomQueryFilterPasses() throws NamingException, AuthenticationException, IOException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BASEDN, "dc=mycorp,dc=com");
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_CUSTOMLDAPQUERY, "(&(objectClass=person)(|(memberOf=CN=Domain Admins,CN=Users,DC=apache,DC=org)(memberOf=CN=Administrators,CN=Builtin,DC=apache,DC=org)))");
        Mockito.when((Object)this.search.executeCustomQuery(Mockito.anyString())).thenReturn(Arrays.asList("cn=user1,ou=PowerUsers,dc=mycorp,dc=com", "cn=user2,ou=PowerUsers,dc=mycorp,dc=com"));
        this.authenticateUserAndCheckSearchIsClosed("user1");
    }

    @Test
    public void testAuthenticateWhenCustomQueryFilterFailsAndUserFilterPasses() throws NamingException, AuthenticationException, IOException {
        this.thrown.expect(AuthenticationException.class);
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BASEDN, "dc=mycorp,dc=com");
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_CUSTOMLDAPQUERY, "(&(objectClass=person)(|(memberOf=CN=Domain Admins,CN=Users,DC=apache,DC=org)(memberOf=CN=Administrators,CN=Builtin,DC=apache,DC=org)))");
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERFILTER, "user3");
        Mockito.lenient().when((Object)this.search.findUserDn("user3")).thenReturn((Object)"cn=user3,ou=PowerUsers,dc=mycorp,dc=com");
        Mockito.when((Object)this.search.executeCustomQuery(Mockito.anyString())).thenReturn(Arrays.asList("cn=user1,ou=PowerUsers,dc=mycorp,dc=com", "cn=user2,ou=PowerUsers,dc=mycorp,dc=com"));
        this.authenticateUserAndCheckSearchIsClosed("user3");
    }

    @Test
    public void testAuthenticateWhenUserMembershipKeyFilterPasses() throws NamingException, AuthenticationException, IOException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPFILTER, "HIVE-USERS");
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BASEDN, "dc=mycorp,dc=com");
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERMEMBERSHIP_KEY, "memberOf");
        Mockito.when((Object)this.search.findUserDn("user1")).thenReturn((Object)"cn=user1,ou=PowerUsers,dc=mycorp,dc=com");
        String groupDn = "cn=HIVE-USERS,ou=Groups,dc=mycorp,dc=com";
        Mockito.when((Object)this.search.findGroupDn("HIVE-USERS")).thenReturn((Object)groupDn);
        Mockito.when((Object)this.search.isUserMemberOfGroup("user1", groupDn)).thenReturn((Object)true);
        this.auth = new LdapAuthenticationProviderImpl(this.conf, this.factory);
        this.auth.authenticate("user1", "Blah");
        ((DirSearchFactory)Mockito.verify((Object)this.factory, (VerificationMode)Mockito.times((int)1))).getInstance((HiveConf)Mockito.isA(HiveConf.class), Mockito.anyString(), (String)Mockito.eq((Object)"Blah"));
        ((DirSearch)Mockito.verify((Object)this.search, (VerificationMode)Mockito.times((int)1))).findGroupDn(Mockito.anyString());
        ((DirSearch)Mockito.verify((Object)this.search, (VerificationMode)Mockito.times((int)1))).isUserMemberOfGroup(Mockito.anyString(), Mockito.anyString());
        ((DirSearch)Mockito.verify((Object)this.search, (VerificationMode)Mockito.atLeastOnce())).close();
    }

    @Test
    public void testAuthenticateWhenUserMembershipKeyFilterFails() throws NamingException, AuthenticationException, IOException {
        this.thrown.expect(AuthenticationException.class);
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPFILTER, "HIVE-USERS");
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BASEDN, "dc=mycorp,dc=com");
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERMEMBERSHIP_KEY, "memberOf");
        Mockito.when((Object)this.search.findUserDn("user1")).thenReturn((Object)"cn=user1,ou=PowerUsers,dc=mycorp,dc=com");
        String groupDn = "cn=HIVE-USERS,ou=Groups,dc=mycorp,dc=com";
        Mockito.when((Object)this.search.findGroupDn("HIVE-USERS")).thenReturn((Object)groupDn);
        Mockito.when((Object)this.search.isUserMemberOfGroup("user1", groupDn)).thenReturn((Object)false);
        this.auth = new LdapAuthenticationProviderImpl(this.conf, this.factory);
        this.auth.authenticate("user1", "Blah");
    }

    @Test
    public void testAuthenticateWhenUserMembershipKeyFilter2x2PatternsPasses() throws NamingException, AuthenticationException, IOException {
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPFILTER, "HIVE-USERS1,HIVE-USERS2");
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPDNPATTERN, "cn=%s,ou=Groups,ou=branch1,dc=mycorp,dc=com");
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERDNPATTERN, "cn=%s,ou=Userss,ou=branch1,dc=mycorp,dc=com");
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERMEMBERSHIP_KEY, "memberOf");
        Mockito.when((Object)this.search.findUserDn("user1")).thenReturn((Object)"cn=user1,ou=PowerUsers,dc=mycorp,dc=com");
        Mockito.when((Object)this.search.findGroupDn("HIVE-USERS1")).thenReturn((Object)"cn=HIVE-USERS1,ou=Groups,ou=branch1,dc=mycorp,dc=com");
        Mockito.when((Object)this.search.findGroupDn("HIVE-USERS2")).thenReturn((Object)"cn=HIVE-USERS2,ou=Groups,ou=branch1,dc=mycorp,dc=com");
        Mockito.when((Object)this.search.isUserMemberOfGroup("user1", "cn=HIVE-USERS1,ou=Groups,ou=branch1,dc=mycorp,dc=com")).thenThrow(NamingException.class);
        Mockito.when((Object)this.search.isUserMemberOfGroup("user1", "cn=HIVE-USERS2,ou=Groups,ou=branch1,dc=mycorp,dc=com")).thenReturn((Object)true);
        this.auth = new LdapAuthenticationProviderImpl(this.conf, this.factory);
        this.auth.authenticate("user1", "Blah");
        ((DirSearchFactory)Mockito.verify((Object)this.factory, (VerificationMode)Mockito.times((int)1))).getInstance((HiveConf)Mockito.isA(HiveConf.class), Mockito.anyString(), (String)Mockito.eq((Object)"Blah"));
        ((DirSearch)Mockito.verify((Object)this.search, (VerificationMode)Mockito.times((int)2))).findGroupDn(Mockito.anyString());
        ((DirSearch)Mockito.verify((Object)this.search, (VerificationMode)Mockito.times((int)2))).isUserMemberOfGroup(Mockito.anyString(), Mockito.anyString());
        ((DirSearch)Mockito.verify((Object)this.search, (VerificationMode)Mockito.atLeastOnce())).close();
    }

    @Test
    public void testAuthenticateWithBindInCredentialFilePasses() throws AuthenticationException, NamingException {
        String bindUser = "cn=BindUser,ou=Users,ou=branch1,dc=mycorp,dc=com";
        String bindPass = "testPassword";
        String authFullUser = "cn=user1,ou=Users,ou=branch1,dc=mycorp,dc=com";
        String authUser = "user1";
        String authPass = "Blah";
        String tmpDir = System.getProperty("build.dir");
        String credentialsPath = "jceks://file" + tmpDir + "/test-classes/creds/test.jceks";
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BIND_USER, bindUser);
        this.conf.set("hadoop.security.credential.provider.path", credentialsPath);
        System.out.println(tmpDir);
        Mockito.when((Object)this.search.findUserDn((String)Mockito.eq((Object)authUser))).thenReturn((Object)authFullUser);
        this.auth = new LdapAuthenticationProviderImpl(this.conf, this.factory);
        this.auth.authenticate(authUser, authPass);
        ((DirSearchFactory)Mockito.verify((Object)this.factory, (VerificationMode)Mockito.times((int)1))).getInstance((HiveConf)Mockito.isA(HiveConf.class), (String)Mockito.eq((Object)bindUser), (String)Mockito.eq((Object)bindPass));
        ((DirSearchFactory)Mockito.verify((Object)this.factory, (VerificationMode)Mockito.times((int)1))).getInstance((HiveConf)Mockito.isA(HiveConf.class), (String)Mockito.eq((Object)authFullUser), (String)Mockito.eq((Object)authPass));
        ((DirSearch)Mockito.verify((Object)this.search, (VerificationMode)Mockito.times((int)1))).findUserDn((String)Mockito.eq((Object)authUser));
    }

    @Test
    public void testAuthenticateWithBindInMissingCredentialFilePasses() throws AuthenticationException, NamingException {
        String bindUser = "cn=BindUser,ou=Users,ou=branch1,dc=mycorp,dc=com";
        String authUser = "user1";
        String authPass = "Blah";
        String tmpDir = System.getProperty("build.dir");
        String credentialsPath = "jceks://file" + tmpDir + "/test-classes/creds/nonExistent.jceks";
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BIND_USER, bindUser);
        this.conf.set("hadoop.security.credential.provider.path", credentialsPath);
        this.auth = new LdapAuthenticationProviderImpl(this.conf, this.factory);
        this.auth.authenticate(authUser, authPass);
        ((DirSearchFactory)Mockito.verify((Object)this.factory, (VerificationMode)Mockito.times((int)1))).getInstance((HiveConf)Mockito.isA(HiveConf.class), (String)Mockito.eq((Object)authUser), (String)Mockito.eq((Object)authPass));
    }

    @Test
    public void testAuthenticateWithBindUserPasses() throws AuthenticationException, NamingException {
        String bindUser = "cn=BindUser,ou=Users,ou=branch1,dc=mycorp,dc=com";
        String bindPass = "Blah";
        String authFullUser = "cn=user1,ou=Users,ou=branch1,dc=mycorp,dc=com";
        String authUser = "user1";
        String authPass = "Blah2";
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BIND_USER, bindUser);
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BIND_PASSWORD, bindPass);
        Mockito.when((Object)this.search.findUserDn((String)Mockito.eq((Object)authUser))).thenReturn((Object)authFullUser);
        this.auth = new LdapAuthenticationProviderImpl(this.conf, this.factory);
        this.auth.authenticate(authUser, authPass);
        ((DirSearchFactory)Mockito.verify((Object)this.factory, (VerificationMode)Mockito.times((int)1))).getInstance((HiveConf)Mockito.isA(HiveConf.class), (String)Mockito.eq((Object)bindUser), (String)Mockito.eq((Object)bindPass));
        ((DirSearchFactory)Mockito.verify((Object)this.factory, (VerificationMode)Mockito.times((int)1))).getInstance((HiveConf)Mockito.isA(HiveConf.class), (String)Mockito.eq((Object)authFullUser), (String)Mockito.eq((Object)authPass));
        ((DirSearch)Mockito.verify((Object)this.search, (VerificationMode)Mockito.times((int)1))).findUserDn((String)Mockito.eq((Object)authUser));
    }

    @Test
    public void testAuthenticateWithBindUserFailsOnAuthentication() throws AuthenticationException, NamingException {
        String bindUser = "cn=BindUser,ou=Users,ou=branch1,dc=mycorp,dc=com";
        String bindPass = "Blah";
        String authFullUser = "cn=user1,ou=Users,ou=branch1,dc=mycorp,dc=com";
        String authUser = "user1";
        String authPass = "Blah2";
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BIND_USER, bindUser);
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BIND_PASSWORD, bindPass);
        this.thrown.expect(AuthenticationException.class);
        Mockito.when((Object)this.factory.getInstance((HiveConf)Mockito.any(HiveConf.class), (String)Mockito.eq((Object)authFullUser), (String)Mockito.eq((Object)authPass))).thenThrow(AuthenticationException.class);
        Mockito.when((Object)this.search.findUserDn((String)Mockito.eq((Object)authUser))).thenReturn((Object)authFullUser);
        this.auth = new LdapAuthenticationProviderImpl(this.conf, this.factory);
        this.auth.authenticate(authUser, authPass);
    }

    @Test
    public void testAuthenticateWithBindUserFailsOnGettingDn() throws AuthenticationException, NamingException {
        String bindUser = "cn=BindUser,ou=Users,ou=branch1,dc=mycorp,dc=com";
        String bindPass = "Blah";
        String authFullUser = "cn=user1,ou=Users,ou=branch1,dc=mycorp,dc=com";
        String authUser = "user1";
        String authPass = "Blah2";
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BIND_USER, bindUser);
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BIND_PASSWORD, bindPass);
        this.thrown.expect(AuthenticationException.class);
        Mockito.when((Object)this.search.findUserDn((String)Mockito.eq((Object)authUser))).thenThrow(NamingException.class);
        this.auth = new LdapAuthenticationProviderImpl(this.conf, this.factory);
        this.auth.authenticate(authUser, authPass);
    }

    @Test
    public void testAuthenticateWithBindUserFailsOnBinding() throws AuthenticationException {
        String bindUser = "cn=BindUser,ou=Users,ou=branch1,dc=mycorp,dc=com";
        String bindPass = "Blah";
        String authUser = "user1";
        String authPass = "Blah2";
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BIND_USER, bindUser);
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BIND_PASSWORD, bindPass);
        this.thrown.expect(AuthenticationException.class);
        Mockito.when((Object)this.factory.getInstance((HiveConf)Mockito.any(HiveConf.class), (String)Mockito.eq((Object)bindUser), (String)Mockito.eq((Object)bindPass))).thenThrow(AuthenticationException.class);
        this.auth = new LdapAuthenticationProviderImpl(this.conf, this.factory);
        this.auth.authenticate(authUser, authPass);
    }

    private void expectAuthenticationExceptionForInvalidPassword() {
        this.thrown.expect(AuthenticationException.class);
        this.thrown.expectMessage("a null or blank password has been provided");
    }

    private void authenticateUserAndCheckSearchIsClosed(String user) throws IOException {
        this.auth = new LdapAuthenticationProviderImpl(this.conf, this.factory);
        try {
            this.auth.authenticate(user, "password doesn't matter");
        }
        finally {
            ((DirSearch)Mockito.verify((Object)this.search, (VerificationMode)Mockito.atLeastOnce())).close();
        }
    }
}

